/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.xsl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.net.URL;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.ide.component.NewFilePanel;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.xsl.XSLFileBuilderModel;

public class NewXSLFilePanel
extends NewFilePanel
implements BaliWizardPanel {
    private JLabel XSLVersionLabel;
    private JComboBox XSLVersionCombo;
    private final String textXSL10;
    private final String textXSL20;

    private void $init$() {
        this.XSLVersionLabel = new JLabel();
        this.XSLVersionCombo = new JComboBox();
        this.textXSL10 = "XSL 1.0";
        this.textXSL20 = "XSL 2.0";
    }

    public NewXSLFilePanel() {
        this.$init$();
        this.setSupportsAutoFill(false);
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.XSLVersionCombo.addItem("XSL 1.0");
        this.XSLVersionCombo.addItem("XSL 2.0");
        this.XSLVersionLabel.setText(WizardsArb.getString(18));
        if (this.getLayoutOrientation() == 1) {
            GridBagConstraints gridSettings = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0);
            this.add(this.XSLVersionLabel, gridSettings);
            gridSettings = new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.add(this.XSLVersionCombo, gridSettings);
        } else {
            GridBagConstraints gridSettings = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 0, 5), 0, 0);
            this.add(this.XSLVersionLabel, gridSettings);
            gridSettings = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0);
            this.add(this.XSLVersionCombo, gridSettings);
        }
    }

    public void initializeFromState(BaliWizardState state) {
        XSLFileBuilderModel model = (XSLFileBuilderModel)state;
        this.setFileExtension(model.getFileExtension());
        this.setFileType(model.getFileType());
        this.setEnforceFileExtension(model.getEnforceFileExtension());
        this.setDirectoryURL(model.getDirectory());
        this.setFileName(model.getFileName());
        this.setCanOverwriteOpenNodes(true);
        this.setNewFileURLValidator(model);
        if (model.getIsXSL20VersionFlag()) {
            this.XSLVersionCombo.setSelectedItem("XSL 2.0");
        } else {
            this.XSLVersionCombo.setSelectedItem("XSL 1.0");
        }
    }

    public boolean validateAndWriteToState(BaliWizardState state) {
        XSLFileBuilderModel model = (XSLFileBuilderModel)state;
        boolean isXSL20VersionSelected = false;
        if ((String)this.XSLVersionCombo.getSelectedItem() == "XSL 2.0") {
            isXSL20VersionSelected = true;
        }
        model.setIsXSL20VersionFlag(isXSL20VersionSelected);
        try {
            URL url = this.getFileURL();
            if (url != null) {
                model.setURL(url);
                boolean bl = true;
                return bl;
            }
        }
        catch (TraversalException ex) {
            ex.showMessageDialog((Component)((Object)this));
        }
        return false;
    }
}

