/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.xsl;

import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdevimpl.resource.WizardsArb;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSLFileBuilderModel
extends FileBuilderModel {
    private static final String EXT = ".xsl";
    private boolean isXSL20VersionFlag;
    private static final String _XSL_NAMESPACE = "http://www.w3.org/1999/XSL/Transform";

    private void $init$() {
        this.isXSL20VersionFlag = true;
    }

    public void setIsXSL20VersionFlag(boolean aFlag) {
        this.isXSL20VersionFlag = aFlag;
    }

    public boolean getIsXSL20VersionFlag() {
        return this.isXSL20VersionFlag;
    }

    public XSLFileBuilderModel(Context ctx) {
        super(ctx, EXT);
        this.$init$();
    }

    public String getFileType() {
        return WizardsArb.getString(318);
    }

    public String getBuilderType() {
        return "XSL File";
    }

    protected String getBaseName() {
        return WizardsArb.getString(371);
    }

    protected boolean buildFile(Node node) {
        if (super.buildFile(node)) {
            XmlModel model = ((XMLSourceNode)node).getModel(null);
            model.getDomModel().setXmlDeclarationInfo(new XmlDeclarationInfo(XmlDeclarationInfo.VERSION_1_0, IdeUtil.getIdeIanaEncoding(), null));
            model.startTransaction("initialize file");
            try {
                Document doc = model.getDocument();
                Element root = doc.createElementNS(_XSL_NAMESPACE, "xsl:stylesheet");
                if (this.isXSL20VersionFlag) {
                    root.setAttributeNS(null, "version", "2.0");
                } else {
                    root.setAttributeNS(null, "version", "1.0");
                }
                DomUtils.addXmlns((Element)root, (String)"xsl", (String)_XSL_NAMESPACE);
                doc.appendChild(root);
                DomPosition insideRoot = DomPositionFactory.createDomPosition((org.w3c.dom.Node)root, (int)0);
                Element template = doc.createElementNS(_XSL_NAMESPACE, "xsl:template");
                template.setAttributeNS(null, "match", "/");
                template.appendChild(doc.createTextNode("\n"));
                root.appendChild(doc.createComment(" Root template "));
                root.appendChild(template);
                model.commitTransaction(false);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                model.rollbackTransaction();
            }
            return true;
        }
        return false;
    }
}

