/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayElementList
implements ElementList {
    private final Class _type;
    private Object[] _data;
    private final boolean _supportCreate;
    private boolean _bufferEvents;
    private ArrayList _bufferedEvents;
    private EventListenerList _listeners;
    private static final int ADD = 1;
    private static final int REMOVE = 2;
    private static final int CHANGE = 3;

    public ArrayElementList(Class type, Object[] data) {
        this(type, data, true);
    }

    public ArrayElementList(Class type, Object[] data, boolean supportCreate) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this._type = type;
        this._data = data != null ? data : this.newArray(0);
        this._supportCreate = supportCreate;
    }

    public void add(int index, Object element) {
        this.checkType(element);
        int curLen = this.size();
        if (index < 0 || index > curLen) {
            throw new IndexOutOfBoundsException();
        }
        int newSize = curLen + 1;
        Object[] newArray = this.newArray(newSize);
        System.arraycopy(this._data, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(this._data, index, newArray, index + 1, curLen - index);
        this._data = newArray;
        this.fireElementsAdded(index, index);
    }

    public void add(Object element) {
        this.checkType(element);
        int curLen = this.size();
        int newSize = curLen + 1;
        Object[] newArray = this.newArray(newSize);
        System.arraycopy(this._data, 0, newArray, 0, curLen);
        newArray[curLen] = element;
        this._data = newArray;
        if (this._listeners != null) {
            int index = this.size() - 1;
            this.fireElementsAdded(index, index);
        }
    }

    public void addElementListListener(ElementListListener listener) {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        this._listeners.add(ElementListListener.class, listener);
    }

    public void clear() {
        int n = this.size();
        this._data = this.newArray(0);
        if (n > 0) {
            this.fireElementsRemoved(0, n - 1);
        }
    }

    public Object createElement() {
        if (this._supportCreate) {
            try {
                Object t = this._type.newInstance();
                return t;
            }
            catch (Exception e) {
                IllegalStateException ex = new IllegalStateException();
                ex.initCause(e);
                throw ex;
            }
        }
        return new Object();
    }

    public Class elementType() {
        return this._type;
    }

    public Object get(int index) {
        return this._data[index];
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new 1();
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int curLen = this.size();
        int newLen = curLen - 1;
        Object[] newArray = this.newArray(newLen);
        System.arraycopy(this._data, 0, newArray, 0, index);
        Object removedObj = this._data[index];
        System.arraycopy(this._data, index + 1, newArray, index, newLen - index);
        this._data = newArray;
        this.fireElementsRemoved(index, index);
        return removedObj;
    }

    public void removeElementListListener(ElementListListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(ElementListListener.class, listener);
        }
    }

    public Object set(int index, Object element) {
        this.checkType(element);
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Object removedObj = this._data[index];
        this._data[index] = element;
        this.fireElementsChanged(index, index);
        return removedObj;
    }

    public int size() {
        return this._data.length;
    }

    public Object[] getData() {
        return this._data;
    }

    private void startBufferingEvents() {
        if (!this._bufferEvents) {
            this._bufferEvents = true;
            this._bufferedEvents = new ArrayList();
        }
    }

    private void stopBufferingEvents() {
        if (this._bufferEvents) {
            this.fireBufferedEvents();
            this._bufferedEvents = null;
            this._bufferEvents = false;
        }
    }

    private Object[] newArray(int size) {
        return (Object[])Array.newInstance(this._type, size);
    }

    private void checkType(Object obj) {
        if (obj != null && !this._type.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException();
        }
    }

    private void fireBufferedEvents() {
        if (this._bufferedEvents != null) {
            for (int[] eventDesc : this._bufferedEvents) {
                int eventType = eventDesc[0];
                int startIndex = eventDesc[1];
                int endIndex = eventDesc[2];
                switch (eventType) {
                    case 1: {
                        this.fireElementsAdded0(startIndex, endIndex);
                        break;
                    }
                    case 2: {
                        this.fireElementsRemoved0(startIndex, endIndex);
                        break;
                    }
                    case 3: {
                        this.fireElementsChanged0(startIndex, endIndex);
                        break;
                    }
                }
            }
        }
    }

    private void fireElementsAdded(int start, int end) {
        if (this._bufferEvents) {
            this._bufferedEvents.add(new int[]{1, start, end});
        } else {
            this.fireElementsAdded0(start, end);
        }
    }

    private void fireElementsAdded0(int start, int end) {
        if (this._listeners != null) {
            Object[] listeners = this._listeners.getListenerList();
            ElementListEvent event = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == ElementListListener.class) {
                    if (event == null) {
                        event = new ElementListEvent((Object)this, start, end);
                    }
                    ((ElementListListener)listeners[i + 1]).elementsAdded(event);
                }
                i -= 2;
            }
        }
    }

    private void fireElementsRemoved(int start, int end) {
        if (this._bufferEvents) {
            this._bufferedEvents.add(new int[]{2, start, end});
        } else {
            this.fireElementsRemoved0(start, end);
        }
    }

    private void fireElementsRemoved0(int start, int end) {
        if (this._listeners != null) {
            Object[] listeners = this._listeners.getListenerList();
            ElementListEvent event = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == ElementListListener.class) {
                    if (event == null) {
                        event = new ElementListEvent((Object)this, start, end);
                    }
                    ((ElementListListener)listeners[i + 1]).elementsRemoved(event);
                }
                i -= 2;
            }
        }
    }

    private void fireElementsChanged(int start, int end) {
        if (this._bufferEvents) {
            this._bufferedEvents.add(new int[]{3, start, end});
        } else {
            this.fireElementsChanged0(start, end);
        }
    }

    private void fireElementsChanged0(int start, int end) {
        if (this._listeners != null) {
            Object[] listeners = this._listeners.getListenerList();
            ElementListEvent event = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == ElementListListener.class) {
                    if (event == null) {
                        event = new ElementListEvent((Object)this, start, end);
                    }
                    ((ElementListListener)listeners[i + 1]).elementsChanged(event);
                }
                i -= 2;
            }
        }
    }

    static Object[] ra$_data(ArrayElementList arrayElementList) {
        return arrayElementList._data;
    }

    final class 1
    implements Iterator {
        private int _cursor;
        private int _lastRet;

        private void $init$() {
            this._cursor = 0;
            this._lastRet = -1;
        }

        public boolean hasNext() {
            return ArrayElementList.this.size() > this._cursor;
        }

        public Object next() {
            this._lastRet = this._cursor++;
            return ArrayElementList.ra$_data(ArrayElementList.this)[this._lastRet];
        }

        public void remove() {
            if (this._lastRet < 0) {
                throw new IllegalStateException();
            }
            ArrayElementList.this.remove(this._lastRet);
            --this._cursor;
            this._lastRet = -1;
        }

        public 1() {
            this.$init$();
        }
    }
}

