/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.buffer.DefaultDocumentScannerFactory;
import oracle.bali.xml.dom.buffer.DefaultParserConfiguration;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.MetadataRegistry;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.XmlViewFactory;
import oracle.bali.xml.model.view.SimpleTypeElementFilteredView;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.ResultCallback;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.xml.BindingIO;
import oracle.jdeveloper.xml.TextBufferDomIO;
import oracle.jdevimpl.deploy.res.DtArb;
import oracle.jdevimpl.xml.DescriptorNodeDomIO;
import oracle.jdevimpl.xml.DescriptorNodeDt;
import oracle.jdevimpl.xml.ElementDescriptor;
import oracle.jdevimpl.xml.ThreadLocalPool;
import oracle.xml.parser.v2.XMLDOMImplementation;
import org.w3c.dom.DOMImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DescriptorNode
extends XMLSourceNode {
    public static final int MODULE_LEVEL_DESCRIPTOR = 0;
    public static final int EAR_LEVEL_DESCRIPTOR = 1;
    private final ThreadLocalPool _tlPool;
    private final ThreadLocalPool.ThreadLocal<BindingIO> _tlBindingIO;
    private final ThreadLocalPool.ThreadLocal<DescriptorNodeDomIO> _tlDomIO;
    private Icon _icon;
    private static final Integer INITIAL_CHANGE_ID = new Integer(-2);
    private final ThreadLocalPool.ThreadLocal<Integer> _tlChangeId;

    private void $init$() {
        this._tlPool = new ThreadLocalPool();
        this._tlBindingIO = new ThreadLocalPool.ThreadLocal(this._tlPool);
        this._tlDomIO = new ThreadLocalPool.ThreadLocal(this._tlPool);
        this._tlChangeId = new 1(this._tlPool);
    }

    protected DescriptorNode() {
        this.$init$();
        Attributes attrs = this.getAttributes();
        attrs.clear();
        attrs.set(ElementAttributes.SAVEABLE | ElementAttributes.CLOSEABLE | ElementAttributes.BUILDABLE | ElementAttributes.DELETEABLE | ElementAttributes.PRINTABLE | ElementAttributes.DEPLOYABLE);
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = this.getIconImpl();
        }
        return this._icon;
    }

    public String getDescriptorVersion() {
        try {
            StartElementPacket sep = XMLUtil.getXMLRootElement((Reader)this.getReader());
            String string = sep != null ? sep.systemId : null;
            return string;
        }
        catch (IOException e) {
            Assert.printStackTrace((Throwable)e);
            String string = null;
            return string;
        }
    }

    public Object getDescriptor() throws IOException {
        int changeId = this.getChangeId();
        if (this.refreshCachedDescriptor(changeId)) {
            return this.getNewDescriptorImpl(changeId);
        }
        return this._tlBindingIO.get().getRootProxy();
    }

    public int getPackagingLevel() {
        return 0;
    }

    public final boolean commit() throws IOException {
        return this.commitImpl();
    }

    protected boolean commitImpl() throws IOException {
        this.commitImpl(false);
        return true;
    }

    public final boolean rollback() {
        return this.rollbackImpl();
    }

    protected boolean rollbackImpl() {
        this.clearIO();
        return true;
    }

    public final ElementDescriptor getElementDescriptor(Object proxyObj) {
        BindingIO io = this._tlBindingIO.get();
        if (io == null) {
            throw new IllegalStateException("No BindingIO is currently associated with the DescriptorNode.");
        }
        return io.getElementDescriptor(proxyObj);
    }

    public static final void registerDescriptorNode(Class nodeClass, String settingsMenuItemText, String createDeploymentProfileMenuItemText, Class createDeploymentProfileDataClass) {
        NavigatorManager nm = NavigatorManager.getWorkspaceNavigatorManager();
        if (nm != null) {
            DescriptorNodeDt dt = new DescriptorNodeDt(nodeClass, settingsMenuItemText, createDeploymentProfileMenuItemText, createDeploymentProfileDataClass);
            nm.addContextMenuListener((ContextMenuListener)dt, nodeClass);
        }
    }

    public static Object findInElement(Element elem, Class objClass) {
        if (elem != null) {
            if (elem instanceof Project) {
                ArrayList descriptorNodes = new ArrayList();
                2 callback = new 2(descriptorNodes);
                Index index = IndexManager.getIndexManager().getIndex((Project)elem);
                try {
                    index.findNodes(objClass, (ResultCallback)callback);
                    Node node = descriptorNodes.size() > 0 ? (Node)descriptorNodes.get(0) : null;
                    return node;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    index.release();
                }
            }
            Iterator iter = elem instanceof Workspace ? ApplicationContent.getInstance((Workspace)((Workspace)elem)).getDescriptors() : elem.getChildren();
            if (iter != null) {
                while (iter.hasNext()) {
                    Object child = iter.next();
                    if (child == null || child.getClass() != objClass) continue;
                    return child;
                }
            }
        }
        return null;
    }

    public static Object findInElement(Element elem, Class objClass, String fileName, String extension) {
        if (!(elem instanceof Project)) {
            return DescriptorNode.findInElement(elem, objClass);
        }
        URL[] urls = DeployUtil.findFast((Project)elem, fileName, extension);
        Node o = null;
        Assert.println((urls == null || urls.length == 0 ? 1 : 0) != 0, (String)("Index query for " + fileName + extension + " in " + ((Project)elem).getShortLabel() + " yielded no result"));
        if (urls != null) {
            URL[] uRLArray = urls;
            int n = 0;
            while (n < uRLArray.length) {
                URL url = uRLArray[n];
                try {
                    o = NodeFactory.findOrCreate((URL)url);
                }
                catch (IllegalAccessException e) {
                    Assert.printStackTrace((Throwable)e);
                    break;
                }
                catch (InstantiationException e) {
                    Assert.printStackTrace((Throwable)e);
                    break;
                }
                if (o.getClass() == objClass) {
                    return o;
                }
                ++n;
            }
        }
        return null;
    }

    public static DescriptorNode findInProject(Project project, Class nodeClass, String relativePath) {
        URLPath srcPath = PathsConfiguration.getInstance((Project)project).getProjectSourcePath();
        URL url = srcPath.toBoundURL(relativePath);
        if (url != null) {
            try {
                DescriptorNode node = (DescriptorNode)NodeFactory.findOrCreate((Class)nodeClass, (URL)url);
                if (node != null) {
                    DescriptorNode descriptorNode = node;
                    return descriptorNode;
                }
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return (DescriptorNode)((Object)DescriptorNode.findInElement((Element)project, nodeClass));
    }

    public static <T> T findInWorkspace(Workspace workspace, Class<T> nodeClass) {
        return (T)DescriptorNode.findInElement((Element)workspace, nodeClass);
    }

    final BindingIO getBindingIO() {
        this.maybeInitIO();
        return this._tlBindingIO.get();
    }

    final DescriptorNodeDomIO getDomIO() {
        this.maybeInitIO();
        return this._tlDomIO.get();
    }

    protected abstract BindingIO newBindingIO();

    protected abstract boolean showDialog(Component var1, Object var2, Context var3);

    protected Icon getIconImpl() {
        return DescriptorNode.getXMLIcon();
    }

    protected String getMetadataID() {
        return null;
    }

    protected DOMImplementation createDOMImplementation() {
        return new XMLDOMImplementation();
    }

    public DocumentScannerFactory createDomModelCopyDocumentScannerFactory() {
        return new DefaultDocumentScannerFactory();
    }

    public ParserConfiguration createDomModelCopyParserConfiguration() {
        return new DefaultParserConfiguration();
    }

    public WhitespaceHandler getWhitespaceHandler() {
        return this.getModel(null).getWhitespaceHandler();
    }

    protected MetadataProvider createMetadataProvider(JDevXmlContext context, boolean isSourceModel) {
        MetadataProvider customProvider;
        String id;
        if (isSourceModel && (id = this.getMetadataID()) != null && (customProvider = MetadataRegistry.getInstance().getMetadataProvider(id)) != null) {
            return customProvider;
        }
        return super.createMetadataProvider(context, isSourceModel);
    }

    protected void registerViewFactories(JDevXmlContext context) {
        if (this.getMetadataID() != null) {
            context.registerViewFactory((XmlViewFactory)new ViewFactory(null));
        }
    }

    private void maybeInitIO() {
        if (this._tlBindingIO.get() == null) {
            BindingIO bindingIO = this.newBindingIO();
            this._tlBindingIO.set(bindingIO);
            this._tlDomIO.set(new DescriptorNodeDomIO(this));
        }
    }

    private void clearIO() {
        this._tlBindingIO.set(null);
        DescriptorNodeDomIO domIO = this._tlDomIO.get();
        if (domIO != null) {
            domIO.rollback();
            this._tlDomIO.set(null);
        }
    }

    private void reset() {
        this.clearIO();
        this._tlChangeId.set(INITIAL_CHANGE_ID);
    }

    private void commitImpl(boolean useInvokeLater) throws IOException {
        BindingIO bindingIO = this._tlBindingIO.get();
        if (bindingIO != null) {
            int changeId = this._tlChangeId.get();
            if (changeId >= 0 && changeId != this.getChangeId()) {
                throw new IOException("ERROR: DescriptorNode buffer has been modified since the descriptor was last parsed!");
            }
            DescriptorNodeDomIO domIO = this._tlDomIO.get();
            if (useInvokeLater) {
                bindingIO.saveAsynchronously(domIO, false);
            } else {
                bindingIO.save(domIO, false);
            }
            this.reset();
        }
    }

    void commitToBuffer(TextBuffer buffer, boolean isPreview) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        BindingIO bindingIO = this._tlBindingIO.get();
        if (bindingIO == null) {
            throw new IllegalStateException("No BindingIO associated with DescriptorNode.");
        }
        TextBufferDomIO domIO = new TextBufferDomIO(buffer, this.getURL());
        bindingIO.save(domIO, isPreview);
    }

    static Icon getXMLIcon() {
        Icon icon = OracleIcons.getIcon((String)"declarativecomponent.png");
        return new ImageIcon(OracleIcons.toImage((Icon)icon), DtArb.getString(119));
    }

    private int getChangeId() {
        TextBuffer textBuffer = this.acquireTextBuffer();
        try {
            int n = textBuffer.getChangeId();
            return n;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.releaseTextBuffer();
        }
    }

    private boolean refreshCachedDescriptor(int changeId) {
        return changeId != this._tlChangeId.get() || this._tlBindingIO.get() == null;
    }

    private Object getNewDescriptorImpl(int changeId) throws IOException {
        this.clearIO();
        BindingIO io = this.getBindingIO();
        io.load(this._tlDomIO.get());
        this._tlChangeId.set(new Integer(changeId));
        return io.getRootProxy();
    }

    static Integer ra$INITIAL_CHANGE_ID() {
        return INITIAL_CHANGE_ID;
    }

    final class 1
    extends ThreadLocalPool.ThreadLocal {
        protected Integer initialValue() {
            return DescriptorNode.ra$INITIAL_CHANGE_ID();
        }

        public 1(ThreadLocalPool threadLocalPool) {
            super(threadLocalPool);
        }
    }

    static final class 2
    implements ResultCallback {
        private final /* synthetic */ List v$descriptorNodes;

        public void result(Node node) throws InterruptedException {
            this.v$descriptorNodes.add(node);
            throw new InterruptedException();
        }

        public void done() {
        }

        public 2(List list) {
            this.v$descriptorNodes = list;
        }
    }

    private static final class ViewFactory
    extends XmlViewFactory {
        public XmlView createView(XmlModel model, XmlUsage usage) {
            if (usage == XmlUsage.XML_CODE_EXPLORER) {
                return new SimpleTypeElementFilteredView();
            }
            return super.createView(model, usage);
        }

        private ViewFactory() {
        }

        ViewFactory(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

