/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.buffer.BufferDomModelPluginFactory;
import oracle.bali.xml.dom.changes.DomChangeUtils;
import oracle.bali.xml.dom.impl.DomModelFactory;
import oracle.bali.xml.dom.impl.DomModelPluginFactory;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.cmd.buffer.EditProcessor;
import oracle.ide.model.Node;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.xml.bind.DOMBindingRuntime;
import oracle.javatools.xml.bind.IndentPrefs;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdeveloper.xml.DomIO;
import oracle.jdeveloper.xml.TextBufferDomIO;
import oracle.jdevimpl.deploy.res.DtArb;
import oracle.jdevimpl.xml.DescriptorNode;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

final class DescriptorNodeDomIO
extends DomIO {
    private final DescriptorNode _node;
    private static final boolean USE_FREAKY2 = true;
    private static final boolean USE_BALI_XML_MODEL = true;

    static {
        try {
            DOMBindingRuntime.setDefaultIndentPrefs((IndentPrefs)new 1());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    DescriptorNodeDomIO(DescriptorNode node) {
        this._node = node;
    }

    public Document create() throws IOException {
        block5: {
            XmlModel model = this.getModel();
            if (model != null) {
                model.acquireReadLock();
                try {
                    Document doc = DescriptorNodeDomIO.getDocument(model);
                    if (doc == null || doc.getChildNodes().getLength() <= 0) break block5;
                    Document document = doc;
                    return document;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    model.releaseReadLock();
                }
            }
        }
        return super.create();
    }

    public Document load() throws IOException {
        if (!"jar".equals(this._node.getURL().getProtocol())) {
            try {
                XMLDocument xMLDocument = this.getXMLDocument();
                return xMLDocument;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TextBuffer textBuffer = this._node.acquireTextBuffer();
        try {
            URL nodeURL = this._node != null ? this._node.getURL() : null;
            TextBufferDomIO io = new TextBufferDomIO(textBuffer, nodeURL);
            Document document = io.load();
            WhitespaceUtils.applyWhitespaceRulesToSubtree((WhitespaceHandler)this._node.getWhitespaceHandler(), null, (org.w3c.dom.Node)document);
            Document document2 = document;
            return document2;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this._node.releaseTextBuffer();
        }
    }

    public void save(Document document) throws IOException {
        block17: {
            if (!"jar".equals(this._node.getURL().getProtocol())) {
                try {
                    ArrayList undoableEditList;
                    XMLDocument xmlDocument = (XMLDocument)document;
                    DomModel domModelCopy = (DomModel)xmlDocument.getUserData("dom-model-copy");
                    if (domModelCopy != null) {
                        try {
                            domModelCopy.commitTransaction();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if ((undoableEditList = (ArrayList)xmlDocument.getUserData("undoable-edit-list")) != null && DomChangeUtils.canApplyChanges((List)undoableEditList)) {
                        XmlModel model = this.getModel();
                        boolean success = false;
                        model.startTransaction("XML Edit");
                        try {
                            DomChangeUtils.applyChanges((List)undoableEditList, (Document)model.getDocument());
                            model.commitTransaction(false);
                            success = true;
                        }
                        finally {
                            if (!success) {
                                model.rollbackTransaction();
                            }
                        }
                        return;
                    }
                    TextBuffer textBufferCopy = (TextBuffer)xmlDocument.getUserData("text-buffer-copy");
                    if (textBufferCopy == null) break block17;
                    char[] data = null;
                    textBufferCopy.readLock();
                    try {
                        data = textBufferCopy.getChars(0, textBufferCopy.getLength());
                    }
                    finally {
                        textBufferCopy.readUnlock();
                    }
                    if (data != null) {
                        Assert.println((String)"replacing text buffer using cloned buffer");
                        this.replaceEntireBuffer(data);
                        return;
                    }
                }
                catch (IllegalStateException e) {
                    System.err.println("**** Warning: DescriptorNodeDomIO could not commit the XmlModel transaction.  Falling back on replacing the entire buffer.");
                }
                catch (XmlCommitException e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
            }
        }
        CharArrayWriter writer = this.getCharArrayWriter(document);
        this.replaceEntireBuffer(writer.toCharArray());
    }

    private void replaceEntireBuffer(char[] data) throws IOException {
        if (this._node.isReadOnly()) {
            throw new IllegalStateException("cannot update text buffer on a read-only " + this._node.getClass().getName());
        }
        EditProcessor.doReplaceAll((char[])data, (Node)this._node, (boolean)true, (String)DtArb.getString(129), (Object)((Object)this._node));
        if (this._node.hasEmptyTextBuffer() && data.length > 0) {
            throw new RuntimeException("Text buffer is unexpectedly empty");
        }
    }

    private static CodingStyleOptions getStyleOptions() {
        CodingStyleManager csm = CodingStyleManager.getCodingStyleManager();
        if (csm == null) {
            return null;
        }
        return csm.getCodingStyleOptions();
    }

    protected int getIndentSize() {
        if (DescriptorNodeDomIO.getStyleOptions() == null) {
            return super.getIndentSize();
        }
        return DescriptorNodeDomIO.getStyleOptions().getIndentSize();
    }

    protected boolean getIndentReplaceWithTabs() {
        if (DescriptorNodeDomIO.getStyleOptions() == null) {
            return super.getIndentReplaceWithTabs();
        }
        return DescriptorNodeDomIO.getStyleOptions().getIndentReplaceWithTabs();
    }

    protected int getTabSize() {
        if (DescriptorNodeDomIO.getStyleOptions() == null) {
            return super.getTabSize();
        }
        return DescriptorNodeDomIO.getStyleOptions().getTabSize();
    }

    void rollback() {
    }

    private XmlModel getModel() {
        return this._node.getModel(null);
    }

    private XMLDocument getXMLDocument() {
        2 domModelContext = new 2();
        TextBuffer textBufferCopy = TextBufferFactory.createGapTextBuffer();
        try {
            TextBuffer textBufferOrig = this._node.acquireTextBuffer();
            textBufferCopy.append(textBufferOrig.getChars(0, textBufferOrig.getLength()));
        }
        finally {
            this._node.releaseTextBuffer();
        }
        BufferDomModelPluginFactory pluginFactory = new BufferDomModelPluginFactory(textBufferCopy, this._node.getDOMImplementation(), this._node.createDomModelCopyParserConfiguration(), this._node.createDomModelCopyDocumentScannerFactory());
        DomModel domModelCopy = DomModelFactory.createDomModel((DomModelContext)domModelContext, (DomModelPluginFactory)pluginFactory, (WhitespaceHandler)this._node.getModel(null).getWhitespaceHandler());
        domModelCopy.acquireWriteLock();
        Document doc = domModelCopy.getDocument();
        DescriptorNodeDomIO.initDocument(doc);
        XMLDocument xmlDoc = (XMLDocument)doc;
        ArrayList undoableEditList = new ArrayList();
        xmlDoc.setUserData("undoable-edit-list", undoableEditList, null);
        xmlDoc.setUserData("text-buffer-copy", (Object)textBufferCopy, null);
        xmlDoc.setUserData("dom-model-copy", (Object)domModelCopy, null);
        domModelCopy.startTransaction("internal");
        domModelCopy.addUndoableEditListener((UndoableEditListener)new 3(this, undoableEditList));
        return xmlDoc;
    }

    private static Document getDocument(XmlModel model) {
        Document doc = model.getDocument();
        DescriptorNodeDomIO.initDocument(doc);
        return doc;
    }

    private static void initDocument(Document doc) {
        if (doc != null) {
            ((XMLDocument)doc).setUserData("disable-whitespace-handling", (Object)Boolean.TRUE, null);
        }
    }

    static DescriptorNode ra$_node(DescriptorNodeDomIO descriptorNodeDomIO) {
        return descriptorNodeDomIO._node;
    }

    static CodingStyleOptions maS$getStyleOptions() {
        return DescriptorNodeDomIO.getStyleOptions();
    }

    static final class 1
    extends IndentPrefs {
        public int getWidth() {
            if (DescriptorNodeDomIO.maS$getStyleOptions() == null) {
                return super.getWidth();
            }
            return DescriptorNodeDomIO.maS$getStyleOptions().getIndentSize();
        }

        public boolean getUseSpaces() {
            if (DescriptorNodeDomIO.maS$getStyleOptions() == null) {
                return super.getUseSpaces();
            }
            return DescriptorNodeDomIO.maS$getStyleOptions().getIndentReplaceWithTabs() ^ true;
        }

        public int getTabSize() {
            if (DescriptorNodeDomIO.maS$getStyleOptions() == null) {
                return super.getTabSize();
            }
            return DescriptorNodeDomIO.maS$getStyleOptions().getTabSize();
        }
    }

    final class 2
    extends DomModelContext {
        public String getTranslatedString(String key) {
            return this._real().getTranslatedString(key);
        }

        public Locale getLocale() {
            return this._real().getLocale();
        }

        public org.w3c.dom.Node remapNode(Document targetDocument, org.w3c.dom.Node node) {
            return this._real().remapNode(targetDocument, node);
        }

        private XmlContext _real() {
            return DescriptorNodeDomIO.ra$_node(DescriptorNodeDomIO.this).getXmlContext(null);
        }
    }

    final class 3
    implements UndoableEditListener {
        private final /* synthetic */ ArrayList v$undoableEditList;
        final /* synthetic */ DescriptorNodeDomIO this$0;

        public void undoableEditHappened(UndoableEditEvent e) {
            UndoableEdit edit = e.getEdit();
            this.v$undoableEditList.add(edit);
        }

        public 3(DescriptorNodeDomIO descriptorNodeDomIO, ArrayList arrayList) {
            this.v$undoableEditList = arrayList;
            this.this$0 = descriptorNodeDomIO;
        }
    }
}

