/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.io.IOException;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.marshal.xml.Object2DomException;
import oracle.ide.model.Element;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.deploy.dt.DeployDesignTime;
import oracle.jdeveloper.deploy.dt.DeployMenuItem;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdevimpl.deploy.res.CommonArb;
import oracle.jdevimpl.xml.DescriptorNode;
import oracle.xml.parser.v2.XMLParseException;

final class DescriptorNodeDt
extends DeployDesignTime {
    private final Class _dataClass;
    private final String _settingsMenuItemText;
    private final String _createDeploymentProfileMenuItemText;
    private final Class _createDeploymentProfileDataClass;
    private boolean _initialized;
    private DeployMenuItem _ctxSettings;
    private DeployMenuItem _ctxCreateDeploymentProfile;

    DescriptorNodeDt(Class dataClass, String settingsMenuItemText) {
        this(dataClass, settingsMenuItemText, null, null);
    }

    DescriptorNodeDt(Class dataClass, String settingsMenuItemText, String createDeploymentProfileMenuItemText, Class createDeploymentProfileDataClass) {
        if (dataClass == null) {
            throw new IllegalArgumentException(CommonArb.getString(79));
        }
        if (!DescriptorNode.class.isAssignableFrom(dataClass)) {
            throw new IllegalArgumentException(CommonArb.getString(122));
        }
        this._dataClass = dataClass;
        this._settingsMenuItemText = settingsMenuItemText;
        this._createDeploymentProfileMenuItemText = createDeploymentProfileMenuItemText;
        if (createDeploymentProfileMenuItemText != null && createDeploymentProfileDataClass == null) {
            throw new IllegalArgumentException("Argument createDeploymentProfileDataClass must not be null, if createDeploymentProfileMenuItemText is not null.");
        }
        this._createDeploymentProfileDataClass = createDeploymentProfileDataClass;
    }

    protected String getDefaultCommand() {
        return null;
    }

    protected String getLabelForCommand(String commandName) {
        return null;
    }

    public void menuWillShow(ContextMenu popup) {
        if (DescriptorNodeDt.isInSupportedNavigator(popup)) {
            this.maybeInitializeContextMenuItems();
            float menuSection = 0.01f;
            if (this._ctxSettings != null) {
                popup.add((Component)this._ctxSettings.menuItem, JDeveloperMenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            }
            if (this._ctxCreateDeploymentProfile != null) {
                menuSection = JDeveloperMenuConstants.SECTION_ADDITIONAL_CTXT_MENU - 0.01f;
                popup.add((Component)this._ctxCreateDeploymentProfile.menuItem, menuSection);
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (this._ctxSettings != null && cmdId == this._ctxSettings.id) {
            this.showSettingsDialog(context);
            return true;
        }
        if (this._ctxCreateDeploymentProfile != null && cmdId == this._ctxCreateDeploymentProfile.id) {
            Deployment.invokeNewDeploymentProfileWizard(this._createDeploymentProfileDataClass, context);
            return true;
        }
        return false;
    }

    private boolean showSettingsDialog(Context context) {
        Element elem = context.getElement();
        if (elem != null && this._dataClass.isAssignableFrom(elem.getClass())) {
            DescriptorNode node = (DescriptorNode)elem;
            Object descriptor = null;
            try {
                descriptor = node.getDescriptor();
            }
            catch (Object2DomException e) {
                Exception chained = e.getChainedException();
                String shortLabel = node.getShortLabel();
                if (chained instanceof XMLParseException) {
                    this.handleXMLParseException(shortLabel, (XMLParseException)((Object)chained));
                } else {
                    MessageDialog.error((Component)IdeUtil.getMainWindow(), (Object)CommonArb.format(22, shortLabel, "\n\n" + chained.getLocalizedMessage() + "\n\n"), (String)CommonArb.format(2, shortLabel), null);
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                Throwable chained = e.getCause();
                String shortLabel = node.getShortLabel();
                if (chained instanceof XMLParseException) {
                    this.handleXMLParseException(shortLabel, (XMLParseException)chained);
                } else {
                    MessageDialog.error((Component)IdeUtil.getMainWindow(), (Object)CommonArb.format(47, shortLabel), (String)CommonArb.format(49, shortLabel), null);
                }
                boolean bl = true;
                return bl;
            }
            boolean changeApplied = node.showDialog(IdeUtil.getMainWindow(), descriptor, context);
            try {
                if (changeApplied) {
                    node.commit();
                } else {
                    node.rollback();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void maybeInitializeContextMenuItems() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        if (this._settingsMenuItemText != null) {
            String prefix = this._dataClass.getName() + ".";
            this._ctxSettings = new DeployMenuItem(prefix + "_ctxSettings", this._settingsMenuItemText, this);
        }
        if (this._createDeploymentProfileMenuItemText != null) {
            this._ctxCreateDeploymentProfile = new DeployMenuItem(this._dataClass.getName() + "." + "_ctxCreateDeploymentProfile", this._createDeploymentProfileMenuItemText, this);
        }
    }

    private void handleXMLParseException(String shortLabel, XMLParseException xpe) {
        int n = xpe.getNumMessages();
        StringBuffer errMsgs = new StringBuffer();
        int i = 0;
        while (i < n) {
            int line = xpe.getLineNumber(i);
            String mesg = xpe.getMessage(i);
            errMsgs.append(CommonArb.format(14, Integer.toString(line), mesg) + "\n");
            ++i;
        }
        MessageDialog.error((Component)IdeUtil.getMainWindow(), (Object)CommonArb.format(60, shortLabel, "\n\n" + errMsgs.toString() + "\n"), (String)CommonArb.format(104, shortLabel), null);
    }
}

