/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.io.IOException;
import java.net.URL;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.xml.BindingIO;
import oracle.jdevimpl.deploy.res.DtArb;
import oracle.jdevimpl.xml.DescriptorNode;

public class DescriptorNodeFactory {
    private final boolean _isForWebInf;
    private final String _relativePath;
    private final URL _descriptorURL;
    private final Class _nodeClass;

    public DescriptorNodeFactory(String relativePath, Class nodeClass) {
        this(false, relativePath, null, nodeClass);
    }

    public DescriptorNodeFactory(boolean isForWebInf, String relativePath, Class nodeClass) {
        this(isForWebInf, relativePath, null, nodeClass);
    }

    public DescriptorNodeFactory(URL descriptorURL, Class nodeClass) {
        this(false, null, descriptorURL, nodeClass);
    }

    private DescriptorNodeFactory(boolean isForWebInf, String relativePath, URL descriptorURL, Class nodeClass) {
        this._isForWebInf = isForWebInf;
        this._relativePath = relativePath;
        this._descriptorURL = descriptorURL;
        this._nodeClass = nodeClass;
    }

    public final DescriptorNode findOrCreateIn(Project project, String descriptorVersion, boolean addToProject, boolean openEditor, boolean useProxy) throws DeployException {
        try {
            URL url = this.getDescriptorURL(project);
            if (url != null) {
                Object descriptor;
                DescriptorNode node = (DescriptorNode)NodeFactory.findOrCreate((Class)this._nodeClass, (URL)url);
                Object object = descriptor = node.hasEmptyTextBuffer() ? this.newDescriptorImpl(node, descriptorVersion) : this.autoUpdateDescriptor(node);
                if (descriptor != null) {
                    this.flushAndSave(node);
                }
                if (addToProject) {
                    project.add((Node)node, this.getContentSetKey());
                }
                if (openEditor) {
                    EditorUtil.openExplicitDefaultEditorInFrame((URL)url);
                }
                DescriptorNode descriptorNode = node;
                return descriptorNode;
            }
            DescriptorNode descriptorNode = null;
            return descriptorNode;
        }
        catch (DeployException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeployException(e);
        }
    }

    public final DescriptorNode findOrCreateIn(Workspace workspace, String descriptorVersion, boolean addToWorkspace, boolean openEditor) throws DeployException {
        try {
            URL url = this.getDescriptorURL(workspace);
            if (url != null) {
                Object descriptor;
                DescriptorNode node = (DescriptorNode)NodeFactory.findOrCreate((Class)this._nodeClass, (URL)url);
                Object object = descriptor = node.hasEmptyTextBuffer() ? this.newDescriptorImpl(node, descriptorVersion) : this.autoUpdateDescriptor(node);
                if (descriptor != null) {
                    this.flushAndSave(node);
                }
                if (addToWorkspace) {
                    // empty if block
                }
                if (openEditor) {
                    EditorUtil.openExplicitDefaultEditorInFrame((URL)url);
                }
                DescriptorNode descriptorNode = node;
                return descriptorNode;
            }
            DescriptorNode descriptorNode = null;
            return descriptorNode;
        }
        catch (DeployException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeployException(e);
        }
    }

    public final DescriptorNode findOrCreateInContainer(HashStructureNode container, String descriptorVersion, boolean addToContainer, boolean openEditor) throws DeployException {
        if (container instanceof Workspace) {
            return this.findOrCreateIn((Workspace)container, descriptorVersion, addToContainer, openEditor);
        }
        return this.findOrCreateIn((Project)container, descriptorVersion, addToContainer, openEditor, true);
    }

    protected Object newDescriptor(DescriptorNode node, String descriptorVersion) throws IOException {
        BindingIO io = node.getBindingIO();
        return io.create(descriptorVersion, node.getDomIO());
    }

    protected Object autoUpdateDescriptor(DescriptorNode node) throws IOException {
        return null;
    }

    protected String getContentSetKey() {
        return PathsConfiguration.JAVA_CONTENT_SET_KEY;
    }

    private URL getDescriptorURL(Project project) {
        if (this._descriptorURL != null) {
            return this._descriptorURL;
        }
        if (project != null) {
            URL dirURL;
            URL uRL = dirURL = this._isForWebInf ? J2eeSettings.getInstance(project).getHtmlRootDirectory() : DescriptorNodeFactory.getSourceDir(project);
            if (dirURL != null) {
                return URLFactory.newURL((URL)dirURL, (String)this._relativePath);
            }
        }
        return null;
    }

    private URL getDescriptorURL(Workspace workspace) {
        URL dirURL;
        if (this._descriptorURL != null) {
            return this._descriptorURL;
        }
        if (workspace != null && (dirURL = ApplicationContent.getInstance((Workspace)workspace).getSourceURL()) != null) {
            return URLFactory.newURL((URL)dirURL, (String)this._relativePath);
        }
        return null;
    }

    private static URL getSourceDir(Project project) {
        URLPath sourcePath = PathsConfiguration.getInstance((Project)project).getProjectSourcePath();
        if (sourcePath != null) {
            return sourcePath.getFirstEntry();
        }
        return null;
    }

    private static URL getSourceDir(Workspace workspace) {
        ApplicationContent content = ApplicationContent.getInstance((Workspace)workspace);
        return content.getSourceURL();
    }

    private Object newDescriptorImpl(DescriptorNode node, String descriptorVersion) throws IOException {
        Object desc = this.newDescriptor(node, descriptorVersion);
        if (desc instanceof Dirtyable) {
            ((Dirtyable)desc).markDirty(true);
        }
        return desc;
    }

    private void flushAndSave(DescriptorNode node) throws DeployException {
        try {
            node.commit();
            node.save();
        }
        catch (IOException e) {
            throw new DeployException(DtArb.format(114, this._descriptorURL != null ? this._descriptorURL.toExternalForm() : this._relativePath, e.getLocalizedMessage()));
        }
    }
}

