/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;

public class ElementListModel
extends AbstractListModel
implements ElementListListener {
    private final JList _jList;
    private ElementList _elementList;

    public ElementListModel(JList jList) {
        this(null, jList);
    }

    public ElementListModel(ElementList elementList, JList jList) {
        if (jList == null) {
            throw new IllegalArgumentException();
        }
        this._jList = jList;
        this._elementList = elementList != null ? elementList : new NullElementList(null);
    }

    public void setElementList(ElementList newElementList) {
        if (newElementList == null) {
            newElementList = new NullElementList(null);
        }
        int selectedIndex = this._jList.getSelectedIndex();
        int lastIndex = this._elementList.size() - 1;
        if (lastIndex >= 0) {
            this.fireIntervalRemoved(this, 0, lastIndex);
        }
        this._elementList = newElementList;
        int newLastIndex = newElementList.size() - 1;
        if (newLastIndex >= 0) {
            this.fireIntervalAdded(this, 0, newLastIndex);
        }
        if (selectedIndex > 0 && selectedIndex <= newLastIndex) {
            this._jList.setSelectedIndex(selectedIndex);
        }
    }

    public Object getElementAt(int i) {
        return this._elementList.get(i);
    }

    public int getSize() {
        return this._elementList.size();
    }

    public void elementsAdded(ElementListEvent e) {
        int start = e.getStartIndex();
        this.fireIntervalAdded(this, start, e.getEndIndex());
        this._jList.setSelectedIndex(start);
    }

    public void elementsRemoved(ElementListEvent e) {
        this.fireIntervalRemoved(this, e.getStartIndex(), e.getEndIndex());
    }

    public void elementsChanged(ElementListEvent e) {
        this.fireContentsChanged(this, e.getStartIndex(), e.getEndIndex());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullElementList
    implements ElementList {
        public void add(int index, Object element) {
        }

        public void add(Object element) {
        }

        public void addElementListListener(ElementListListener listener) {
        }

        public void clear() {
        }

        public Object createElement() {
            return null;
        }

        public Class elementType() {
            return null;
        }

        public Object get(int index) {
            return null;
        }

        public boolean isEmpty() {
            return true;
        }

        public Iterator iterator() {
            return null;
        }

        public Object remove(int index) {
            return null;
        }

        public void removeElementListListener(ElementListListener listener) {
        }

        public Object set(int index, Object element) {
            return null;
        }

        public int size() {
            return 0;
        }

        private NullElementList() {
        }

        NullElementList(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

