/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;
import oracle.jdevimpl.deploy.res.J2eeArb;
import oracle.jdevimpl.xml.ElementListPanel;
import oracle.jdevimpl.xml.XmlArb;

public abstract class TablePanel
extends ElementListPanel {
    public static final int TOP_RIGHT = 0;
    public static final int RIGHT_TOP = 1;
    private final L _listener;
    private final NiceTable _table;
    private final JButton _btnAdd;
    private final JButton _btnRemove;
    private final boolean _showUpDownButtons;
    private final JButton _btnMoveUp;
    private final JButton _btnMoveDown;
    private transient TableModelImpl _tableModelImpl;

    private void $init$() {
        this._listener = new L(null);
        this._table = new NiceTable();
        this._btnAdd = new JButton();
        this._btnRemove = new JButton();
        this._tableModelImpl = new TableModelImpl(null);
    }

    public TablePanel(String tableLabel, String helpID) {
        this(tableLabel, helpID, 0);
    }

    public TablePanel(String tableLabel, String helpID, int buttonLocation) {
        this(tableLabel, helpID, buttonLocation, false);
    }

    public TablePanel(String tableLabel, String helpID, int buttonLocation, boolean showUpDownButtons) {
        int dimAdjust;
        this.$init$();
        if (buttonLocation != 0 && buttonLocation != 1) {
            throw new IllegalArgumentException();
        }
        this._showUpDownButtons = showUpDownButtons;
        this.initButton(this._btnAdd, this.getAddButtonLabel());
        this.initButton(this._btnRemove, this.getRemoveButtonLabel());
        if (this._showUpDownButtons) {
            this._btnMoveUp = new JButton();
            this._btnMoveDown = new JButton();
            this.initButton(this._btnMoveUp, J2eeArb.getString(4));
            this.initButton(this._btnMoveDown, J2eeArb.getString(45));
        } else {
            this._btnMoveUp = null;
            this._btnMoveDown = null;
        }
        JScrollPane spTable = new JScrollPane();
        spTable.getViewport().add((Component)this._table, null);
        spTable.setPreferredSize(new Dimension(1, 120));
        JLabel lblTable = new JLabel();
        ResourceUtils.resLabel((JLabel)lblTable, (Component)this._table, (String)tableLabel);
        ListSelectionModel lsm = this._table.getSelectionModel();
        lsm.addListSelectionListener(this._listener);
        this.setLayout(new GridBagLayout());
        Insets in5555 = new Insets(5, 5, 5, 5);
        int n = dimAdjust = this._showUpDownButtons ? 2 : 0;
        if (buttonLocation == 0) {
            this.add(lblTable, this.gbc(0, 0, 1, 1, 1.0, 0.0, 17, 0, in5555));
            this.add(this._btnAdd, this.gbc(1, 0, 1, 1, 0.0, 0.0, 13, 0, in5555));
            this.add(this._btnRemove, this.gbc(2, 0, 1, 1, 0.0, 0.0, 13, 0, in5555));
            if (this._showUpDownButtons) {
                this.add(this._btnMoveUp, this.gbc(3, 0, 1, 1, 0.0, 0.0, 13, 0, in5555));
                this.add(this._btnMoveDown, this.gbc(4, 0, 1, 1, 0.0, 0.0, 13, 0, in5555));
            }
            this.add(spTable, this.gbc(0, 1, 3 + dimAdjust, 1, 0.0, 1.0, 18, 1, new Insets(0, 5, 5, 5)));
            this._lastY = 2;
        } else if (buttonLocation == 1) {
            this.add(lblTable, this.gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0, in5555));
            this.add(this._btnAdd, this.gbc(1, 1, 1, 1, 0.0, 0.0, 11, 2, in5555));
            this.add(this._btnRemove, this.gbc(1, 2, 1, 1, 0.0, this._showUpDownButtons ? 0.0 : 1.0, 11, 2, in5555));
            if (this._showUpDownButtons) {
                this.add(this._btnMoveUp, this.gbc(1, 3, 1, 1, 0.0, 0.0, 11, 2, in5555));
                this.add(this._btnMoveDown, this.gbc(1, 4, 1, 1, 0.0, 1.0, 11, 2, in5555));
            }
            this.add(spTable, this.gbc(0, 1, 1, 2 + dimAdjust, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 0)));
            this._lastY = 3;
        }
        this.setHelpID(helpID);
        this.initTable((JTable)this._table);
    }

    private void initButton(JButton button, String label) {
        ResourceUtils.resButton((AbstractButton)button, (String)label);
        button.addActionListener(this._listener);
    }

    protected String getAddButtonLabel() {
        return XmlArb.getString(1);
    }

    protected String getRemoveButtonLabel() {
        return XmlArb.getString(7);
    }

    public final void onEntry(TraversableContext tc) {
        super.onEntry(tc);
        this.onEntryImpl(tc);
    }

    protected abstract void onEntryImpl(TraversableContext var1);

    public final void onExit(TraversableContext tc) throws TraversalException {
        super.onExit(tc);
        this.forceTableEditorCommit();
        this.onExitImpl(tc);
    }

    protected void onExitImpl(TraversableContext tc) throws TraversalException {
    }

    protected ElementListListener newElementListListener() {
        this._tableModelImpl = new TableModelImpl(null);
        return this._tableModelImpl;
    }

    protected final int[] getSelectedIndexes() {
        return this._table.getSelectedRows();
    }

    protected final void setSelectedIndexes(int[] indexes) {
        int highestIndex;
        if (indexes != null && indexes.length > 0 && (highestIndex = this.getElementList().size() - 1) >= 0) {
            int index = Math.min(indexes[0], highestIndex);
            ListSelectionModel selModel = this._table.getSelectionModel();
            selModel.setSelectionInterval(index, index);
        }
    }

    protected final void setElementList(ElementList elementList) {
        super.setElementList(elementList);
        this._table.setModel((TableModel)this._tableModelImpl);
        this.updateButtons();
    }

    public Object[] delete(TraversableContext tc) {
        this.forceTableEditorCancel();
        return super.delete(tc);
    }

    protected void initTable(JTable table) {
    }

    protected int getTableRowCount() {
        ElementList elementList = this.getElementList();
        return elementList != null ? elementList.size() : 0;
    }

    protected abstract int getTableColumnCount();

    protected abstract String getTableColumnName(int var1);

    protected abstract Object getTableValueAt(Object var1, int var2, int var3);

    protected boolean isTableCellEditable(int row, int column) {
        return true;
    }

    protected boolean isTableRowRemoveable(int row) {
        return this.isTableCellEditable(row, 0);
    }

    protected abstract void setTableValueAt(Object var1, Object var2, int var3, int var4);

    protected void setColumnCellRenderer(int column, TableCellRenderer tcr) {
        TableColumnModel tcm = this._table.getColumnModel();
        TableColumn col = tcm.getColumn(column);
        col.setCellRenderer(tcr);
    }

    protected void setDisablingCellRenderer(int column) {
        this.setColumnCellRenderer(0, (TableCellRenderer)((Object)new 1()));
    }

    protected void setCellEditor(int column, TableCellEditor editor) {
        TableColumnModel tcm = this._table.getColumnModel();
        TableColumn col = tcm.getColumn(column);
        col.setCellEditor(editor);
    }

    protected static TableCellEditor monospacedTextCellEditor() {
        JTextField field = new JTextField();
        field.setFont(new Font("Monospaced", 0, 12));
        return new DefaultCellEditor(field);
    }

    protected void forceTableEditorCommit() {
        TableCellEditor editor;
        if (this._table.isEditing() && (editor = this._table.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
    }

    protected void forceTableEditorCancel() {
        TableCellEditor editor;
        if (this._table.isEditing() && (editor = this._table.getCellEditor()) != null) {
            editor.cancelCellEditing();
        }
    }

    protected void enableAddButton(boolean enabled) {
        this._btnAdd.setEnabled(enabled);
    }

    protected void enableRemoveButton(boolean enabled) {
        this._btnRemove.setEnabled(enabled);
    }

    private void updateButtons() {
        this.enableAddButton(this.getElementList() != null);
        boolean removeEnabled = false;
        int[] selectedRows = this._table.getSelectedRows();
        int n = selectedRows.length;
        if (n > 0) {
            removeEnabled = true;
            int i = 0;
            while (i < n) {
                if (!this.isTableRowRemoveable(selectedRows[i])) {
                    removeEnabled = false;
                    break;
                }
                ++i;
            }
        }
        this.enableRemoveButton(removeEnabled);
        if (this._showUpDownButtons) {
            int[] indexes = this.getSelectedIndexes();
            int len = indexes.length;
            if (len <= 0 || len > 1) {
                this._btnMoveUp.setEnabled(false);
                this._btnMoveDown.setEnabled(false);
            } else {
                int index = indexes[0];
                this._btnMoveUp.setEnabled(index > 0);
                this._btnMoveDown.setEnabled(index < this.getElementList().size() - 1);
            }
        }
    }

    static NiceTable ra$_table(TablePanel tablePanel) {
        return tablePanel._table;
    }

    static void mav$updateButtons(TablePanel tablePanel) {
        tablePanel.updateButtons();
    }

    static JButton ra$_btnAdd(TablePanel tablePanel) {
        return tablePanel._btnAdd;
    }

    static JButton ra$_btnRemove(TablePanel tablePanel) {
        return tablePanel._btnRemove;
    }

    static boolean ra$_showUpDownButtons(TablePanel tablePanel) {
        return tablePanel._showUpDownButtons;
    }

    static JButton ra$_btnMoveUp(TablePanel tablePanel) {
        return tablePanel._btnMoveUp;
    }

    static JButton ra$_btnMoveDown(TablePanel tablePanel) {
        return tablePanel._btnMoveDown;
    }

    final class 1
    extends NiceTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel cellRenderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            boolean enabled = TablePanel.this.isTableCellEditable(row, column);
            cellRenderer.setEnabled(enabled);
            return cellRenderer;
        }
    }

    private class TableModelImpl
    extends AbstractTableModel
    implements ElementListListener {
        public int getRowCount() {
            return TablePanel.this.getTableRowCount();
        }

        public int getColumnCount() {
            return TablePanel.this.getTableColumnCount();
        }

        public String getColumnName(int column) {
            return TablePanel.this.getTableColumnName(column);
        }

        public Object getValueAt(int row, int column) {
            Object data = TablePanel.this.getElementList().get(row);
            return TablePanel.this.getTableValueAt(data, row, column);
        }

        public boolean isCellEditable(int row, int column) {
            return TablePanel.this.isTableCellEditable(row, column);
        }

        public void setValueAt(Object value, int row, int column) {
            Object data = TablePanel.this.getElementList().get(row);
            TablePanel.this.setTableValueAt(data, value, row, column);
        }

        public void elementsAdded(ElementListEvent e) {
            int start = e.getStartIndex();
            this.fireTableRowsInserted(start, e.getEndIndex());
            TablePanel.ra$_table(TablePanel.this).getSelectionModel().setSelectionInterval(start, start);
        }

        public void elementsRemoved(ElementListEvent e) {
            this.fireTableRowsDeleted(e.getStartIndex(), e.getEndIndex());
        }

        public void elementsChanged(ElementListEvent e) {
            this.fireTableRowsUpdated(e.getStartIndex(), e.getEndIndex());
        }

        private TableModelImpl() {
        }

        TableModelImpl(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class L
    implements ActionListener,
    ListSelectionListener {
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            TraversableContext tc = TablePanel.this.getTraversableContext();
            if (source == TablePanel.ra$_btnAdd(TablePanel.this)) {
                TablePanel.this.create(tc);
            } else if (source == TablePanel.ra$_btnRemove(TablePanel.this)) {
                TablePanel.this.delete(tc);
            } else if (TablePanel.ra$_showUpDownButtons(TablePanel.this)) {
                if (source == TablePanel.ra$_btnMoveUp(TablePanel.this)) {
                    TablePanel.this.moveUp(tc);
                } else if (source == TablePanel.ra$_btnMoveDown(TablePanel.this)) {
                    TablePanel.this.moveDown(tc);
                }
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            TablePanel.mav$updateButtons(TablePanel.this);
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

