/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnnotationPanel
extends JPanel {
    private XmlModel model;
    private Node annotation;
    private Node documentation;
    private JTextArea text;

    public AnnotationPanel(XmlModel model, Node annotation) {
        this.model = model;
        this.annotation = annotation;
        this.initialize();
    }

    public void dispose(boolean finished) {
        if (finished) {
            Document document = this.documentation.getOwnerDocument();
            this.removeAllText(this.documentation);
            String str = this.text.getText();
            String[] parts = str.split("\n");
            int i = 0;
            while (i < parts.length) {
                if (parts[i].trim().length() > 0) {
                    this.documentation.appendChild(document.createTextNode(parts[i]));
                }
                ++i;
            }
            if (this.documentation.getParentNode() == null) {
                DefaultPrefixLookup prefixLookup = this.model.getDefaultPrefixLookup();
                NamespaceUtils.fixPrefixes((Node)this.annotation, (Node)this.documentation, (DefaultPrefixLookup)prefixLookup);
                this.annotation.appendChild(this.documentation);
            }
        }
        this.annotation = null;
        this.documentation = null;
        this.text = null;
    }

    public Component getInitialFocus() {
        return this.text;
    }

    private void initialize() {
        this.documentation = ModelUtils.getChild(this.annotation, "documentation");
        if (this.documentation == null) {
            Document document = this.annotation.getOwnerDocument();
            this.documentation = document.createElementNS("http://www.w3.org/2001/XMLSchema", "documentation");
        }
        this.setLayout(new BorderLayout(5, 5));
        this.text = new JTextArea(this.getText(this.documentation), 5, 5);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        JLabel label = new JLabel(XmlSchemaArb.getString(62));
        label.setDisplayedMnemonic(XmlSchemaArb.getInteger(44));
        label.setLabelFor(this.text);
        this.add((Component)label, "North");
        this.add((Component)new JScrollPane(this.text), "Center");
    }

    private String getText(Node node) {
        StringBuffer buffer = new StringBuffer();
        Node child = node.getFirstChild();
        while (child != null) {
            String value;
            if (child.getNodeType() == 3 && (value = child.getNodeValue().trim()).length() > 0) {
                if (buffer.length() > 0) {
                    buffer.append("\n");
                }
                buffer.append(value);
            }
            child = child.getNextSibling();
        }
        return ModelUtils.translateXmlMarkup(buffer.toString());
    }

    private void removeAllText(Node node) {
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        int i = length - 1;
        while (i >= 0) {
            Node child = list.item(i);
            if (child.getNodeType() == 3) {
                node.removeChild(child);
            }
            --i;
        }
    }
}

