/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import oracle.jdevimpl.xml.schema.ModelManager;
import org.w3c.dom.Attr;

public class GlobalReference {
    public static final int GLOBAL_TYPE_UNKNOWN = 0;
    public static final int GLOBAL_TYPE_ELEMENT = 1;
    public static final int GLOBAL_TYPE_COMPLEX_TYPE = 2;
    public static final int GLOBAL_TYPE_SIMPLE_TYPE = 3;
    public static final int GLOBAL_TYPE_SIMPLE_OR_COMPLEX_TYPE = 4;
    public static final int GLOBAL_TYPE_MODEL_GROUP = 5;
    public static final int GLOBAL_TYPE_ATTRIBUTE = 6;
    public static final int GLOBAL_TYPE_ATTRIBUTE_GROUP = 7;
    public static final int REFERENCE_TYPE_UNKNOWN = 0;
    public static final int REFERENCE_TYPE_REF = 1;
    public static final int REFERENCE_TYPE_RESTRICTION_BASE = 2;
    public static final int REFERENCE_TYPE_EXTENSION_BASE = 3;
    public static final int REFERENCE_TYPE_ELEMENT_TYPE = 4;
    public static final int REFERENCE_TYPE_LIST_TYPE = 5;
    public static final int REFERENCE_TYPE_UNION_TYPE = 6;
    public static final String EMPTY_NAMESPACE = "%empty%";
    public static final String UKNOWN_NAMESPACE = "%unknown%";
    public String namespace;
    public String name;
    public int type;
    public int referenceType;
    public Attr attr;

    public GlobalReference(String namespace, String name, int type) {
        this(namespace, name, type, 0);
    }

    public GlobalReference(String namespace, String name, int type, int referenceType) {
        this(namespace, name, type, referenceType, null);
    }

    public GlobalReference(String namespace, String name, int type, int referenceType, Attr attr) {
        this.namespace = namespace;
        this.name = name;
        this.type = type;
        this.referenceType = referenceType;
        this.attr = attr;
    }

    public int hashCode() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.namespace == null ? EMPTY_NAMESPACE : this.namespace);
        buffer.append(this.name);
        if (this.type == 2 || this.type == 3) {
            buffer.append(4);
        } else {
            buffer.append(this.type);
        }
        return buffer.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GlobalReference) {
            GlobalReference other = (GlobalReference)obj;
            return GlobalReference.areTypesEqual(this.type, other.type) && this.namespace.equals(other.namespace) && this.name.equals(other.name);
        }
        return false;
    }

    public static boolean areTypesEqual(int type1, int type2) {
        return type1 == type2 || type1 == 4 && (type2 == 2 || type2 == 3) || type2 == 4 && (type1 == 2 || type1 == 3);
    }

    public int getReferenceType() {
        return this.referenceType;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Attr getAttr() {
        return this.attr;
    }

    public boolean isBuiltInType() {
        return ModelManager.isBuiltInType(this);
    }
}

