/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.NodeListener;
import oracle.jdevimpl.xml.schema.ProxyNode;
import oracle.jdevimpl.xml.schema.SelectionListener;
import oracle.jdevimpl.xml.schema.XmlSchemaMetadataResolver;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelManager {
    private XmlSchemaModel baseModel;
    private ModelHandler baseModelHandler;
    private HashMap nodeHandlers;
    private HashMap referenceMap;
    private HashMap globalMap;
    private HashMap globalNodeMap;
    private HashMap modelHandlers;
    private LinkedList listeners;
    private LinkedList selectionListeners;
    private HashMap proxyMap;
    private static final String[] BUILT_IN_TYPES = new String[]{"anySimpleType", "anyType", "anyURI", "base64Binary", "boolean", "byte", "date", "dateTime", "decimal", "double", "duration", "ENTITIES", "ENTITY", "float", "gDay", "gMonth", "gMonthDay", "gYear", "gYearMonth", "hexBinary", "ID", "IDREF", "IDREFS", "int", "integer", "language", "long", "Name", "NCName", "negativeInteger", "NMTOKEN", "NMTOKENS", "nonNegativeInteger", "nonPositiveInteger", "normalizedString", "NOTATION", "positiveInteger", "QName", "short", "string", "time", "token", "unsignedByte", "unsignedInt", "unsignedLong", "unsignedShort"};

    private void $init$() {
        this.nodeHandlers = new HashMap();
        this.referenceMap = new HashMap();
        this.globalMap = new HashMap();
        this.globalNodeMap = new HashMap();
        this.modelHandlers = new HashMap();
        this.listeners = new LinkedList();
        this.selectionListeners = new LinkedList();
        this.proxyMap = new HashMap();
    }

    public ModelManager(XmlSchemaModel baseModel) {
        this.$init$();
        this.baseModel = baseModel;
        this.loadBaseModel();
    }

    protected void addProxyNode(ProxyNode proxy) {
        LinkedList<ProxyNode> list = (LinkedList<ProxyNode>)this.proxyMap.get(proxy.getReferee());
        if (list == null) {
            list = new LinkedList<ProxyNode>();
            this.proxyMap.put(proxy.getReferee(), list);
        }
        list.add(proxy);
    }

    protected void removeProxyNode(ProxyNode proxy) {
        List list = (List)this.proxyMap.get(proxy.getReferee());
        if (list != null) {
            list.remove(proxy);
            if (list.isEmpty()) {
                this.proxyMap.remove(proxy.getReferee());
            }
        }
    }

    public static boolean isBuiltInType(GlobalReference reference) {
        if ("http://www.w3.org/2001/XMLSchema".equals(reference.getNamespace())) {
            String name = reference.getName();
            return ModelManager.isBuiltInType(name);
        }
        return false;
    }

    public static boolean isBuiltInType(String type) {
        int i = 0;
        while (i < BUILT_IN_TYPES.length) {
            if (BUILT_IN_TYPES[i].equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void loadBaseModel() {
        URL url = ((JDevXmlContext)this.baseModel.getContext()).getIdeDocument().getURL();
        this.baseModelHandler = new ModelHandler(url, this.baseModel);
        this.baseModelHandler.acquire();
    }

    public List getGlobals(Node referringNode, int type) {
        ArrayList<String> list = new ArrayList<String>();
        boolean isSimpleType = GlobalReference.areTypesEqual(type, 3);
        if (isSimpleType) {
            String prefix = this.getPrefixForNamespace(referringNode, "http://www.w3.org/2001/XMLSchema");
            int i = 0;
            while (i < BUILT_IN_TYPES.length) {
                if (prefix != null) {
                    list.add(prefix + ":" + BUILT_IN_TYPES[i]);
                } else {
                    list.add(BUILT_IN_TYPES[i]);
                }
                ++i;
            }
        }
        for (GlobalReference reference : this.globalMap.keySet()) {
            if (!GlobalReference.areTypesEqual(reference.getType(), type)) continue;
            String prefix = this.getPrefixForNamespace(referringNode, reference.getNamespace());
            if (prefix != null) {
                list.add(prefix + ":" + reference.getName());
                continue;
            }
            if (!this.getDefaultNamespace(referringNode).equals(reference.getNamespace())) continue;
            list.add(reference.getName());
        }
        list.trimToSize();
        return list;
    }

    public void addNodeListener(NodeListener listener) {
        this.listeners.add(listener);
    }

    public void removeNodeListener(NodeListener listener) {
        this.listeners.remove(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void addNodeListener(Node node, NodeListener listener) {
        NodeHandler handler = (NodeHandler)this.nodeHandlers.get(node);
        if (handler == null) {
            handler = new NodeHandler(node);
            this.nodeHandlers.put(node, handler);
        }
        handler.getListeners().add(listener);
    }

    public void removeNodeListener(Node node, NodeListener listener) {
        NodeHandler handler = (NodeHandler)this.nodeHandlers.get(node);
        if (handler != null) {
            List listeners = handler.getListeners();
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                handler.destroy();
                this.nodeHandlers.remove(node);
            }
        }
    }

    public GlobalReference getReference(Node node) {
        GlobalReference reference = null;
        if ("http://www.w3.org/2001/XMLSchema".equals(node.getNamespaceURI()) && node.getNodeType() == 1) {
            Element element = (Element)node;
            String localName = node.getLocalName();
            if (localName != null) {
                Attr ref;
                if ("element".equals(localName)) {
                    Attr ref2 = element.getAttributeNodeNS(null, "ref");
                    if (ref2 != null) {
                        reference = new GlobalReference(this.getNamespace(ref2.getOwnerElement(), ref2.getValue()), ModelUtils.getName(ref2.getValue()), 1, 1, ref2);
                    } else {
                        Attr type = element.getAttributeNodeNS(null, "type");
                        if (type != null) {
                            reference = new GlobalReference(this.getNamespace(type.getOwnerElement(), type.getValue()), ModelUtils.getName(type.getValue()), 4, 4, type);
                        } else {
                            Node complexType = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"complexType");
                            if (complexType != null) {
                                reference = this.getComplexTypeReference(complexType);
                            } else {
                                Node simpleType = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleType");
                                if (simpleType != null) {
                                    reference = this.getSimpleTypeReference(simpleType);
                                }
                            }
                        }
                    }
                } else if ("group".equals(localName)) {
                    Attr ref3 = element.getAttributeNodeNS(null, "ref");
                    if (ref3 != null) {
                        reference = new GlobalReference(this.getNamespace(ref3.getOwnerElement(), ref3.getValue()), ModelUtils.getName(ref3.getValue()), 5, 1, ref3);
                    }
                } else if ("complexType".equals(localName) && ModelUtils.getName(node) != null) {
                    reference = this.getComplexTypeReference(node);
                } else if ("simpleType".equals(localName)) {
                    reference = this.getSimpleTypeReference(node);
                } else if ("attribute".equals(localName)) {
                    Attr ref4 = element.getAttributeNodeNS(null, "ref");
                    if (ref4 != null) {
                        reference = new GlobalReference(this.getNamespace(ref4.getOwnerElement(), ref4.getValue()), ModelUtils.getName(ref4.getValue()), 6, 1, ref4);
                    }
                } else if ("attributeGroup".equals(localName) && (ref = element.getAttributeNodeNS(null, "ref")) != null) {
                    reference = new GlobalReference(this.getNamespace(ref.getOwnerElement(), ref.getValue()), ModelUtils.getName(ref.getValue()), 7, 1, ref);
                }
            }
        }
        return reference;
    }

    private GlobalReference getComplexTypeReference(Node node) {
        GlobalReference reference = null;
        Node content = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"complexContent");
        if (content == null) {
            content = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleContent");
        }
        if (content != null) {
            reference = this.getExtensionOrRestrictionBase(content);
        }
        return reference;
    }

    private GlobalReference getSimpleTypeReference(Node node) {
        return this.getExtensionOrRestrictionBase(node);
    }

    private GlobalReference getExtensionOrRestrictionBase(Node node) {
        boolean isExtension = true;
        Element element = (Element)DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"extension");
        if (element == null) {
            isExtension = false;
            element = (Element)DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction");
        }
        if (element != null) {
            Node simpleType;
            Attr base = element.getAttributeNodeNS(null, "base");
            if (base != null) {
                return new GlobalReference(this.getNamespace(base.getOwnerElement(), base.getValue()), ModelUtils.getName(base.getValue()), 4, isExtension ? 3 : 2, base);
            }
            if (!isExtension && (simpleType = DomUtils.getNamedChild((Node)element, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleType")) != null) {
                return this.getExtensionOrRestrictionBase(simpleType);
            }
        }
        return null;
    }

    public Node resolveReference(GlobalReference reference) {
        return (Node)this.globalMap.get(reference);
    }

    public void addGlobalComponent(GlobalComponent global) {
        this.globalMap.put(global.getReference(), global.getNode());
        this.globalNodeMap.put(global.getNode(), global);
        this.fireGlobalChanged(global);
    }

    public void removeGlobalComponent(GlobalComponent global) {
        this.globalMap.remove(global.getReference());
        this.globalNodeMap.remove(global.getNode());
        this.fireGlobalChanged(global);
    }

    protected final String getNamespace(Node referringNode, String qname) {
        String namespace = null;
        String prefix = ModelUtils.getPrefix(qname);
        if (prefix != null) {
            namespace = this.getNamespaceForPrefix(referringNode, prefix);
            if (namespace == null) {
                namespace = "%unknown%";
            }
        } else {
            namespace = this.getDefaultNamespace(referringNode);
        }
        return namespace;
    }

    private Element getSchemaElement(Node node) {
        Node current = node;
        while (current != null) {
            if (current.getNodeType() == 1 && this.isSchemaElement((Element)current)) {
                return (Element)current;
            }
            current = current.getParentNode();
        }
        return null;
    }

    private boolean isSchemaElement(Element element) {
        return "http://www.w3.org/2001/XMLSchema".equals(element.getNamespaceURI()) && "schema".equals(element.getLocalName());
    }

    protected final String getNamespaceForPrefix(Node referringNode, String prefix) {
        Attr attr;
        Element schema = this.getSchemaElement(referringNode);
        if (schema != null && (attr = schema.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", prefix)) != null) {
            return attr.getValue();
        }
        return null;
    }

    protected final String getPrefixForNamespace(Node referringNode, String namespace) {
        Element schema = this.getSchemaElement(referringNode);
        if (schema != null) {
            NamedNodeMap attributes = schema.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                String value;
                Attr attribute = (Attr)attributes.item(i);
                String name = attribute.getName();
                if (name != null && name.startsWith("xmlns") && namespace.equals(value = attribute.getValue())) {
                    int colon = name.indexOf(58);
                    if (colon == -1) break;
                    return name.substring(colon + 1);
                }
                ++i;
            }
        }
        return null;
    }

    private void fireNodeChanged(Node node) {
        Node owner;
        List list = (List)this.proxyMap.get(node);
        if (list != null) {
            for (ProxyNode proxy : list) {
                proxy.resetChildren();
            }
        }
        for (NodeListener listener : (List)this.listeners.clone()) {
            listener.nodeChanged(node);
        }
        NodeHandler handler = (NodeHandler)this.nodeHandlers.get(node);
        if (handler != null) {
            handler.fireNodeChanged();
            GlobalComponent global = (GlobalComponent)this.globalNodeMap.get(node);
            if (global != null) {
                String newName = ModelUtils.getName(node);
                GlobalReference reference = global.getReference();
                if (ModelUtils.areDifferent(reference.name, newName)) {
                    this.removeGlobalComponent(global);
                    reference.name = newName;
                    this.addGlobalComponent(global);
                } else {
                    this.fireGlobalChanged(global);
                }
            }
        }
        if ((owner = this.getContainerOwner(node)) != null) {
            this.fireNodeChanged(owner);
        }
    }

    private void fireSelectionChanged() {
        for (SelectionListener listener : (List)this.selectionListeners.clone()) {
            listener.selectionChanged();
        }
    }

    private Node getContainerOwner(Node node) {
        this.baseModel.acquireReadLock();
        try {
            Node owner = null;
            XmlSchemaMetadataResolver resolver = (XmlSchemaMetadataResolver)this.baseModel.getXmlMetadataResolver();
            Node current = node;
            int role = resolver.getSchemaRole(current);
            String name = ModelUtils.getName(current);
            while (ModelUtils.isContainerRole(role) || (role == 20 || role == 8) && name == null) {
                if ((current = current.getParentNode()) == null) break;
                role = resolver.getSchemaRole(current);
                name = ModelUtils.getName(current);
            }
            if (current != node) {
                owner = current;
            }
            Node node2 = owner;
            return node2;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.baseModel.releaseReadLock();
        }
    }

    private void fireGlobalChanged(GlobalComponent global) {
        GlobalComponent changeRoot = global;
        Stack<GlobalComponent> stack = new Stack<GlobalComponent>();
        stack.push(global);
        while (!stack.isEmpty()) {
            GlobalComponent current = (GlobalComponent)stack.pop();
            GlobalReference reference = current.getReference();
            LinkedList list = (LinkedList)this.referenceMap.get(reference);
            if (list == null) continue;
            for (NodeHandler handler : (List)list.clone()) {
                handler.fireNodeChanged();
                global = (GlobalComponent)this.globalNodeMap.get(handler.getNode());
                if (global == null || global == changeRoot) continue;
                stack.push(global);
            }
        }
    }

    private void addReference(GlobalReference reference, NodeHandler handler) {
        LinkedList<NodeHandler> list = (LinkedList<NodeHandler>)this.referenceMap.get(reference);
        if (list == null) {
            list = new LinkedList<NodeHandler>();
            this.referenceMap.put(reference, list);
        }
        list.add(handler);
    }

    private void removeReference(GlobalReference reference, NodeHandler handler) {
        List list = (List)this.referenceMap.get(reference);
        if (list != null) {
            list.remove(handler);
            if (list.isEmpty()) {
                this.referenceMap.remove(reference);
            }
        }
    }

    protected String getDefaultNamespace(Node node) {
        Attr attr;
        Element schema = this.getSchemaElement(node);
        if (schema != null && (attr = schema.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns")) != null) {
            return attr.getValue();
        }
        return "%empty%";
    }

    private int getGlobalType(Node node) {
        if (node.getNodeType() == 1 && "http://www.w3.org/2001/XMLSchema".equals(node.getNamespaceURI())) {
            String name = node.getLocalName();
            if ("element".equals(name)) {
                return 1;
            }
            if ("complexType".equals(name)) {
                return 2;
            }
            if ("simpleType".equals(name)) {
                return 3;
            }
            if ("group".equals(name)) {
                return 5;
            }
            if ("attribute".equals(name)) {
                return 6;
            }
            if ("attributeGroup".equals(name)) {
                return 7;
            }
        }
        return 0;
    }

    protected ModelHandler getModelHandler(URL curUrl, String location) {
        XmlModel model;
        ModelHandler handler = null;
        URL url = this.locateSchema(curUrl, location);
        if (url != null && (handler = (ModelHandler)((Object)this.modelHandlers.get(url))) == null && (model = this.baseModel.getContext().getRelatedXmlModel(url)) != null) {
            handler = new ModelHandler(url, model);
        }
        if (handler != null) {
            handler.acquire();
        }
        return handler;
    }

    private URL locateSchema(URL curUrl, String location) {
        URL url;
        block7: {
            url = null;
            try {
                url = new URL(location);
                if (!this.isLocalURL(url)) {
                    url = null;
                }
            }
            catch (MalformedURLException mue) {
                url = this.baseModel.getContext().getURLForRelativePath(location);
                if (URLFileSystem.exists((URL)url) || URLFileSystem.exists((URL)(url = URLFactory.newFileURL((String)location)))) break block7;
                url = null;
            }
        }
        if (url == null) {
            try {
                url = new URL(curUrl, location);
                if (!this.isLocalURL(url)) {
                    url = null;
                }
            }
            catch (MalformedURLException mfe) {
                url = null;
            }
        }
        return url;
    }

    private boolean isLocalURL(URL url) {
        URL baseURL = ((JDevXmlContext)this.baseModel.getContext()).getIdeDocument().getURL();
        return "file".equals(url.getProtocol()) || "oramds".equals(url.getProtocol()) || url.getProtocol().equals(baseURL.getProtocol()) && url.getHost().equals(baseURL.getHost());
    }

    private boolean isDocumentChangedEvent(XmlModelEvent event) {
        Node node;
        if (event.isPropertyChanged() && event.containsPropertyChange("documentChanged")) {
            return true;
        }
        return event.isDomTreeChanged() && (node = event.getChangeRoot()) != null && node.getNodeType() == 9;
    }

    static boolean mav$isSchemaElement(ModelManager modelManager, Element element) {
        return modelManager.isSchemaElement(element);
    }

    static HashMap ra$modelHandlers(ModelManager modelManager) {
        return modelManager.modelHandlers;
    }

    static boolean mav$isDocumentChangedEvent(ModelManager modelManager, XmlModelEvent xmlModelEvent) {
        return modelManager.isDocumentChangedEvent(xmlModelEvent);
    }

    static void mav$fireNodeChanged(ModelManager modelManager, Node node) {
        modelManager.fireNodeChanged(node);
    }

    static XmlSchemaModel ra$baseModel(ModelManager modelManager) {
        return modelManager.baseModel;
    }

    static void mav$fireSelectionChanged(ModelManager modelManager) {
        modelManager.fireSelectionChanged();
    }

    static int mav$getGlobalType(ModelManager modelManager, Node node) {
        return modelManager.getGlobalType(node);
    }

    static HashMap ra$proxyMap(ModelManager modelManager) {
        return modelManager.proxyMap;
    }

    static void mav$removeReference(ModelManager modelManager, GlobalReference globalReference, NodeHandler nodeHandler) {
        modelManager.removeReference(globalReference, nodeHandler);
    }

    static void mav$addReference(ModelManager modelManager, GlobalReference globalReference, NodeHandler nodeHandler) {
        modelManager.addReference(globalReference, nodeHandler);
    }

    private class ModelHandler
    extends XmlModelAdapter {
        private URL location;
        private XmlModel model;
        public int refCount;
        private ArrayList<Schema> schemas;

        private void $init$() {
            this.schemas = new ArrayList(3);
        }

        public ModelHandler(URL location, XmlModel model) {
            this.$init$();
            this.location = location;
            this.model = model;
            ModelManager.ra$modelHandlers(ModelManager.this).put(location, this);
            model.addModelListener((XmlModelListener)this);
            this.reload();
        }

        public void acquire() {
            ++this.refCount;
        }

        public void release() {
            if (--this.refCount == 0) {
                this.destroy();
            }
        }

        public void modelChanged(XmlModelEvent event) {
            if (ModelManager.mav$isDocumentChangedEvent(ModelManager.this, event)) {
                this.reload();
            } else if (event.isDomTreeChanged()) {
                Node node = event.getChangeRoot();
                if (node != null) {
                    ModelManager.mav$fireNodeChanged(ModelManager.this, node);
                }
                if (event.matchesFlags(3)) {
                    NodeChangeDetails details = event.getNodeChangeDetails();
                    if (details != null && details != NodeChangeDetails.NO_DETAILS_AVAILABLE) {
                        for (Node current : details.getAddedNodes()) {
                            Element element;
                            if (current.getNodeType() != 1 || !ModelManager.mav$isSchemaElement(ModelManager.this, element = (Element)current)) continue;
                            this.schemas.add(new Schema(element, this.location));
                        }
                        for (Node current : details.getRemovedNodes()) {
                            Element element;
                            if (current.getNodeType() != 1 || !ModelManager.mav$isSchemaElement(ModelManager.this, element = (Element)current)) continue;
                            Iterator<Schema> iterator = this.schemas.iterator();
                            while (iterator.hasNext()) {
                                Schema schema = iterator.next();
                                if (schema.getElement() != element) continue;
                                iterator.remove();
                            }
                        }
                    } else {
                        this.reload();
                    }
                }
            }
            if ((event.isSelectionChanged() || event.isPropertyChanged() && event.containsPropertyChange("cursorLocation")) && this.model == ModelManager.ra$baseModel(ModelManager.this)) {
                ModelManager.mav$fireSelectionChanged(ModelManager.this);
            }
        }

        public void destroy() {
            ModelManager.ra$modelHandlers(ModelManager.this).remove(this.location);
            this.model.removeModelListener((XmlModelListener)this);
            for (Schema schema : this.schemas) {
                schema.destroy();
            }
        }

        private void reload() {
            for (Schema schema : this.schemas) {
                schema.destroy();
            }
            this.schemas.clear();
            this.model.acquireReadLock();
            try {
                Element element;
                Document document;
                if (this.model.isDocumentValid() && (document = this.model.getDocument()) != null && (element = document.getDocumentElement()) != null) {
                    if (ModelManager.mav$isSchemaElement(ModelManager.this, element)) {
                        this.schemas.add(new Schema(element, this.location));
                    } else {
                        NodeList list = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
                        int len = list.getLength();
                        int i = 0;
                        while (i < len) {
                            this.schemas.add(new Schema((Element)list.item(i), this.location));
                            ++i;
                        }
                    }
                }
            }
            finally {
                this.model.releaseReadLock();
            }
        }
    }

    private class Schema
    implements NodeListener {
        private Element element;
        private LinkedList globals;
        private LinkedList references;
        private URL location;

        private void $init$() {
            this.globals = new LinkedList();
            this.references = new LinkedList();
        }

        public Schema(Element element) {
            this.$init$();
            this.element = element;
            this.load();
            ModelManager.this.addNodeListener(element, this);
        }

        public Schema(Element element, URL location) {
            this.$init$();
            this.element = element;
            this.setLocation(location);
            this.load();
            ModelManager.this.addNodeListener(element, this);
        }

        public Element getElement() {
            return this.element;
        }

        public String getTargetNamespace() {
            String namespace = ModelUtils.getAttribute(this.element, "targetNamespace");
            if (namespace == null) {
                namespace = ModelManager.this.getDefaultNamespace(this.element);
            }
            return namespace;
        }

        public void nodeChanged(Node node) {
            this.reload();
        }

        public void destroy() {
            ModelManager.this.removeNodeListener(this.element, this);
            this.unload();
        }

        private void reload() {
            this.unload();
            ModelManager.ra$proxyMap(ModelManager.this).clear();
            this.load();
        }

        private void unload() {
            for (GlobalComponent global : this.globals) {
                ModelManager.this.removeGlobalComponent(global);
                global.destroy();
            }
            this.globals.clear();
            for (ModelReference reference : this.references) {
                reference.destroy();
            }
            this.references.clear();
        }

        private void load() {
            String targetNamespace = this.getTargetNamespace();
            Node node = this.element.getFirstChild();
            while (node != null) {
                int type = ModelManager.mav$getGlobalType(ModelManager.this, node);
                if (type != 0) {
                    GlobalReference reference = new GlobalReference(targetNamespace, ModelUtils.getName(node), type);
                    GlobalComponent global = new GlobalComponent(reference, node);
                    ModelManager.this.addGlobalComponent(global);
                    this.globals.add(global);
                } else if ("include".equals(node.getLocalName()) || "import".equals(node.getLocalName())) {
                    this.references.add(new ModelReference(this, node));
                }
                node = node.getNextSibling();
            }
        }

        public void setLocation(URL location) {
            this.location = location;
        }

        public URL getLocation() {
            return this.location;
        }
    }

    private class NodeHandler {
        private Node node;
        private LinkedList listeners;
        private GlobalReference reference;

        private void $init$() {
            this.listeners = new LinkedList();
        }

        public NodeHandler(Node node) {
            this.$init$();
            this.node = node;
            this.updateReference();
        }

        public Node getNode() {
            return this.node;
        }

        public void destroy() {
            if (this.reference != null) {
                ModelManager.mav$removeReference(ModelManager.this, this.reference, this);
            }
        }

        public List getListeners() {
            return this.listeners;
        }

        public void fireNodeChanged() {
            this.updateReference();
            for (NodeListener listener : (List)this.listeners.clone()) {
                listener.nodeChanged(this.node);
            }
        }

        private void updateReference() {
            GlobalReference oldReference = this.reference;
            this.reference = ModelManager.this.getReference(this.node);
            if (this.reference != null && !this.reference.equals(oldReference)) {
                if (oldReference != null) {
                    ModelManager.mav$removeReference(ModelManager.this, oldReference, this);
                }
                if (this.reference != null) {
                    ModelManager.mav$addReference(ModelManager.this, this.reference, this);
                }
            }
        }
    }

    private class GlobalComponent
    implements NodeListener {
        private GlobalReference reference;
        private Node node;

        public GlobalComponent(GlobalReference reference, Node node) {
            this.reference = reference;
            this.node = node;
            if (node != null) {
                ModelManager.this.addNodeListener(node, this);
            }
        }

        public void destroy() {
            if (this.node != null) {
                ModelManager.this.removeNodeListener(this.node, this);
            }
        }

        public GlobalReference getReference() {
            return this.reference;
        }

        public Node getNode() {
            return this.node;
        }

        public void nodeChanged(Node node) {
        }
    }

    private class ModelReference
    implements NodeListener {
        protected Schema parent;
        protected ModelHandler modelHandler;
        protected Node node;
        private String location;

        public ModelReference(Node node) {
            this(null, node);
        }

        public ModelReference(Schema parent, Node node) {
            this.parent = parent;
            this.node = node;
            ModelManager.this.addNodeListener(node, this);
            this.reload();
        }

        public void destroy() {
            if (this.modelHandler != null) {
                this.modelHandler.release();
            }
            ModelManager.this.removeNodeListener(this.node, this);
        }

        public void nodeChanged(Node node) {
            this.reload();
        }

        private void reload() {
            String oldLocation = this.location;
            this.location = this.getLocation();
            if (this.modelHandler == null || ModelUtils.areDifferent(oldLocation, this.location)) {
                if (this.modelHandler != null) {
                    this.modelHandler.release();
                }
                if (this.location != null) {
                    this.modelHandler = ModelManager.this.getModelHandler(this.parent.getLocation(), this.location);
                }
            }
        }

        protected String getLocation() {
            return ModelUtils.getAttribute((Element)this.node, "schemaLocation");
        }
    }
}

