/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.button.ButtonBar;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.XmlSchemaTreeTraversal;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespacePanel
extends JPanel {
    private Element schema;
    private JTextField targetNamespace;
    private JTextField defaultNamespace;
    private JTable prefixTable;
    private DefaultTableModel prefixModel;
    private JButton removeButton;
    private XmlSchemaModel model;
    private static final int PREFIX_INDEX = 0;
    private static final int NAMESPACE_INDEX = 1;

    public NamespacePanel(XmlSchemaModel model, Element schema) {
        this.model = model;
        this.schema = schema;
        this.createUI();
        this.loadData();
    }

    public boolean validateData() {
        TableCellEditor editor = this.prefixTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        String targetNS = this.targetNamespace.getText().trim();
        String defaultNS = this.defaultNamespace.getText().trim();
        boolean hasTargetNSPrefix = targetNS.length() == 0 || defaultNS.equals(targetNS);
        boolean hasSchemaNSPrefix = defaultNS.equals("http://www.w3.org/2001/XMLSchema");
        int rowCount = this.prefixModel.getRowCount();
        HashSet<String> alreadySeen = new HashSet<String>(rowCount);
        int i = 0;
        while (i < rowCount) {
            String prefix = ((String)this.prefixModel.getValueAt(i, 0)).trim();
            String namespace = ((String)this.prefixModel.getValueAt(i, 1)).trim();
            if (prefix.length() > 0) {
                if (!hasTargetNSPrefix && namespace.equals(targetNS)) {
                    hasTargetNSPrefix = true;
                }
                if (!hasSchemaNSPrefix && namespace.equals("http://www.w3.org/2001/XMLSchema")) {
                    hasSchemaNSPrefix = true;
                }
            }
            if (prefix.length() > 0) {
                if (alreadySeen.contains(prefix)) {
                    String pattern = XmlSchemaArb.getString(51);
                    MessageFormat formatter = new MessageFormat(pattern);
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), formatter.format(new Object[]{prefix}), XmlSchemaArb.getString(52), 0);
                    return false;
                }
                alreadySeen.add(prefix);
            }
            if (prefix.length() == 0 && namespace.length() > 0) {
                String pattern = XmlSchemaArb.getString(60);
                MessageFormat formatter = new MessageFormat(pattern);
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), formatter.format(new Object[]{namespace}), XmlSchemaArb.getString(52), 0);
                return false;
            }
            if (prefix.length() > 0 && namespace.length() == 0) {
                String pattern = XmlSchemaArb.getString(17);
                MessageFormat formatter = new MessageFormat(pattern);
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), formatter.format(new Object[]{prefix}), XmlSchemaArb.getString(52), 0);
                return false;
            }
            ++i;
        }
        alreadySeen.clear();
        if (!hasTargetNSPrefix) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), XmlSchemaArb.getString(42), XmlSchemaArb.getString(52), 0);
            return false;
        }
        if (!hasSchemaNSPrefix) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), XmlSchemaArb.getString(54), XmlSchemaArb.getString(52), 0);
            return false;
        }
        return true;
    }

    public void commitData() {
        Attr attr = this.schema.getAttributeNodeNS(null, "targetNamespace");
        String oldTargetNS = attr == null ? null : attr.getValue();
        attr = this.schema.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        String oldDefaultNS = attr == null ? null : attr.getValue();
        String text = this.targetNamespace.getText().trim();
        String newTargetNS = text.length() == 0 ? null : text;
        text = this.defaultNamespace.getText().trim();
        String newDefaultNS = text.length() == 0 ? null : text;
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        int rowCount = this.prefixModel.getRowCount();
        int i = 0;
        while (i < rowCount) {
            String prefix = ((String)this.prefixModel.getValueAt(i, 0)).trim();
            String namespace = ((String)this.prefixModel.getValueAt(i, 1)).trim();
            if (prefix.trim().length() > 0 && namespace.trim().length() > 0) {
                prefixMap.put(namespace, prefix);
            }
            ++i;
        }
        boolean prefixChanged = false;
        Stack<Node> stack = new Stack<Node>();
        stack.push(this.schema);
        while (!stack.isEmpty()) {
            Node current = (Node)stack.pop();
            String namespace = current.getNamespaceURI();
            if (namespace != null && !"http://www.w3.org/2000/xmlns/".equals(namespace) && !"http://www.w3.org/XML/1998/namespace".equals(namespace)) {
                String prefix = (String)prefixMap.get(namespace);
                String oldPrefix = current.getPrefix();
                if (oldPrefix != null && !oldPrefix.equals(prefix) || oldPrefix == null && prefix != null) {
                    current.setPrefix(prefix);
                    prefixChanged = true;
                }
            }
            NodeList children = current.getChildNodes();
            int i2 = 0;
            while (i2 < children.getLength()) {
                Node child = children.item(i2);
                if (child.getNodeType() == 1) {
                    stack.push(children.item(i2));
                }
                ++i2;
            }
            NamedNodeMap attributes = current.getAttributes();
            if (attributes == null) continue;
            int i3 = 0;
            while (i3 < attributes.getLength()) {
                stack.push(attributes.item(i3));
                ++i3;
            }
        }
        XmlSchemaTreeTraversal traversal = this.model.getSchemaTraversal();
        stack.push(this.schema);
        while (!stack.isEmpty()) {
            Node current = (Node)stack.pop();
            if (current instanceof ReferenceNode) {
                String value;
                int colon;
                ReferenceNode reference = (ReferenceNode)((Object)current);
                Attr refAttr = reference.getReference().getAttr();
                if (refAttr == null) continue;
                String namespace = reference.getReference().getNamespace();
                String prefix = null;
                if ("%unknown%".equals(namespace)) continue;
                if ("%empty%".equals(namespace)) {
                    if (oldDefaultNS == null) continue;
                    prefix = (String)prefixMap.get(oldDefaultNS);
                    if (prefix == null && oldDefaultNS.equals(oldTargetNS)) {
                        prefix = (String)prefixMap.get(newTargetNS);
                    }
                } else {
                    prefix = (String)prefixMap.get(namespace);
                }
                String name = (colon = (value = refAttr.getValue()).indexOf(58)) > 0 ? value.substring(colon + 1) : value;
                String newValue = prefix != null && prefix.length() > 0 ? prefix + ":" + name : name;
                refAttr.setValue(newValue);
                continue;
            }
            Node child = traversal.getFirstChild(current);
            while (child != null) {
                stack.push(child);
                child = traversal.getNextSibling(child);
            }
        }
        if (newTargetNS == null) {
            this.schema.removeAttributeNS(null, "targetNamespace");
        } else {
            this.schema.setAttributeNS(null, "targetNamespace", newTargetNS);
        }
        if (newDefaultNS == null) {
            this.schema.removeAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        } else {
            this.schema.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", newDefaultNS);
        }
        NamedNodeMap oldAttributes = this.schema.getAttributes();
        HashSet<String> used = new HashSet<String>();
        for (String namespace : prefixMap.keySet()) {
            String prefix = (String)prefixMap.get(namespace);
            String qName = "xmlns:" + prefix;
            attr = (Attr)oldAttributes.getNamedItemNS("http://www.w3.org/2000/xmlns/", prefix);
            if (attr != null) {
                if (!namespace.equals(attr.getValue())) {
                    attr.setValue(namespace);
                }
            } else {
                this.schema.setAttributeNS("http://www.w3.org/2000/xmlns/", qName, namespace);
            }
            used.add(qName);
        }
        int i4 = 0;
        while (i4 < oldAttributes.getLength()) {
            attr = (Attr)oldAttributes.item(i4);
            if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) && !"xmlns".equals(attr.getName()) && !used.contains(attr.getName())) {
                this.schema.removeAttributeNode(attr);
            }
            ++i4;
        }
        if (prefixChanged) {
            Document document = this.schema.getOwnerDocument();
            document.removeChild(this.schema);
            document.appendChild(this.schema);
        }
    }

    public Component getInitialFocus() {
        return this.targetNamespace;
    }

    private void createUI() {
        this.setLayout(new BorderLayout(10, 10));
        JLabel label = new JLabel();
        label.setText(XmlSchemaArb.getString(9));
        this.add((Component)label, "North");
        this.targetNamespace = new JTextField(20);
        JLabel targetNamespaceLabel = new JLabel(XmlSchemaArb.getString(43));
        targetNamespaceLabel.setDisplayedMnemonic(XmlSchemaArb.getInteger(8));
        targetNamespaceLabel.setLabelFor(this.targetNamespace);
        this.defaultNamespace = new JTextField(20);
        JLabel defaultNamespaceLabel = new JLabel(XmlSchemaArb.getString(10));
        defaultNamespaceLabel.setDisplayedMnemonic(XmlSchemaArb.getInteger(29));
        defaultNamespaceLabel.setLabelFor(this.defaultNamespace);
        JPanel prefixPanel = new JPanel(new BorderLayout(0, 5));
        this.prefixTable = new JTable();
        this.prefixTable.setAutoResizeMode(3);
        Object[] columns = new String[]{XmlSchemaArb.getString(14), XmlSchemaArb.getString(6)};
        this.prefixModel = new DefaultTableModel(columns, 0);
        this.prefixTable.setModel(this.prefixModel);
        this.prefixTable.getTableHeader().setReorderingAllowed(false);
        this.prefixTable.setSelectionMode(2);
        this.prefixTable.setColumnSelectionAllowed(false);
        this.prefixTable.setPreferredScrollableViewportSize(new Dimension(0, 0));
        this.prefixTable.getSelectionModel().addListSelectionListener(new 1());
        TableColumn column = this.prefixTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(15);
        column = this.prefixTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(200);
        JLabel prefixLabel = new JLabel(XmlSchemaArb.getString(30));
        prefixLabel.setDisplayedMnemonic(XmlSchemaArb.getInteger(18));
        prefixLabel.setLabelFor(this.prefixTable);
        prefixPanel.add("North", prefixLabel);
        JScrollPane prefixScroller = new JScrollPane(this.prefixTable);
        prefixPanel.add("Center", prefixScroller);
        ButtonBar buttons = new ButtonBar();
        JButton addButton = new JButton(XmlSchemaArb.getString(26));
        addButton.setMnemonic(XmlSchemaArb.getInteger(25));
        this.removeButton = new JButton(XmlSchemaArb.getString(55));
        this.removeButton.setMnemonic(XmlSchemaArb.getInteger(61));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new 2());
        addButton.addActionListener(new 3());
        buttons.add((Component)addButton);
        buttons.add((Component)this.removeButton);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add("East", (Component)buttons);
        prefixPanel.add("South", buttonPanel);
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 0, 5, 12);
        layout.setConstraints(targetNamespaceLabel, gbc);
        panel.add(targetNamespaceLabel);
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 0, 5, 0);
        layout.setConstraints(this.targetNamespace, gbc);
        panel.add(this.targetNamespace);
        gbc.fill = 0;
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 5, 12);
        layout.setConstraints(defaultNamespaceLabel, gbc);
        panel.add(defaultNamespaceLabel);
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        layout.setConstraints(this.defaultNamespace, gbc);
        panel.add(this.defaultNamespace);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.gridheight = 0;
        layout.setConstraints(prefixPanel, gbc);
        panel.add(prefixPanel);
        this.add((Component)panel, "Center");
    }

    private void loadData() {
        this.targetNamespace.setText(this.schema.getAttributeNS(null, "targetNamespace"));
        this.defaultNamespace.setText(this.schema.getAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns"));
        NamedNodeMap attributes = this.schema.getAttributes();
        Object[] data = new Object[2];
        int i = 0;
        while (i < attributes.getLength()) {
            int colon;
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            if (name != null && name.startsWith("xmlns") && (colon = name.indexOf(58)) != -1) {
                String prefix = name.substring(colon + 1);
                String namespace = attr.getValue();
                data[0] = prefix;
                data[1] = namespace;
                this.prefixModel.addRow(data);
            }
            ++i;
        }
    }

    private void removeSelectedPrefixes() {
        int[] rows = this.prefixTable.getSelectedRows();
        Arrays.sort(rows);
        int i = rows.length - 1;
        while (i >= 0) {
            TableCellEditor editor;
            if (this.prefixTable.getEditingRow() == rows[i] && (editor = this.prefixTable.getCellEditor()) != null) {
                editor.stopCellEditing();
            }
            this.prefixModel.removeRow(rows[i]);
            --i;
        }
    }

    private void addPrefix() {
        this.prefixModel.addRow(new String[]{"", ""});
        int newRow = this.prefixModel.getRowCount() - 1;
        this.prefixTable.setRowSelectionInterval(newRow, newRow);
        this.prefixTable.setColumnSelectionInterval(0, 0);
        Rectangle rect = this.prefixTable.getCellRect(newRow, 0, true);
        this.prefixTable.scrollRectToVisible(rect);
        this.prefixTable.editCellAt(newRow, 0);
        Component c = this.prefixTable.getEditorComponent();
        if (c != null) {
            c.requestFocus();
        }
    }

    static JButton ra$removeButton(NamespacePanel namespacePanel) {
        return namespacePanel.removeButton;
    }

    static JTable ra$prefixTable(NamespacePanel namespacePanel) {
        return namespacePanel.prefixTable;
    }

    static void mav$removeSelectedPrefixes(NamespacePanel namespacePanel) {
        namespacePanel.removeSelectedPrefixes();
    }

    static void mav$addPrefix(NamespacePanel namespacePanel) {
        namespacePanel.addPrefix();
    }

    final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            NamespacePanel.ra$removeButton(NamespacePanel.this).setEnabled(NamespacePanel.ra$prefixTable(NamespacePanel.this).getSelectedRowCount() > 0);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            NamespacePanel.mav$removeSelectedPrefixes(NamespacePanel.this);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            NamespacePanel.mav$addPrefix(NamespacePanel.this);
        }
    }
}

