/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import oracle.bali.xml.dom.AbstractNode;
import oracle.jdevimpl.xml.schema.ModelManager;
import oracle.jdevimpl.xml.schema.ProxyAttr;
import oracle.jdevimpl.xml.schema.ProxyElement;
import oracle.jdevimpl.xml.schema.ProxyNamedNodeMap;
import oracle.jdevimpl.xml.schema.ProxyNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProxyNode
extends AbstractNode
implements Node {
    protected ModelManager manager;
    protected Document owner;
    protected Node parent;
    protected Node referee;
    private ProxyNode firstChild;
    private ProxyNode lastChild;
    private ProxyNode previousSibling;
    private ProxyNode nextSibling;

    protected ProxyNode(ModelManager manager, Document owner, Node parent, Node referee) {
        this.manager = manager;
        this.owner = owner;
        this.parent = parent;
        this.referee = referee;
    }

    public Node getReferee() {
        return this.referee;
    }

    public Document getRefereeDocument() {
        return this.referee.getOwnerDocument();
    }

    public String getNodeName() {
        return this.referee.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.referee.getNodeValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        if (this.isExternal()) {
            throw new DOMException(7, null);
        }
        this.referee.setNodeValue(nodeValue);
    }

    public short getNodeType() {
        return this.referee.getNodeType();
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        return new ProxyNodeList(this.manager, this.owner, this, this.referee.getChildNodes());
    }

    public Node getFirstChild() {
        if (this.firstChild == null) {
            this.firstChild = this.createChildProxyNode(this.referee.getFirstChild());
        }
        return this.firstChild;
    }

    public Node getLastChild() {
        if (this.lastChild == null) {
            this.lastChild = this.createChildProxyNode(this.referee.getLastChild());
        }
        return this.lastChild;
    }

    public Node getPreviousSibling() {
        if (this.previousSibling == null) {
            this.previousSibling = this.createSiblingProxyNode(this.referee.getPreviousSibling());
        }
        return this.previousSibling;
    }

    public Node getNextSibling() {
        if (this.nextSibling == null) {
            this.nextSibling = this.createSiblingProxyNode(this.referee.getNextSibling());
        }
        return this.nextSibling;
    }

    public NamedNodeMap getAttributes() {
        return new ProxyNamedNodeMap(this.manager, this.owner, this, this.referee.getAttributes());
    }

    public Document getOwnerDocument() {
        return this.owner;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (this.isExternal()) {
            throw new DOMException(7, null);
        }
        if (newChild instanceof ProxyNode) {
            newChild = ((ProxyNode)newChild).getReferee();
        }
        if (refChild instanceof ProxyNode) {
            refChild = ((ProxyNode)refChild).getReferee();
        }
        return this.referee.insertBefore(newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (this.isExternal()) {
            throw new DOMException(7, null);
        }
        if (oldChild instanceof ProxyNode) {
            oldChild = ((ProxyNode)oldChild).getReferee();
        }
        if (newChild instanceof ProxyNode) {
            newChild = ((ProxyNode)newChild).getReferee();
        }
        return this.referee.replaceChild(newChild, oldChild);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (this.isExternal()) {
            throw new DOMException(7, null);
        }
        if (oldChild instanceof ProxyNode) {
            oldChild = ((ProxyNode)oldChild).getReferee();
        }
        return this.referee.removeChild(oldChild);
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (this.isExternal()) {
            throw new DOMException(7, null);
        }
        if (newChild instanceof ProxyNode) {
            newChild = ((ProxyNode)newChild).getReferee();
        }
        return this.referee.appendChild(newChild);
    }

    public boolean hasChildNodes() {
        return this.referee.hasChildNodes();
    }

    public Node cloneNode(boolean deep) {
        return new ProxyNode(this.manager, this.owner, this.parent, this.referee.cloneNode(deep));
    }

    public void normalize() {
        this.referee.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.referee.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.referee.getNamespaceURI();
    }

    public String getPrefix() {
        return this.referee.getPrefix();
    }

    public void setPrefix(String prefix) throws DOMException {
        if (this.isExternal()) {
            throw new DOMException(7, null);
        }
        this.referee.setPrefix(prefix);
    }

    public String getLocalName() {
        return this.referee.getLocalName();
    }

    public boolean hasAttributes() {
        return this.referee.hasAttributes();
    }

    protected ProxyNode createSiblingProxyNode(Node node) {
        return ProxyNode.createProxyNode(this.manager, this.owner, this.parent, node);
    }

    protected ProxyNode createChildProxyNode(Node node) {
        return ProxyNode.createProxyNode(this.manager, this.owner, this, node);
    }

    public static ProxyNode createProxyNode(ModelManager manager, Document owner, Node parent, Node node) {
        if (node == null) {
            return null;
        }
        ProxyNode proxy = node.getNodeType() == 1 ? new ProxyElement(manager, owner, parent, (Element)node) : (node.getNodeType() == 2 ? new ProxyAttr(manager, owner, parent, (Attr)node) : new ProxyNode(manager, owner, parent, node));
        manager.addProxyNode(proxy);
        return proxy;
    }

    public boolean isExternal() {
        return this.owner != this.referee.getOwnerDocument();
    }

    public void resetChildren() {
        if (this.firstChild != null) {
            this.manager.removeProxyNode(this.firstChild);
            this.firstChild.reset();
            this.firstChild = null;
        }
        if (this.lastChild != null) {
            this.manager.removeProxyNode(this.lastChild);
            this.lastChild.reset();
            this.lastChild = null;
        }
    }

    protected void reset() {
        if (this.firstChild != null) {
            this.manager.removeProxyNode(this.firstChild);
            this.firstChild.reset();
            this.firstChild = null;
        }
        if (this.lastChild != null) {
            this.manager.removeProxyNode(this.lastChild);
            this.lastChild.reset();
            this.lastChild = null;
        }
        if (this.previousSibling != null) {
            this.manager.removeProxyNode(this.previousSibling);
            this.previousSibling.reset();
            this.previousSibling = null;
        }
        if (this.nextSibling != null) {
            this.manager.removeProxyNode(this.nextSibling);
            this.nextSibling.reset();
            this.nextSibling = null;
        }
    }
}

