/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import oracle.bali.xml.dom.AbstractNode;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.ModelManager;
import oracle.jdevimpl.xml.schema.ProxyNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReferenceNode
extends AbstractNode {
    private ModelManager manager;
    private Node parent;
    private GlobalReference reference;
    private Node referee;

    public ReferenceNode(ModelManager manager, Node parent, GlobalReference reference) {
        this.manager = manager;
        this.parent = parent;
        this.reference = reference;
        Node resolved = manager.resolveReference(reference);
        if (resolved != null) {
            this.referee = ProxyNode.createProxyNode(manager, this.getOwnerDocument(), (Node)((Object)this), resolved);
        }
    }

    public boolean isCyclicReference() {
        if (this.referee != null) {
            Node original = this.getRealNode(this.referee);
            Node current = this.getParentNode();
            while (current != null) {
                if (original.equals(this.getRealNode(current))) {
                    return true;
                }
                current = current.getParentNode();
            }
        }
        return false;
    }

    private Node getRealNode(Node node) {
        Node original = node;
        boolean isProxy = original instanceof ProxyNode;
        boolean isReference = original instanceof ReferenceNode;
        while (isProxy || isReference) {
            if (isProxy) {
                original = ((ProxyNode)original).getReferee();
            } else if (isReference) {
                original = ((ReferenceNode)((Object)original)).getReferee();
            }
            isProxy = original instanceof ProxyNode;
            isReference = original instanceof ReferenceNode;
        }
        return original;
    }

    public boolean isExternal() {
        Node referee = this.manager.resolveReference(this.reference);
        return referee != null && referee.getOwnerDocument() != this.parent.getOwnerDocument();
    }

    public GlobalReference getReference() {
        return this.reference;
    }

    public Node getReferee() {
        return this.referee;
    }

    public String getNodeName() {
        return "jdeveloper-xsd-editor";
    }

    public short getNodeType() {
        return 7;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        return new 1();
    }

    public Node getFirstChild() {
        return this.referee;
    }

    public Node getLastChild() {
        return this.referee;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        return this.parent.getFirstChild();
    }

    public Document getOwnerDocument() {
        return this.parent.getOwnerDocument();
    }

    static Node ra$referee(ReferenceNode referenceNode) {
        return referenceNode.referee;
    }

    final class 1
    implements NodeList {
        public int getLength() {
            return 1;
        }

        public Node item(int index) {
            return index == 0 ? ReferenceNode.ra$referee(ReferenceNode.this) : null;
        }
    }
}

