/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevViewHostedGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.share.PropertyChange;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;
import oracle.jdevimpl.xml.schema.diagram.ComponentFactory;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramPanel;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSchemaDesignGui
extends XmlGui
implements JDevViewHostedGui,
ComponentXmlGui {
    private View view;
    private DiagramPanel panel;
    private boolean showing;
    private XmlModelEvent bufferedEvent;

    public XmlSchemaDesignGui(XmlView view) {
        super(view);
    }

    public void dispose() {
        super.dispose();
        if (this.panel != null) {
            this.panel.dispose();
        }
    }

    public void showPopupMenu(MouseEvent event) {
        JDevXmlContext.showContextMenu((JDevViewHostedGui)this, (MouseEvent)event);
    }

    public void setOwningJDevView(View view) {
        this.view = view;
    }

    public View getOwningJDevView() {
        return this.view;
    }

    public Component getComponent() {
        if (this.panel == null) {
            this.createUI();
        }
        return this.panel;
    }

    public List getSchemaActions() {
        DiagramSchemaComponent active;
        Diagram diagram;
        if (this.panel != null && (diagram = this.panel.getDiagram()) != null && (active = diagram.getSelectionManager().getActiveComponent()) != null) {
            return active.getActions();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean handleAction(IdeAction action) {
        DiagramSchemaComponent active;
        Diagram diagram;
        if (this.panel != null && (diagram = this.panel.getDiagram()) != null && (active = diagram.getSelectionManager().getActiveComponent()) != null) {
            return active.handleAction(action);
        }
        return false;
    }

    protected void handleShown() {
        super.handleShown();
        this.showing = true;
        if (this.bufferedEvent != null) {
            this.handleModelChangeEvent(this.bufferedEvent);
            this.bufferedEvent = null;
        }
    }

    protected void handleHidden() {
        super.handleHidden();
        this.showing = false;
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
        Node node;
        Node target;
        super.handleModelChangeEvent(event);
        if (!this.showing) {
            if (this.bufferedEvent == null) {
                this.bufferedEvent = (XmlModelEvent)event.clone();
            } else {
                this.bufferedEvent.addModelEvent(event);
            }
            return;
        }
        if (this.panel == null) {
            return;
        }
        PropertyChange validityChange = event.getDomDocumentValidPropertyChange();
        if (validityChange != null) {
            boolean isValid = validityChange.getNewBooleanValue();
            this.panel.setValid(isValid);
        }
        if (event.isDomTreeChanged() && (target = event.getChangeRoot()) instanceof Node && (node = target).getNodeType() == 9) {
            this.documentChanged();
        }
        if (event.isPropertyChanged() && event.containsPropertyChange("dropLocation")) {
            this.panel.getGlassPane().repaint();
        }
    }

    protected ComponentFactory getComponentFactory() {
        return new ComponentFactory();
    }

    private void createUI() {
        this.panel = new DiagramPanel(this, this.getComponentFactory());
        this.documentChanged();
    }

    protected void documentChanged() {
        if (this.panel != null) {
            this.getView().acquireReadLock();
            try {
                Element root = null;
                if (this.getView().getBaseModel().isDocumentValid()) {
                    root = this.getRootElement(this.getView());
                }
                this.panel.setDiagramRoot(root);
                this.panel.setSupported(this.isSupported(root));
            }
            finally {
                this.getView().releaseReadLock();
            }
        }
    }

    protected Element getRootElement(XmlView view, String namespaceURI, String elementLocalName) {
        Document document = view.getDocument();
        if (document != null) {
            TreeTraversal traversal = view.getTreeTraversal();
            Node node = traversal.getNextNode((Node)document);
            while (node != null) {
                Element element;
                if (node.getNodeType() == 1 && namespaceURI.equals((element = (Element)node).getNamespaceURI()) && elementLocalName.equals(element.getLocalName())) {
                    return element;
                }
                node = traversal.getNextNode(node);
            }
        }
        return null;
    }

    protected Element getRootElement(XmlView view) {
        return this.getRootElement(view, "http://www.w3.org/2001/XMLSchema", "schema");
    }

    protected boolean isSupported(Node node) {
        return node == null || "http://www.w3.org/2001/XMLSchema".equals(node.getNamespaceURI());
    }
}

