/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.ModelManager;
import oracle.jdevimpl.xml.schema.ProxyNode;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSchemaMetadataResolver
extends XmlMetadataResolver {
    private static final String XDB_NAMESPACE = "http://xmlns.oracle.com/xdb";
    public static final String XDB_METADATA_NAMESPACE = "http://xmlns.oracle.com/xdb/metadata";
    public static final QualifiedName XDB_ATTRIBUTE_USAGE = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/xdb/metadata", (String)"usage");
    private static final String XDB_USAGE_SCHEMA = "schema";
    private static final String XDB_USAGE_ELEMENT = "element";
    private static final String XDB_USAGE_COMPLEXTYPE = "complexType";
    private static final String XDB_USAGE_ATTRIBUTE = "attribute";
    private HashMap xdbAttributeMap;

    private void $init$() {
        this.xdbAttributeMap = new HashMap();
    }

    public XmlSchemaMetadataResolver(MetadataEvaluator evaluator, AbstractModel model) {
        super(evaluator, model);
        this.$init$();
        this.createXdbMappings();
    }

    protected XmlMetadataResolver createResolver(MetadataEvaluator evaluator, AbstractModel model) {
        return new XmlSchemaMetadataResolver(evaluator, model);
    }

    public int getSchemaRole(XmlKey key) {
        QualifiedName qname;
        if (key != null && (qname = key.getElementQName()) != null) {
            return ModelUtils.getSchemaRole(key.getNamespace(), qname.getName());
        }
        return -1;
    }

    public int getSchemaRole(Node node) {
        return node instanceof ReferenceNode ? -1 : this.getSchemaRole(this.getNodeXmlKey(node));
    }

    public int getSchemaRole(QualifiedName qname) {
        return ModelUtils.getSchemaRole(qname.getNamespace(), qname.getName());
    }

    protected String getHelpTopicImpl(Node node, XmlKey key) {
        QualifiedName elementName;
        List elementPath;
        int size;
        String helpTopic = super.getHelpTopicImpl(node, key);
        if (helpTopic == null && key.getNodeType() == 1 && (size = (elementPath = key.getElementQNamePath()).size()) > 0 && "http://www.w3.org/2001/XMLSchema".equals((elementName = (QualifiedName)elementPath.get(size - 1)).getNamespace())) {
            String localName = elementName.getName();
            helpTopic = "f1_xsd" + localName.toLowerCase(Locale.US) + "_html";
        }
        return helpTopic;
    }

    protected List createAttributeKeys(XmlKey elementKey) {
        ArrayList keys = super.createAttributeKeys(elementKey);
        List xdbKeys = this.createXdbAttributeKeys(elementKey);
        if (xdbKeys != null && !xdbKeys.isEmpty()) {
            if (keys.isEmpty()) {
                keys = xdbKeys;
            } else {
                keys = new ArrayList(keys);
                keys.addAll(xdbKeys);
            }
        }
        return keys;
    }

    protected boolean isHiddenImpl(Node node, XmlKey key) {
        if (key.getNodeType() == 2 && "http://www.w3.org/2000/xmlns/".equals(key.getNamespace())) {
            return true;
        }
        return super.isHiddenImpl(node, key);
    }

    public boolean isConvertible(Node nodeToConvert) {
        return false;
    }

    protected boolean isDeletableImpl(XmlKey key, Node node) {
        if (node != null) {
            Document document = node.getOwnerDocument();
            if (document != null && node == document.getDocumentElement()) {
                return false;
            }
            if (node instanceof ProxyNode && ((ProxyNode)node).isExternal()) {
                return false;
            }
        } else if (key.getNodeType() == 1 && "http://www.w3.org/2001/XMLSchema".equals(key.getNamespace()) && XDB_USAGE_SCHEMA.equals(key.getLocalName())) {
            return false;
        }
        return super.isDeletableImpl(key, node);
    }

    protected boolean isImmutableImpl(XmlKey key, Node node) {
        if (node != null && node instanceof ProxyNode && ((ProxyNode)node).isExternal()) {
            return true;
        }
        return super.isImmutableImpl(key, node);
    }

    public boolean isSurroundable(Node[] nodesToSurround) {
        if (nodesToSurround != null) {
            int i = 0;
            while (i < nodesToSurround.length) {
                if (nodesToSurround[i] instanceof ProxyNode && ((ProxyNode)nodesToSurround[i]).isExternal()) {
                    return false;
                }
                ++i;
            }
        }
        return super.isSurroundable(nodesToSurround);
    }

    protected boolean isValidInsertionImpl(Node parent, XmlKey parentKey, Node child, XmlKey childKey, int relativePosition) {
        if (childKey == null && child != null) {
            childKey = this.getNodeXmlKey(child);
        }
        if (parent != null && childKey != null) {
            boolean valid;
            Node target = this.getInsertionTarget(parent, childKey);
            if (target != parent) {
                relativePosition = 0;
            }
            if (valid = super.isValidInsertionImpl(target, this.getNodeXmlKey(target), child, childKey, relativePosition)) {
                valid = this.checkOccuranceConstraints(target, childKey);
                if (valid && this.getSchemaRole(childKey) == 11) {
                    valid = this.checkFacets(target, childKey);
                }
                if (valid && child != null) {
                    valid = this.checkRequiredAttributes(child, parent, childKey);
                }
                return valid;
            }
            return this.canCreateInsertionTarget(target, childKey);
        }
        return super.isValidInsertionImpl(parent, parentKey, child, childKey, relativePosition);
    }

    private boolean checkRequiredAttributes(Node child, Node parent, XmlKey key) {
        if (child.getNodeType() == 1) {
            QualifiedName qname;
            ElementDef parentElement;
            ElementDef childComponent;
            Element element = (Element)child;
            GrammarComponent parentComponent = this.getGrammarComponent(parent);
            if (parentComponent instanceof ElementDef && (childComponent = (parentElement = (ElementDef)parentComponent).getElementDefByName(qname = key.getElementQName())) != null) {
                Collection attributes = childComponent.getAttributeDefs();
                for (AttributeDef attr : attributes) {
                    if (!attr.isRequired() || element.hasAttribute(attr.getName())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isValidInsertionDirect(DomPosition position, XmlKey key) {
        Node container = position.getContainerNode();
        return super.isValidInsertionImpl(container, this.getNodeXmlKey(container), null, key, position.getRelativePosition());
    }

    protected Node getInsertionTarget(Node parent, XmlKey key) {
        Node simpleType;
        Node restriction;
        Node restriction2;
        Attr ref;
        int parentRole = this.getSchemaRole(parent);
        int childRole = this.getSchemaRole(key);
        if ((parentRole == 9 || parentRole == 12 || parentRole == 5) && (ref = ((Element)parent).getAttributeNodeNS(null, "ref")) != null) {
            String value = ref.getValue();
            ModelManager manager = this.getModelManager();
            int type = parentRole == 9 ? 1 : (parentRole == 12 ? 5 : 7);
            GlobalReference reference = new GlobalReference(manager.getNamespace(parent, value), ModelUtils.getName(value), type);
            Node referee = manager.resolveReference(reference);
            if (referee != null) {
                return this.getInsertionTarget(referee, key);
            }
            return parent;
        }
        if (parentRole == 20 && childRole == 11 && (restriction2 = this.getRestrictionWithBase(parent)) != null) {
            return restriction2;
        }
        if ((parentRole == 15 || parentRole == 21) && childRole == 11 && ModelUtils.getSchemaRole(restriction = (simpleType = parent.getParentNode()).getParentNode()) == 16) {
            return restriction;
        }
        if (parentRole == 9 && (childRole == 15 || childRole == 21 || childRole == 11 || ModelUtils.isAttributeRole(childRole) || ModelUtils.isModelGroupRole(childRole))) {
            Element simpleType2 = ModelUtils.getChild(parent, "simpleType");
            if (simpleType2 != null) {
                return this.getInsertionTarget(simpleType2, key);
            }
            Element complexType = ModelUtils.getChild(parent, XDB_USAGE_COMPLEXTYPE);
            if (complexType != null) {
                return this.getInsertionTarget(complexType, key);
            }
        }
        if (parentRole == 8 && (childRole == 15 || childRole == 21 || childRole == 11 || ModelUtils.isAttributeRole(childRole) || ModelUtils.isModelGroupRole(childRole))) {
            Element content = ModelUtils.getChild(parent, "simpleContent");
            if (content != null) {
                Node derivation = this.getRestrictionWithBase(content);
                if (derivation == null) {
                    derivation = ModelUtils.getChild(content, "extension");
                }
                if (derivation != null) {
                    return derivation;
                }
            } else {
                content = ModelUtils.getChild(parent, "complexContent");
                if (content != null) {
                    Element derivation = ModelUtils.getChild(content, "restriction");
                    if (derivation == null) {
                        derivation = ModelUtils.getChild(content, "extension");
                    }
                    if (derivation != null) {
                        return derivation;
                    }
                }
            }
        }
        return parent;
    }

    protected boolean canCreateInsertionTarget(Node parent, XmlKey key) {
        Attr type;
        int parentRole = this.getSchemaRole(parent);
        int childRole = this.getSchemaRole(key);
        if ((parentRole == 15 || parentRole == 21) && childRole == 11) {
            return this.checkFacets(parent, key);
        }
        if (parentRole == 9 && (ModelUtils.isAttributeRole(childRole) || ModelUtils.isModelGroupRole(childRole)) && ModelUtils.getAnonymousType(parent) == null && ((Element)parent).getAttributeNodeNS(null, "ref") == null) {
            Attr type2 = ((Element)parent).getAttributeNodeNS(null, "type");
            if (type2 != null) {
                Node node;
                String value = type2.getValue();
                ModelManager manager = this.getModelManager();
                GlobalReference reference = new GlobalReference(manager.getNamespace(parent, value), ModelUtils.getName(value), 4);
                if (ModelUtils.isModelGroupRole(childRole) ? !reference.isBuiltInType() && (node = this.getModelManager().resolveReference(reference)) != null && !ModelUtils.hasSimpleContent(node) : this.getModelManager().resolveReference(reference) != null || reference.isBuiltInType()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (parentRole == 9 && (childRole == 15 || childRole == 21) && ModelUtils.getAnonymousType(parent) == null && ((Element)parent).getAttributeNodeNS(null, "ref") == null) {
            Attr type3 = ((Element)parent).getAttributeNodeNS(null, "type");
            Node anonymousType = ModelUtils.getAnonymousType(parent);
            if (type3 == null && anonymousType == null) {
                return true;
            }
        }
        if (parentRole == 9 && childRole == 11 && ModelUtils.getAnonymousType(parent) == null && ((Element)parent).getAttributeNodeNS(null, "ref") == null && (type = ((Element)parent).getAttributeNodeNS(null, "type")) != null) {
            String value = type.getValue();
            ModelManager manager = this.getModelManager();
            GlobalReference reference = new GlobalReference(manager.getNamespace(parent, value), ModelUtils.getName(value), 4);
            if (reference.isBuiltInType()) {
                return true;
            }
            Node node = this.getModelManager().resolveReference(reference);
            if (node != null && ModelUtils.hasSimpleContent(node)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkOccuranceConstraints(Node parent, XmlKey key) {
        int parentRole = this.getSchemaRole(parent);
        int childRole = this.getSchemaRole(key);
        if (childRole == 1 && parentRole != 17 && ModelUtils.getChild(parent, "annotation") != null) {
            return false;
        }
        if (parentRole == 20 && (ModelUtils.isContainerRole(childRole) || childRole == 15 || childRole == 21)) {
            Element child = ModelUtils.getChild(parent, "restriction");
            if (child != null) {
                return false;
            }
            child = ModelUtils.getChild(parent, "list");
            if (child != null) {
                return false;
            }
            child = ModelUtils.getChild(parent, "union");
            if (child != null) {
                return false;
            }
        }
        if (parentRole == 15 && childRole == 20) {
            Element simpleType = ModelUtils.getChild(parent, "simpleType");
            if (simpleType != null) {
                return false;
            }
            Attr attr = ((Element)parent).getAttributeNodeNS(null, "itemType");
            if (attr != null) {
                return false;
            }
        }
        if (childRole == 3 && ModelUtils.getChild(parent, "anyAttribute") != null) {
            return false;
        }
        if (parentRole == 8 && (childRole == 7 || childRole == 19 || ModelUtils.isModelGroupRole(childRole))) {
            NodeList children = parent.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                int role = this.getSchemaRole(children.item(i));
                if (role == 7 || role == 19 || ModelUtils.isModelGroupRole(role)) {
                    return false;
                }
                ++i;
            }
        }
        if ((parentRole == 12 || parentRole == 10 || parentRole == 16) && ModelUtils.isModelGroupRole(childRole)) {
            NodeList children = parent.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (ModelUtils.isModelGroupRole(this.getSchemaRole(children.item(i)))) {
                    return false;
                }
                ++i;
            }
        }
        if (parentRole == 16 && childRole == 20) {
            Element simpleType = ModelUtils.getChild(parent, "simpleType");
            if (simpleType != null) {
                return false;
            }
            Attr attr = ((Element)parent).getAttributeNodeNS(null, "base");
            if (attr != null) {
                return false;
            }
        }
        if (!(parentRole != 19 && parentRole != 7 || childRole != 10 && childRole != 16 || ModelUtils.getChild(parent, "extension") == null && ModelUtils.getChild(parent, "restriction") == null)) {
            return false;
        }
        if (parentRole == 9 && (childRole == 20 || childRole == 8)) {
            Attr attr = ((Element)parent).getAttributeNodeNS(null, "type");
            if (attr != null) {
                return false;
            }
            if (ModelUtils.getChild(parent, "simpleType") != null || ModelUtils.getChild(parent, XDB_USAGE_COMPLEXTYPE) != null) {
                return false;
            }
        }
        return true;
    }

    public boolean checkFacets(Node parent, XmlKey key) {
        Element simpleType;
        Attr base;
        boolean isUnion;
        int parentRole = this.getSchemaRole(parent);
        String facet = key.getLocalName();
        boolean isList = parentRole == 15;
        boolean bl = isUnion = parentRole == 21;
        if (parentRole == 16 && (base = ((Element)parent).getAttributeNodeNS(null, "base")) == null && (simpleType = ModelUtils.getChild(parent, "simpleType")) != null) {
            if (ModelUtils.getChild(simpleType, "list") != null) {
                isList = true;
            } else if (ModelUtils.getChild(simpleType, "union") != null) {
                isUnion = true;
            }
        }
        if (isList) {
            return "length".equals(facet) || "maxLength".equals(facet) || "minLength".equals(facet) || "enumeration".equals(facet) || "pattern".equals(facet) || "whiteSpace".equals(facet);
        }
        if (isUnion) {
            return "enumeration".equals(facet) || "pattern".equals(facet);
        }
        return true;
    }

    public Collection getPotentialInsertionPositions(DomPosition position) {
        Node target = position.getTargetNode();
        if (target instanceof ProxyNode && ((ProxyNode)target).isExternal()) {
            return Collections.EMPTY_LIST;
        }
        return super.getPotentialInsertionPositions(position);
    }

    protected Collection getCreateableChildrenXmlKeysImpl(DomPosition position, XmlKey parentKey) {
        Collection baseList = super.getCreateableChildrenXmlKeysImpl(position, parentKey);
        ArrayList createableKeys = new ArrayList(baseList.size() + 10);
        createableKeys.addAll(baseList);
        int role = this.getSchemaRole(parentKey);
        switch (role) {
            case 9: {
                this.addKey(createableKeys, parentKey, "all");
                this.addKey(createableKeys, parentKey, "choice");
                this.addKey(createableKeys, parentKey, "sequence");
                this.addKey(createableKeys, parentKey, "group");
                this.addKey(createableKeys, parentKey, XDB_USAGE_ATTRIBUTE);
                this.addKey(createableKeys, parentKey, "attributeGroup");
                this.addKey(createableKeys, parentKey, "anyAttribute");
                this.addKey(createableKeys, parentKey, "list");
                this.addKey(createableKeys, parentKey, "union");
                this.addKey(createableKeys, parentKey, "enumeration");
                this.addKey(createableKeys, parentKey, "fractionDigits");
                this.addKey(createableKeys, parentKey, "length");
                this.addKey(createableKeys, parentKey, "maxExclusive");
                this.addKey(createableKeys, parentKey, "maxInclusive");
                this.addKey(createableKeys, parentKey, "maxLength");
                this.addKey(createableKeys, parentKey, "minExclusive");
                this.addKey(createableKeys, parentKey, "minInclusive");
                this.addKey(createableKeys, parentKey, "minLength");
                this.addKey(createableKeys, parentKey, "pattern");
                this.addKey(createableKeys, parentKey, "totalDigits");
                this.addKey(createableKeys, parentKey, "whiteSpace");
                break;
            }
            case 15: {
                this.addKey(createableKeys, parentKey, "length");
                this.addKey(createableKeys, parentKey, "maxLength");
                this.addKey(createableKeys, parentKey, "minLength");
                this.addKey(createableKeys, parentKey, "enumeration");
                this.addKey(createableKeys, parentKey, "pattern");
                this.addKey(createableKeys, parentKey, "whiteSpace");
                break;
            }
            case 21: {
                this.addKey(createableKeys, parentKey, "enumeration");
                this.addKey(createableKeys, parentKey, "pattern");
                break;
            }
            case 8: {
                this.addKey(createableKeys, parentKey, "list");
                this.addKey(createableKeys, parentKey, "union");
                this.addKey(createableKeys, parentKey, "enumeration");
                this.addKey(createableKeys, parentKey, "fractionDigits");
                this.addKey(createableKeys, parentKey, "length");
                this.addKey(createableKeys, parentKey, "maxExclusive");
                this.addKey(createableKeys, parentKey, "maxInclusive");
                this.addKey(createableKeys, parentKey, "maxLength");
                this.addKey(createableKeys, parentKey, "minExclusive");
                this.addKey(createableKeys, parentKey, "minInclusive");
                this.addKey(createableKeys, parentKey, "minLength");
                this.addKey(createableKeys, parentKey, "pattern");
                this.addKey(createableKeys, parentKey, "totalDigits");
                this.addKey(createableKeys, parentKey, "whiteSpace");
                break;
            }
            case 20: {
                this.addKey(createableKeys, parentKey, "enumeration");
                this.addKey(createableKeys, parentKey, "fractionDigits");
                this.addKey(createableKeys, parentKey, "length");
                this.addKey(createableKeys, parentKey, "maxExclusive");
                this.addKey(createableKeys, parentKey, "maxInclusive");
                this.addKey(createableKeys, parentKey, "maxLength");
                this.addKey(createableKeys, parentKey, "minExclusive");
                this.addKey(createableKeys, parentKey, "minInclusive");
                this.addKey(createableKeys, parentKey, "minLength");
                this.addKey(createableKeys, parentKey, "pattern");
                this.addKey(createableKeys, parentKey, "totalDigits");
                this.addKey(createableKeys, parentKey, "whiteSpace");
                break;
            }
        }
        if (position != null) {
            int i = createableKeys.size() - 1;
            while (i >= 0) {
                boolean allowed = this.isValidInsertion(position, Collections.singletonList((XmlKey)createableKeys.get(i)));
                if (!allowed) {
                    createableKeys.remove(i);
                }
                --i;
            }
        }
        createableKeys.trimToSize();
        return createableKeys;
    }

    public boolean isValidInsertion(DomPosition insertionPosition, List potentialChildren) {
        if (!insertionPosition.isInside()) {
            Node target = insertionPosition.getTargetNode();
            for (XmlKey key : potentialChildren) {
                if (this.isValidInsertion(insertionPosition, target, key)) continue;
                return false;
            }
        }
        return super.isValidInsertion(insertionPosition, potentialChildren);
    }

    public boolean isValidInsertion(DomPosition insertionPosition, NodeList potentialChildren) {
        if (!insertionPosition.isInside()) {
            Node target = insertionPosition.getTargetNode();
            int length = potentialChildren.getLength();
            int i = 0;
            while (i < length) {
                XmlKey key = this.getNodeXmlKey(potentialChildren.item(i));
                if (!this.isValidInsertion(insertionPosition, target, key)) {
                    return false;
                }
                ++i;
            }
        }
        return super.isValidInsertion(insertionPosition, potentialChildren);
    }

    public XmlKey getXmlKeyForInsertion(XmlKey parentKey, QualifiedName qname) {
        ArrayList<QualifiedName> path = new ArrayList<QualifiedName>();
        int parentRole = this.getSchemaRole(parentKey);
        int childRole = this.getSchemaRole(qname);
        if (parentRole == 9) {
            if (ModelUtils.isAttributeRole(childRole) || ModelUtils.isModelGroupRole(childRole)) {
                path.add(QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)XDB_USAGE_COMPLEXTYPE));
            } else if (childRole == 15 || childRole == 21 || childRole == 11) {
                path.add(QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)"simpleType"));
            }
        } else if ((parentRole == 15 || parentRole == 21) && childRole == 11) {
            path.add(QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)"simpleType"));
            path.add(QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)"restriction"));
        }
        path.add(qname);
        GrammarResolver resolver = this.getContext().getGrammarResolver();
        return DerivedXmlKey.createElementKey((GrammarResolver)resolver, (XmlKey)parentKey, path).intern();
    }

    protected String getPropertyDisplayNameImpl(Node node, XmlKey key, Node ownerNode, XmlKey ownerKey) {
        String namespace;
        if (key.getNodeType() == 2 && (namespace = key.getNamespace()) != null && XDB_NAMESPACE.equals(namespace)) {
            return this.getShortDisplayNameImpl(node, key);
        }
        return super.getPropertyDisplayNameImpl(node, key, ownerNode, ownerKey);
    }

    private boolean isValidInsertion(DomPosition insertionPosition, Node target, XmlKey childKey) {
        boolean isValid = true;
        if (insertionPosition.isBefore() || insertionPosition.isAfter()) {
            Node container = insertionPosition.getContainerNode();
            int childRole = this.getSchemaRole(childKey);
            int containerRole = this.getSchemaRole(container);
            HashSet<Integer> allowedBefore = new HashSet<Integer>();
            HashSet allowedAfter = new HashSet();
            HashSet<Integer> prohibitedBefore = new HashSet<Integer>();
            HashSet<Integer> prohibitedAfter = new HashSet<Integer>();
            if (containerRole == 17) {
                if (childRole == 14) {
                    allowedBefore.add(new Integer(14));
                    allowedBefore.add(new Integer(1));
                    allowedBefore.add(new Integer(-1));
                } else if (childRole != 1 && childRole != -1) {
                    prohibitedAfter.add(new Integer(14));
                }
            }
            if (containerRole != 17 && containerRole != 14) {
                if (childRole == 1) {
                    allowedBefore.add(new Integer(1));
                    allowedBefore.add(new Integer(-1));
                } else if (childRole != -1) {
                    prohibitedAfter.add(new Integer(1));
                }
            }
            if (containerRole != 17) {
                if (ModelUtils.isAttributeRole(childRole)) {
                    prohibitedAfter.add(new Integer(7));
                    prohibitedAfter.add(new Integer(19));
                    prohibitedAfter.add(new Integer(0));
                    prohibitedAfter.add(new Integer(6));
                    prohibitedAfter.add(new Integer(12));
                    prohibitedAfter.add(new Integer(18));
                } else if (ModelUtils.isModelGroupRole(childRole) || childRole == 7 || childRole == 19) {
                    prohibitedBefore.add(new Integer(4));
                    prohibitedBefore.add(new Integer(3));
                    prohibitedBefore.add(new Integer(5));
                }
            }
            if (!allowedBefore.isEmpty() || !prohibitedBefore.isEmpty()) {
                Node node = insertionPosition.isAfter() ? target : target.getPreviousSibling();
                while (isValid && node != null) {
                    Integer role = new Integer(this.getSchemaRole(node));
                    if (!allowedBefore.isEmpty() && !allowedBefore.contains(role) || prohibitedBefore.contains(role)) {
                        isValid = false;
                    }
                    node = node.getPreviousSibling();
                }
            }
            if (!(!isValid || allowedAfter.isEmpty() && prohibitedAfter.isEmpty())) {
                Node node = insertionPosition.isBefore() ? target : target.getNextSibling();
                while (isValid && node != null) {
                    Integer role = new Integer(this.getSchemaRole(node));
                    if (!allowedAfter.isEmpty() && !allowedAfter.contains(role) || prohibitedAfter.contains(role)) {
                        isValid = false;
                    }
                    node = node.getNextSibling();
                }
            }
        }
        return isValid;
    }

    private Node getRestrictionWithBase(Node node) {
        int role = this.getSchemaRole(node);
        Element restriction = null;
        restriction = role == 16 ? (Element)node : ModelUtils.getChild(node, "restriction");
        while (restriction != null) {
            if (restriction.getAttributeNodeNS(null, "base") != null) break;
            Element simpleType = ModelUtils.getChild(restriction, "simpleType");
            if (simpleType != null) {
                if (ModelUtils.getChild(simpleType, "list") != null || ModelUtils.getChild(simpleType, "union") != null) break;
                restriction = ModelUtils.getChild(simpleType, "restriction");
                continue;
            }
            restriction = null;
        }
        return restriction;
    }

    private ModelManager getModelManager() {
        return ((XmlSchemaModel)this.getModel()).getModelManager();
    }

    private void addKey(List list, XmlKey parentKey, String name) {
        QualifiedName qname = QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)name);
        list.add(this.getXmlKeyForInsertion(parentKey, qname));
    }

    private List createXdbAttributeKeys(XmlKey elementKey) {
        List path = elementKey.getElementQNamePath();
        if (path.size() > 0) {
            QualifiedName qname = (QualifiedName)path.get(path.size() - 1);
            return (List)this.xdbAttributeMap.get(qname);
        }
        return null;
    }

    private void createXdbMappings() {
        GrammarProvider provider = this.getContext().getGrammarProvider();
        Grammar grammar = provider.getGrammarForNamespace(XDB_NAMESPACE);
        if (grammar != null) {
            ArrayList<XmlKey> schemaAttributes = new ArrayList<XmlKey>();
            ArrayList<XmlKey> elementAttributes = new ArrayList<XmlKey>();
            ArrayList<XmlKey> complexTypeAttributes = new ArrayList<XmlKey>();
            ArrayList<XmlKey> attributeAttributes = new ArrayList<XmlKey>();
            for (AttributeDef attribute : grammar.getAttributeDefs()) {
                XmlKey key = ImmutableXmlKey.createAttributeKey((QualifiedName)attribute.getQualifiedName());
                String usage = (String)this.getMetadataEvaluator().getMetadataItem((Object)key, (Object)XDB_ATTRIBUTE_USAGE, null);
                if (usage == null) continue;
                String[] usages = usage.split(" ");
                int i = 0;
                while (i < usages.length) {
                    if (XDB_USAGE_SCHEMA.equals(usages[i])) {
                        schemaAttributes.add(key);
                    } else if (XDB_USAGE_ELEMENT.equals(usages[i])) {
                        elementAttributes.add(key);
                    } else if (XDB_USAGE_COMPLEXTYPE.equals(usages[i])) {
                        complexTypeAttributes.add(key);
                    } else if (XDB_USAGE_ATTRIBUTE.equals(usages[i])) {
                        attributeAttributes.add(key);
                    }
                    ++i;
                }
            }
            schemaAttributes.trimToSize();
            elementAttributes.trimToSize();
            complexTypeAttributes.trimToSize();
            attributeAttributes.trimToSize();
            this.addXdbMapping(XDB_USAGE_SCHEMA, schemaAttributes);
            this.addXdbMapping(XDB_USAGE_ELEMENT, elementAttributes);
            this.addXdbMapping(XDB_USAGE_COMPLEXTYPE, complexTypeAttributes);
            this.addXdbMapping(XDB_USAGE_ATTRIBUTE, attributeAttributes);
        }
    }

    private void addXdbMapping(String name, List attributes) {
        QualifiedName qname = QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)name);
        this.xdbAttributeMap.put(qname, attributes);
    }
}

