/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.MetadataRegistry;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataEvaluator;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.datatransfer.operation.OperationFactory;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.javatools.datatransfer.DataTransferPluginFactory;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.ModelManager;
import oracle.jdevimpl.xml.schema.XmlSchemaDataTransferPluginFactory;
import oracle.jdevimpl.xml.schema.XmlSchemaMetadataResolver;
import oracle.jdevimpl.xml.schema.XmlSchemaOperationFactory;
import oracle.jdevimpl.xml.schema.XmlSchemaTreeTraversal;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.property.ModelWalker;
import oracle.jdevimpl.xml.schema.property.SchemaNameMapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlSchemaModel
extends XmlModel {
    private ModelManager modelManager;
    private XmlSchemaTreeTraversal schemaTraversal;
    private ModelWalker _schemaWalker;

    private void $init$() {
        this._schemaWalker = new ModelWalker(new SchemaNameMapper());
    }

    public static ModelWalker getSchemaWalker(XmlContext ctx) {
        return ((XmlSchemaModel)ctx.getModel())._schemaWalker;
    }

    public static ModelWalker getSchemaWalker(XmlModel model) {
        return ((XmlSchemaModel)model)._schemaWalker;
    }

    public XmlSchemaModel() {
        super(MetadataRegistry.getInstance().getMetadataProvider("xml schema metadata"));
        this.$init$();
    }

    public XmlSchemaModel(MetadataProvider provider) {
        super(provider);
        this.$init$();
    }

    public XmlSchemaTreeTraversal getSchemaTraversal() {
        return this.schemaTraversal;
    }

    public ModelWalker getSchemaWalker() {
        return this._schemaWalker;
    }

    protected void contextAttached() {
        super.contextAttached();
        this.modelManager = new ModelManager(this);
        this.schemaTraversal = new XmlSchemaTreeTraversal(this);
        this.getContext().getDataTransferPluginRegistry().registerFactory((DataTransferPluginFactory)new XmlSchemaDataTransferPluginFactory());
        this.getContext().getOperationManager().registerOperationFactory((OperationFactory)new XmlSchemaOperationFactory());
    }

    public Node resolveReference(GlobalReference reference) {
        return this.modelManager.resolveReference(reference);
    }

    public String getNamespace(Node referringNode, String qname) {
        return this.modelManager.getNamespace(referringNode, qname);
    }

    public List getGlobals(Node referringNode, int type) {
        return this.modelManager.getGlobals(referringNode, type);
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    protected XmlMetadataResolver createMetadataResolver(MetadataProvider provider) {
        XmlContext context = this.getContext();
        XmlMetadataEvaluator evaluator = new XmlMetadataEvaluator(provider, context.getGrammarProvider(), context.getGrammarResolver(), (AbstractModel)this);
        return new XmlSchemaMetadataResolver((MetadataEvaluator)evaluator, (AbstractModel)this);
    }

    public DomPosition findValidInsertionPosition(XmlKey keyToInsert, Node nodeToInsert, DomPosition requestedPosition, XmlKey containerKey) {
        if (keyToInsert == null) {
            keyToInsert = this.getNodeXmlKey(nodeToInsert);
        }
        return this.getImportLocation(keyToInsert, requestedPosition);
    }

    private DomPosition getImportLocation(XmlKey key, DomPosition location) {
        boolean valid;
        DomPosition importLocation = location;
        Node container = location.getContainerNode();
        XmlSchemaMetadataResolver resolver = this.getXmlSchemaMetadataResolver();
        Node target = resolver.getInsertionTarget(container, key);
        if (target != container) {
            importLocation = DomPositionFactory.createDomPosition((Node)target, (int)0);
        }
        if (!(valid = resolver.isValidInsertionDirect(importLocation, key)) && (target = this.createImportLocation(target, key)) != null) {
            importLocation = DomPositionFactory.createDomPosition((Node)target, (int)0);
        }
        if (importLocation.getRelativePosition() == 0) {
            importLocation = this.ensureCorrectOrdering(importLocation, key);
        }
        return importLocation;
    }

    private DomPosition ensureCorrectOrdering(DomPosition location, XmlKey key) {
        DomPosition correctLocation = location;
        XmlSchemaMetadataResolver resolver = this.getXmlSchemaMetadataResolver();
        Node parent = location.getContainerNode();
        int parentRole = resolver.getSchemaRole(parent);
        int childRole = resolver.getSchemaRole(key);
        if (childRole == 1) {
            correctLocation = ModelUtils.getAnnotationInsertionPosition(parent);
        } else if (childRole == 14) {
            Node child = parent.getFirstChild();
            while (child != null) {
                int role = resolver.getSchemaRole(child);
                if (role != 1 && role != 14 && role != -1) break;
                child = child.getNextSibling();
            }
            if (child != null) {
                correctLocation = DomPositionFactory.createDomPosition((Node)child, (int)1);
            }
        } else if (parentRole != 17 && (ModelUtils.isModelGroupRole(childRole) || ModelUtils.isContainerRole(childRole))) {
            Node child = parent.getFirstChild();
            while (child != null && !ModelUtils.isAttributeRole(resolver.getSchemaRole(child))) {
                child = child.getNextSibling();
            }
            if (child != null) {
                correctLocation = DomPositionFactory.createDomPosition((Node)child, (int)1);
            }
        }
        return correctLocation;
    }

    private Node createImportLocation(Node target, XmlKey key) {
        Attr type;
        XmlSchemaMetadataResolver resolver = this.getXmlSchemaMetadataResolver();
        int parentRole = resolver.getSchemaRole(target);
        int childRole = resolver.getSchemaRole(key);
        if ((parentRole == 15 || parentRole == 21) && childRole == 11) {
            return this.createListOrUnionRestriction(target);
        }
        if (parentRole == 9 && (ModelUtils.isAttributeRole(childRole) || ModelUtils.isModelGroupRole(childRole))) {
            return ModelUtils.createAnonymousComplexTypeWithExtension(this, (Element)target);
        }
        if (parentRole == 9 && (childRole == 15 || childRole == 21)) {
            return ModelUtils.createAnonymousSimpleType(this, (Element)target);
        }
        if (parentRole == 9 && childRole == 11 && (type = ((Element)target).getAttributeNodeNS(null, "type")) != null) {
            if (ModelUtils.isSimpleType(this, target, type.getValue())) {
                return ModelUtils.createAnonymousSimpleType(this, (Element)target);
            }
            return ModelUtils.createAnonymousComplexTypeWithRestriction(this, (Element)target);
        }
        return null;
    }

    private Node createListOrUnionRestriction(Node target) {
        Node simpleType = target.getParentNode();
        Document document = target.getOwnerDocument();
        DefaultPrefixLookup prefixLookup = this.getDefaultPrefixLookup();
        Element restriction = document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
        NamespaceUtils.fixPrefixes((Node)simpleType, (Node)restriction, (DefaultPrefixLookup)prefixLookup);
        simpleType.appendChild(restriction);
        Element newSimpleType = document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        NamespaceUtils.fixPrefixes((Node)restriction, (Node)newSimpleType, (DefaultPrefixLookup)prefixLookup);
        restriction.appendChild(newSimpleType);
        simpleType.removeChild(target);
        NamespaceUtils.fixPrefixes((Node)newSimpleType, (Node)target, (DefaultPrefixLookup)prefixLookup);
        newSimpleType.appendChild(target);
        return restriction;
    }

    private XmlSchemaMetadataResolver getXmlSchemaMetadataResolver() {
        return (XmlSchemaMetadataResolver)this.getXmlMetadataResolver();
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
        super.handleModelChangeEvent(event);
        if (!(event.isSelectionChanged() || event.isSelectionCleared() || event.isSelectionOrRangeSelectionChanged())) {
            this._schemaWalker.clearCache();
        }
    }
}

