/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.FilteredTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.ModelManager;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaMetadataResolver;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import org.w3c.dom.Node;

public class XmlSchemaTreeTraversal
extends FilteredTreeTraversal {
    private XmlSchemaMetadataResolver resolver;
    private ModelManager manager;
    private TreeTraversal beforeTraversal;

    public XmlSchemaTreeTraversal(XmlSchemaModel model) {
        this.manager = model.getModelManager();
        this.resolver = (XmlSchemaMetadataResolver)model.getXmlMetadataResolver();
    }

    protected short acceptNode(Node node) {
        int role = this.resolver.getSchemaRole(node);
        switch (role) {
            case 7: 
            case 10: 
            case 16: 
            case 19: {
                return 3;
            }
            case 20: {
                int parentRole;
                if (ModelUtils.getName(node) != null) {
                    return 1;
                }
                Node parent = node.getParentNode();
                if (parent != null && ((parentRole = this.resolver.getSchemaRole(parent)) == 15 || parentRole == 21)) {
                    return 1;
                }
                return 3;
            }
            case 8: {
                if (ModelUtils.getName(node) != null) {
                    return 1;
                }
                return 3;
            }
        }
        return 1;
    }

    protected TreeTraversal getBeforeTraversal() {
        if (this.beforeTraversal == null) {
            this.beforeTraversal = new InsertingTraversal(null);
        }
        return this.beforeTraversal;
    }

    static ModelManager ra$manager(XmlSchemaTreeTraversal xmlSchemaTreeTraversal) {
        return xmlSchemaTreeTraversal.manager;
    }

    private class InsertingTraversal
    extends TreeTraversal {
        public Node getParentNode(Node node) {
            return DocumentTreeTraversal.INSTANCE.getParentNode(node);
        }

        public Node getFirstChild(Node node) {
            GlobalReference reference;
            if (!(node instanceof ReferenceNode) && (reference = XmlSchemaTreeTraversal.ra$manager(XmlSchemaTreeTraversal.this).getReference(node)) != null) {
                return new ReferenceNode(XmlSchemaTreeTraversal.ra$manager(XmlSchemaTreeTraversal.this), node, reference);
            }
            return DocumentTreeTraversal.INSTANCE.getFirstChild(node);
        }

        public Node getLastChild(Node node) {
            return DocumentTreeTraversal.INSTANCE.getLastChild(node);
        }

        public Node getNextSibling(Node node) {
            if (node instanceof ReferenceNode) {
                return node.getParentNode().getFirstChild();
            }
            return DocumentTreeTraversal.INSTANCE.getNextSibling(node);
        }

        public Node getPreviousSibling(Node node) {
            return DocumentTreeTraversal.INSTANCE.getPreviousSibling(node);
        }

        private InsertingTraversal() {
        }

        InsertingTraversal(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

