/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.ide.Ide;
import oracle.jdevimpl.xml.schema.ProxyAttr;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.EditableTextComponent;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AttrEditor
extends EditableTextComponent {
    private Attr attr;
    private boolean editing;

    public AttrEditor(Diagram diagram) {
        this(diagram, null);
    }

    public AttrEditor(Diagram diagram, Attr attr) {
        super(diagram);
        this.setAttr(attr);
    }

    public void setAttr(Attr attr) {
        this.attr = attr;
        if (attr != null) {
            this.setText(attr.getValue());
        }
    }

    protected void startEditing() {
        if (!(this.editing || this.attr instanceof ProxyAttr && ((ProxyAttr)this.attr).isExternal())) {
            if (!this.diagram.getSelectionManager().isSelected(this)) {
                DiagramComponent parent = this.getParent();
                while (parent != null) {
                    if (parent instanceof DiagramSchemaComponent) break;
                    parent = parent.getParent();
                }
                if (parent != null) {
                    this.diagram.getSelectionManager().select((DiagramSchemaComponent)parent);
                }
                this.diagram.scrollToVisible(parent != null ? parent : this);
            }
            super.startEditing();
            this.editing = true;
        }
    }

    protected void stopEditing() {
        super.stopEditing();
        if (this.editing) {
            this.editing = false;
            String value = this.text;
            if (this.attr != null && !value.equals(this.attr.getValue())) {
                if (this.validate(value)) {
                    this.commit(value);
                } else {
                    this.cancelEditing();
                }
            }
        }
    }

    protected void cancelEditing() {
        this.editing = false;
        super.cancelEditing();
        if (this.attr != null) {
            this.setText(this.attr.getValue());
            this.invalidate();
            this.diagram.revalidate();
            this.fireTextChanged();
        }
    }

    private boolean validate(String value) {
        XmlView view = this.diagram.getGui().getView();
        XmlMetadataResolver resolver = view.getXmlMetadataResolver();
        Node modelNode = view.viewToModel((Node)this.attr.getOwnerElement());
        XmlKey key = view.getNodeXmlKey((Node)this.attr);
        try {
            resolver.validateValue(key, modelNode, (Object)value);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.showError(key, this.text, e);
            SwingUtilities.invokeLater(new 1());
            return false;
        }
    }

    private void commit(String value) {
        XmlModel model = this.diagram.getGui().getView().getBaseModel();
        model.startTransaction(XmlSchemaArb.getString(22));
        try {
            if (value.trim().length() == 0) {
                this.attr.getOwnerElement().removeAttributeNode(this.attr);
            } else {
                this.attr.setNodeValue(value);
            }
            model.commitTransaction();
        }
        catch (ThreadDeath th) {
            model.rollbackTransaction();
            throw th;
        }
        catch (Throwable t) {
            model.rollbackTransaction();
        }
    }

    private void showError(XmlKey key, String value, Throwable t) {
        String error = t.getLocalizedMessage();
        if (error == null && (error = t.getMessage()) == null) {
            error = t.toString();
        }
        MessageFormat titleFormat = new MessageFormat(XmlSchemaArb.getString(32));
        String keyName = key.getLocalName();
        String title = titleFormat.format(new Object[]{keyName});
        MessageFormat messageFormat = new MessageFormat(XmlSchemaArb.getString(12));
        String valueString = String.valueOf(value.trim().length() > 0 ? value : null);
        String message = messageFormat.format(new Object[]{keyName, valueString, error});
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, title, 0);
    }

    final class 1
    implements Runnable {
        public void run() {
            AttrEditor.this.startEditing();
        }
    }
}

