/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Insets;
import oracle.jdevimpl.xml.schema.diagram.AttrEditor;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.Row;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import org.w3c.dom.Attr;

public class AttrRow
implements Row {
    private boolean showName;
    private TextComponent label;
    private AttrEditor editor;

    public AttrRow(Diagram diagram, Attr attr, boolean showName) {
        this.showName = showName;
        if (showName) {
            this.label = new TextComponent(diagram);
        }
        this.editor = new AttrEditor(diagram, attr);
        this.editor.setInsets(new Insets(2, 3, 2, 3));
        this.setAttr(attr);
    }

    public void setAttr(Attr attr) {
        if (this.showName) {
            this.label.setText(attr.getName());
            this.label.setInsets(new Insets(2, 3, 2, 3));
        }
        this.editor.setAttr(attr);
    }

    public int getRowHeight() {
        if (this.showName) {
            return Math.max(this.label.getPreferredHeight(), this.editor.getPreferredHeight());
        }
        return this.editor.getPreferredHeight();
    }

    public int getColumnCount() {
        return this.label != null ? 2 : 1;
    }

    public DiagramComponent getColumn(int column) {
        if (this.label != null && column == 0) {
            return this.label;
        }
        return this.editor;
    }
}

