/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.NodeListener;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.diagram.AttributeDeclaration;
import oracle.jdevimpl.xml.schema.diagram.AttributeGroup;
import oracle.jdevimpl.xml.schema.diagram.ComponentFactory;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeContainer
extends DiagramComponent
implements NodeListener {
    private Element element;
    private ArrayList attributeGroups;

    private void $init$() {
        this.attributeGroups = new ArrayList();
    }

    public AttributeContainer(Diagram diagram, Element element) {
        super(diagram);
        this.$init$();
        this.element = element;
        diagram.getView().addNodeListener(element, this);
        this.update();
    }

    public void nodeChanged(Node node) {
        this.update();
    }

    public void update() {
        if (this.element != null) {
            this.destroyAll();
            this.diagram.getView().acquireReadLock();
            try {
                this.addAttributes();
            }
            finally {
                this.diagram.getView().releaseReadLock();
            }
            this.invalidate();
        }
    }

    public void destroy() {
        this.diagram.getView().removeNodeListener(this.element, this);
        this.element = null;
        this.destroyAll();
        super.destroy();
    }

    public int getPreferredWidth() {
        if (this.numChildren > 0) {
            int width = 0;
            int i = 0;
            while (i < this.numChildren) {
                width = Math.max(width, this.children[i].getPreferredWidth());
                ++i;
            }
            return width + this.insets.left + this.insets.right;
        }
        return 0;
    }

    public int getPreferredHeight() {
        if (this.numChildren > 0) {
            int height = this.insets.top + this.insets.bottom;
            if (this.children != null) {
                int i = 0;
                while (i < this.numChildren) {
                    height += this.children[i].getPreferredHeight();
                    if (i > 0 && this.children[i] instanceof AttributeGroup && !(this.children[i - 1] instanceof AttributeGroup)) {
                        ++height;
                    }
                    if (i < this.numChildren - 1 && this.children[i] instanceof AttributeGroup) {
                        ++height;
                    }
                    ++i;
                }
            }
            return height;
        }
        return 0;
    }

    public void layout() {
        if (this.children != null) {
            int y = this.insets.top;
            int i = 0;
            while (i < this.numChildren) {
                if (i > 0 && this.children[i] instanceof AttributeGroup && !(this.children[i - 1] instanceof AttributeGroup)) {
                    ++y;
                }
                this.children[i].setBounds(this.insets.left, y, this.width - this.insets.left - this.insets.right, this.children[i].getPreferredHeight());
                y += this.children[i].getHeight();
                if (i < this.numChildren - 1 && this.children[i] instanceof AttributeGroup) {
                    ++y;
                }
                ++i;
            }
        }
    }

    public DomPosition getDomPosition(Point p) {
        DomPosition pos = null;
        Rectangle bounds = new Rectangle();
        int i = 0;
        while (pos == null && i < this.numChildren) {
            if ((bounds = this.children[i].getBounds(bounds)).contains(p) && this.children[i] instanceof AttributeGroup) {
                p.translate(-this.children[i].x, -this.children[i].y);
                pos = this.children[i].getDomPosition(p);
                p.translate(this.children[i].x, this.children[i].y);
            } else if (p.getY() < bounds.getY() + bounds.getHeight() / 2.0) {
                if (!(this.children[i] instanceof AttributeDeclaration) || !((AttributeDeclaration)this.children[i]).isInherited()) {
                    pos = DomPositionFactory.createDomPosition((Node)((DiagramSchemaComponent)this.children[i]).getDomElement(), (int)1);
                }
            } else if (!(!(p.getY() < bounds.getY() + bounds.getHeight()) || this.children[i] instanceof AttributeDeclaration && ((AttributeDeclaration)this.children[i]).isInherited())) {
                pos = DomPositionFactory.createDomPosition((Node)((DiagramSchemaComponent)this.children[i]).getDomElement(), (int)2);
            }
            ++i;
        }
        return pos;
    }

    public Shape getDomPositionShape(DiagramComponent component, int relativePosition) {
        Shape shape = null;
        if (relativePosition == 1) {
            Rectangle bounds = component.getBounds(null);
            return new Line2D.Double(bounds.getX(), bounds.getY(), bounds.getX() + bounds.getWidth(), bounds.getY());
        }
        if (relativePosition == 2) {
            Rectangle bounds = component.getBounds(null);
            return new Line2D.Double(bounds.getX(), bounds.getY() + bounds.getHeight(), bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
        }
        shape = super.getDomPositionShape(component, relativePosition);
        return shape;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        g.setColor(Color.BLACK);
        int i = 0;
        while (i < this.numChildren) {
            if (i > 0 && this.children[i] instanceof AttributeGroup && !(this.children[i - 1] instanceof AttributeGroup)) {
                int y = this.children[i].getY() - 1;
                g.drawLine(this.insets.left, y, this.width - this.insets.right, y);
            }
            if (i < this.numChildren - 1 && this.children[i] instanceof AttributeGroup) {
                int y = this.children[i].getY() + this.children[i].getHeight();
                g.drawLine(this.insets.left, y, this.width - this.insets.right, y);
            }
            ++i;
        }
        g.setColor(oldColor);
    }

    private void addAttributes() {
        ArrayList referenceChildren = new ArrayList();
        ArrayList<Node> directChildren = new ArrayList<Node>();
        boolean override = false;
        TreeTraversal traversal = this.diagram.getView().getTreeTraversal();
        Node child = traversal.getFirstChild((Node)this.element);
        while (child != null) {
            if (child instanceof ReferenceNode) {
                ReferenceNode refNode = (ReferenceNode)((Object)child);
                GlobalReference reference = refNode.getReference();
                int type = reference.getReferenceType();
                Node referee = refNode.getReferee();
                if (type == 2) {
                    override = true;
                }
                if (!refNode.isCyclicReference()) {
                    if (type == 1 && reference.getType() == 7) {
                        this.diagram.getView().addNodeListener(child, this);
                        this.attributeGroups.add(child);
                        this.getAttributes(referee, directChildren);
                    } else {
                        this.getAttributes(referee, referenceChildren);
                    }
                }
            } else if (ModelUtils.isAttributeRole(ModelUtils.getSchemaRole(child))) {
                if (override) {
                    this.overrideAttribute(child, referenceChildren);
                }
                directChildren.add(child);
            }
            child = traversal.getNextSibling(child);
        }
        this.createAttributeComponents(referenceChildren, true);
        this.createAttributeComponents(directChildren, false);
    }

    private void getAttributes(Node node, List list) {
        boolean override = false;
        TreeTraversal traversal = this.diagram.getView().getTreeTraversal();
        Node child = traversal.getFirstChild(node);
        while (child != null) {
            if (child instanceof ReferenceNode) {
                ReferenceNode refNode = (ReferenceNode)((Object)child);
                GlobalReference reference = refNode.getReference();
                int type = reference.getReferenceType();
                Node referee = refNode.getReferee();
                if (type == 2) {
                    override = true;
                }
                if (!refNode.isCyclicReference()) {
                    this.getAttributes(referee, list);
                }
            } else if ("attributeGroup".equals(child.getLocalName())) {
                this.diagram.getView().addNodeListener(child, this);
                this.attributeGroups.add(child);
                this.getAttributes(child, list);
            } else if (ModelUtils.isAttributeRole(ModelUtils.getSchemaRole(child))) {
                if (override) {
                    this.overrideAttribute(child, list);
                }
                list.add(child);
            }
            child = traversal.getNextSibling(child);
        }
    }

    private void overrideAttribute(Node attribute, List list) {
        block5: {
            String type;
            block6: {
                type = attribute.getLocalName();
                if (!"anyAttribute".equals(type)) break block6;
                int i = 0;
                while (i < list.size()) {
                    Node node = (Node)list.get(i);
                    if ("anyAttribute".equals(node.getLocalName())) {
                        list.remove(i);
                        break block5;
                    }
                    ++i;
                }
                break block5;
            }
            if (!"attribute".equals(type)) break block5;
            String name = ModelUtils.getName(attribute);
            if (name == null) {
                name = ModelUtils.getAttribute((Element)attribute, "ref");
            }
            int i = 0;
            while (i < list.size()) {
                Node node = (Node)list.get(i);
                if (name.equals(ModelUtils.getName(node))) {
                    list.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    private void createAttributeComponents(Collection attributes, boolean isReference) {
        ComponentFactory factory = this.diagram.getComponentFactory();
        for (Node attribute : attributes) {
            HierarchalSchemaComponent component = factory.createSchemaComponent(this.diagram, attribute);
            if (component == null) continue;
            this.diagram.getView().addNodeListener(attribute, this);
            component.setShowBorder(false);
            if (component instanceof AttributeDeclaration) {
                component.setInsets(new Insets(0, 0, 0, 5));
                ((AttributeDeclaration)component).setInherited(isReference);
            } else {
                component.setInsets(GraphicsUtils.ZERO_INSETS);
            }
            this.add(component);
        }
    }

    private void destroyAll() {
        for (Node attributeGroup : this.attributeGroups) {
            this.diagram.getView().removeNodeListener(attributeGroup, this);
        }
        this.attributeGroups.clear();
        int i = 0;
        while (i < this.numChildren) {
            Element element = ((DiagramSchemaComponent)this.children[i]).getDomElement();
            this.diagram.getView().removeNodeListener(element, this);
            this.children[i].setParent(null);
            this.children[i].destroy();
            ++i;
        }
        this.numChildren = 0;
    }
}

