/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Insets;
import oracle.jdevimpl.xml.schema.diagram.AttrEditor;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ImageComponent;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AttributeDeclaration
extends HierarchalSchemaComponent {
    private ImageComponent image;
    private TextComponent name;
    private boolean inherited;
    private static final int MINIMUM_WIDTH = 60;
    private static final int MAXIMUM_WIDTH = 200;

    public AttributeDeclaration(Diagram diagram, Element element) {
        super(diagram, element);
        this.setForeground(Color.BLACK);
        this.name = this.isNameEditable() ? new AttrEditor(diagram) : new TextComponent(diagram);
        this.name.setInsets(new Insets(1, 1, 1, 1));
        this.add(this.name);
        this.image = new ImageComponent(diagram);
        this.add(this.image);
        this.update();
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
        this.setBackground(inherited ? GraphicsUtils.REFERENCE_COLOR : Color.WHITE);
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public int getPreferredWidth() {
        int width = this.image.getPreferredWidth() + this.name.getPreferredWidth() + this.insets.left + this.insets.right;
        width = Math.max(width, 60);
        width = Math.min(width, 200);
        return width;
    }

    public int getPreferredHeight() {
        return Math.max(this.image.getPreferredHeight(), this.name.getPreferredHeight()) + this.insets.top + this.insets.bottom;
    }

    public void layout() {
        int imageWidth = Math.min(this.image.getPreferredWidth(), this.width - this.insets.left - this.insets.right);
        this.image.setBounds(this.insets.left, this.insets.top, imageWidth, this.height - this.insets.top - this.insets.bottom);
        int nameWidth = Math.max(0, this.width - imageWidth - this.insets.left - this.insets.right);
        this.name.setBounds(this.insets.left + imageWidth, this.insets.top, nameWidth, this.height - this.insets.top - this.insets.bottom);
    }

    public void update() {
        super.update();
        if (this.image != null) {
            this.image.setImage(XmlSchemaArb.getInstance(), this.getIcon());
        }
        if (this.name != null) {
            if (this.isNameEditable()) {
                ((AttrEditor)this.name).setAttr(this.getNameAttr());
            } else {
                this.name.setText(this.getName());
            }
        }
    }

    protected boolean isNameEditable() {
        return true;
    }

    protected String getName() {
        return null;
    }

    protected Attr getNameAttr() {
        Attr attr = this.element.getAttributeNodeNS(null, "name");
        if (attr == null) {
            attr = this.element.getAttributeNodeNS(null, "ref");
        }
        return attr;
    }

    protected int getIcon() {
        String use = this.element.getAttributeNS(null, "use");
        if (use != null) {
            if (use.equals("required")) {
                return 2;
            }
            if (use.equals("prohibited")) {
                return 1;
            }
        }
        return 3;
    }
}

