/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.text.MessageFormat;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;

public class CardinalityComponent
extends TextComponent {
    private int minimum;
    private int maximum;
    public static final int UNBOUNDED = -1;

    public CardinalityComponent(Diagram diagram) {
        super(diagram);
        this.setFont(GraphicsUtils.getCardinalityFont());
        this.setForeground(GraphicsUtils.CARDINALITY_COLOR);
        this.setShowBorder(false);
    }

    public int getPreferredWidth() {
        if (this.showCardinality()) {
            return super.getPreferredWidth();
        }
        return 0;
    }

    public int getPreferredHeight() {
        if (this.showCardinality()) {
            return super.getPreferredHeight();
        }
        return 0;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.updateText();
        this.setVisible(this.showCardinality());
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        this.updateText();
        this.setVisible(this.showCardinality());
    }

    private boolean showCardinality() {
        return this.minimum > 1 || this.maximum > 1 || this.maximum == -1;
    }

    private void updateText() {
        String min = String.valueOf(this.minimum);
        String max = this.maximum == -1 ? XmlSchemaArb.getString(56) : String.valueOf(this.maximum);
        MessageFormat formatter = new MessageFormat(XmlSchemaArb.getString(21));
        this.setText(formatter.format(new Object[]{min, max}));
    }
}

