/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaEditorController;
import oracle.jdevimpl.xml.schema.XmlSchemaMetadataResolver;
import oracle.jdevimpl.xml.schema.diagram.AttrEditor;
import oracle.jdevimpl.xml.schema.diagram.AttributeContainer;
import oracle.jdevimpl.xml.schema.diagram.DerivationEditor;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ListChangeListener;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.TypeEditor;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComplexTypeDefinition
extends HierarchalSchemaComponent
implements ListChangeListener {
    private AttrEditor name;
    private AttributeContainer attributes;
    private DerivationEditor derivation;
    private TypeEditor type;
    private static final int MINIMUM_WIDTH = 60;
    private static final int MAXIMUM_WIDTH = 300;
    private static final Color COLOR = new Color(251, 166, 115);

    public ComplexTypeDefinition(Diagram diagram, Element element) {
        super(diagram, element);
        this.setBackground(COLOR);
        Attr attr = element.getAttributeNodeNS(null, "name");
        this.name = new AttrEditor(diagram, attr);
        this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
        this.name.setInsets(new Insets(3, 5, 0, 5));
        this.add(this.name);
        this.attributes = new AttributeContainer(diagram, element);
        this.add(this.attributes);
        this.derivation = new DerivationEditor(diagram);
        this.derivation.addListChangeListener(this);
        this.derivation.setInsets(new Insets(0, 10, 2, 5));
        this.add(this.derivation);
        this.type = new TypeEditor(diagram, element, 4);
        this.type.setInsets(new Insets(0, 0, 2, 0));
        this.type.addListChangeListener(this);
        this.add(this.type);
        this.update();
    }

    public void destroy() {
        super.destroy();
        this.derivation.removeListChangeListener(this);
        this.type.removeListChangeListener(this);
    }

    public int getPreferredWidth() {
        int width = this.name.getPreferredWidth() + 10;
        width = Math.max(width, this.attributes.getPreferredWidth());
        width = Math.max(width, this.derivation.getPreferredWidth() + this.type.getPreferredWidth() + 10);
        width += this.insets.left + this.insets.right;
        width = Math.max(width, 60);
        width = Math.min(width, 300);
        return width;
    }

    public int getPreferredHeight() {
        int attHeight = this.attributes.getPreferredHeight();
        int nameHeight = this.name.getPreferredHeight();
        int typeHeight = this.type.getPreferredHeight();
        if (typeHeight == 0) {
            typeHeight = 2;
        }
        int derivationHeight = this.derivation.getPreferredHeight();
        return nameHeight + attHeight + Math.max(typeHeight, derivationHeight) + this.insets.top + this.insets.bottom + (attHeight > 0 ? 1 : 0);
    }

    public Shape getShape() {
        int width = this.getWidth();
        int[] xpoints = new int[]{0, 5, width - 6, width - 1, width - 1, width - 2, 1, 0, 0};
        int[] ypoints = new int[]{5, 0, 0, 5, this.height - 2, this.height - 1, this.height - 1, this.height - 2, 5};
        return new Polygon(xpoints, ypoints, xpoints.length);
    }

    public void layout() {
        int w = this.width - this.insets.left - this.insets.right;
        int nameWidth = w - 10;
        this.name.setBounds(this.insets.left + 5, this.insets.top, nameWidth, this.name.getPreferredHeight());
        int nameHeight = this.name.getHeight();
        this.derivation.setBounds(this.insets.left, this.insets.top + nameHeight, this.derivation.getPreferredWidth(), this.derivation.getPreferredHeight());
        this.type.setBounds(this.insets.left + this.derivation.getWidth(), this.insets.top + nameHeight, w - this.derivation.getWidth(), this.type.getPreferredHeight());
        int typeHeight = Math.max(this.type.getHeight(), this.derivation.getHeight());
        if (typeHeight == 0) {
            typeHeight = 2;
        }
        this.attributes.setBounds(this.insets.left, this.insets.top + nameHeight + typeHeight + 1, w, this.attributes.getPreferredHeight());
    }

    public void update() {
        super.update();
        this.diagram.getView().acquireReadLock();
        try {
            if (this.name != null) {
                Attr attr = this.element.getAttributeNodeNS(null, "name");
                this.name.setAttr(attr);
            }
            Node child = this.diagram.getView().getTreeTraversal().getFirstChild((Node)this.element);
            Object attr = null;
            if (child instanceof ReferenceNode) {
                ReferenceNode refNode = (ReferenceNode)((Object)child);
                Node referee = refNode.getReferee();
                int refType = refNode.getReference().getReferenceType();
                this.derivation.setValueFromReferenceType(refType);
                if (referee == null && refNode.getReference().isBuiltInType() || referee != null && ModelUtils.isSimpleTypeDefinition(referee)) {
                    this.derivation.setPossibleValues(2);
                } else {
                    this.derivation.setPossibleValues(6);
                }
                this.type.setReference(refNode);
            } else {
                this.derivation.setValue(0);
                this.type.setReference(null);
            }
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.attributes.getHeight() > 0) {
            int y = this.insets.top + this.name.getHeight() + Math.max(this.type.getHeight(), this.derivation.getHeight());
            if (this.type.getHeight() == 0) {
                y += 2;
            }
            g.drawLine(this.insets.left, y, this.width - 1, y);
        }
    }

    public void valueChanged(ListComponent component) {
        if (component == this.derivation) {
            this.handleDerivationChange();
        } else if (component == this.type) {
            this.handleBaseTypeChange();
        }
    }

    private void handleDerivationChange() {
        block14: {
            int value = this.derivation.getValue();
            this.diagram.getView().acquireReadLock();
            try {
                Node content = DomUtils.getNamedChild((Node)this.element, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleContent");
                if (content == null) {
                    content = DomUtils.getNamedChild((Node)this.element, (String)"http://www.w3.org/2001/XMLSchema", (String)"complexContent");
                }
                Document document = this.diagram.getView().getDocument();
                DefaultPrefixLookup prefixLookup = this.diagram.getModel().getDefaultPrefixLookup();
                if (content == null) break block14;
                if (value == 2) {
                    Element restriction = (Element)DomUtils.getNamedChild((Node)content, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction");
                    if (restriction == null) break block14;
                    this.diagram.getModel().startTransaction(XmlSchemaArb.getString(5));
                    try {
                        Element extension = document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                        ModelUtils.copyAttr(restriction, extension, null, "base");
                        NamespaceUtils.fixPrefixes((Node)content, (Node)extension, (DefaultPrefixLookup)prefixLookup);
                        content.removeChild(restriction);
                        content.appendChild(extension);
                        this.diagram.getModel().commitTransaction();
                        break block14;
                    }
                    catch (XmlCommitException xce) {
                        this.diagram.getModel().rollbackTransaction();
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
                        break block14;
                    }
                    catch (ThreadDeath td) {
                        this.diagram.getModel().rollbackTransaction();
                        throw td;
                    }
                    catch (Throwable t) {
                        this.diagram.getModel().rollbackTransaction();
                        break block14;
                    }
                }
                Element extension = (Element)DomUtils.getNamedChild((Node)content, (String)"http://www.w3.org/2001/XMLSchema", (String)"extension");
                if (extension == null) break block14;
                this.diagram.getModel().startTransaction(XmlSchemaArb.getString(5));
                try {
                    Element restriction = document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                    ModelUtils.copyAttr(extension, restriction, null, "base");
                    NamespaceUtils.fixPrefixes((Node)content, (Node)restriction, (DefaultPrefixLookup)prefixLookup);
                    content.removeChild(extension);
                    content.appendChild(restriction);
                    String base = restriction.getAttributeNS(null, "base");
                    GlobalReference reference = new GlobalReference(this.diagram.getView().getNamespace(this.element, base), ModelUtils.getName(base), 4);
                    Node baseNode = this.diagram.getView().resolveReference(reference);
                    if (baseNode != null) {
                        ModelUtils.copyContent(baseNode, restriction, this.diagram.getView().getTreeTraversal(), prefixLookup);
                    }
                    this.diagram.getModel().commitTransaction();
                }
                catch (XmlCommitException xce) {
                    this.diagram.getModel().rollbackTransaction();
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
                }
                catch (ThreadDeath td) {
                    this.diagram.getModel().rollbackTransaction();
                    throw td;
                }
                catch (Throwable t) {
                    this.diagram.getModel().rollbackTransaction();
                }
            }
            finally {
                this.diagram.getView().releaseReadLock();
            }
        }
    }

    public void handleBaseTypeChange() {
        String value = this.type.getText().trim();
        if (value.length() == 0) {
            this.removeBaseType();
        } else {
            ModelUtils.setBaseType(this.diagram.getView(), this.element, value);
        }
    }

    private void removeBaseType() {
        Attr attr = this.type.getAttr();
        Element owner = attr.getOwnerElement();
        if (owner != null) {
            this.diagram.getModel().startTransaction(XmlSchemaArb.getString(28));
            try {
                owner.removeAttributeNode(attr);
                this.moveContent(owner, this.element);
                ModelUtils.removePath(this.element, owner);
                this.diagram.getModel().commitTransaction();
            }
            catch (XmlCommitException xce) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
            }
            catch (ThreadDeath td) {
                this.diagram.getModel().rollbackTransaction();
                throw td;
            }
            catch (Throwable t) {
                this.diagram.getModel().rollbackTransaction();
            }
        } else {
            this.type.setAttr(null);
        }
    }

    public List getActions() {
        ArrayList<Integer> list = new ArrayList<Integer>(3);
        list.addAll(super.getActions());
        this.diagram.getView().acquireReadLock();
        try {
            TreeTraversal traversal = this.diagram.getView().getTreeTraversal();
            Node child = traversal.getFirstChild((Node)this.element);
            if (!(child instanceof ReferenceNode)) {
                list.add(new Integer(XmlSchemaEditorController.SET_BASE_TYPE_CMD_ID));
            }
            ArrayList<Integer> arrayList = list;
            return arrayList;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    public boolean handleAction(IdeAction action) {
        if (action.getCommandId() == XmlSchemaEditorController.SET_BASE_TYPE_CMD_ID) {
            this.setBaseType();
            return true;
        }
        return super.handleAction(action);
    }

    private void setBaseType() {
        this.diagram.getView().acquireReadLock();
        try {
            Attr attr = this.diagram.getView().getDocument().createAttributeNS(null, "base");
            this.type.setAttr(attr);
            this.type.startEditing();
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    private void moveContent(Node from, Node to) {
        XmlSchemaMetadataResolver resovler = (XmlSchemaMetadataResolver)this.diagram.getView().getXmlMetadataResolver();
        Node child = from.getFirstChild();
        while (child != null) {
            int role = resovler.getSchemaRole(child);
            Node next = child.getNextSibling();
            if (ModelUtils.isAttributeRole(role) || ModelUtils.isModelGroupRole(role)) {
                from.removeChild(child);
                to.appendChild(child);
            }
            child = next;
        }
    }

    private void removeComplexContent(Node node) {
        XmlSchemaMetadataResolver resovler = (XmlSchemaMetadataResolver)this.diagram.getView().getXmlMetadataResolver();
        Node child = node.getFirstChild();
        while (child != null) {
            int role = resovler.getSchemaRole(child);
            Node next = child.getNextSibling();
            if (ModelUtils.isModelGroupRole(role)) {
                node.removeChild(child);
            }
            child = next;
        }
    }
}

