/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import oracle.bali.xml.dom.util.DomUtils;
import oracle.jdevimpl.xml.schema.diagram.AnyAttribute;
import oracle.jdevimpl.xml.schema.diagram.AnyModelGroup;
import oracle.jdevimpl.xml.schema.diagram.AttributeDeclaration;
import oracle.jdevimpl.xml.schema.diagram.AttributeGroup;
import oracle.jdevimpl.xml.schema.diagram.ComplexTypeDefinition;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.ElementDeclaration;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.IconicModelGroup;
import oracle.jdevimpl.xml.schema.diagram.Import;
import oracle.jdevimpl.xml.schema.diagram.Include;
import oracle.jdevimpl.xml.schema.diagram.List;
import oracle.jdevimpl.xml.schema.diagram.NamedModelGroup;
import oracle.jdevimpl.xml.schema.diagram.SchemaRootComponent;
import oracle.jdevimpl.xml.schema.diagram.SimpleTypeDefinition;
import oracle.jdevimpl.xml.schema.diagram.Union;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComponentFactory {
    public HierarchalSchemaComponent createSchemaComponent(Diagram diagram, Node node) {
        Element element;
        HierarchalSchemaComponent component = null;
        if (DomUtils.isElement((Node)node) && "http://www.w3.org/2001/XMLSchema".equals((element = (Element)node).getNamespaceURI())) {
            String name = element.getLocalName();
            if ("element".equals(name)) {
                component = new ElementDeclaration(diagram, element);
            } else if ("complexType".equals(name)) {
                component = new ComplexTypeDefinition(diagram, element);
            } else if ("simpleType".equals(name)) {
                component = new SimpleTypeDefinition(diagram, element);
            } else if ("sequence".equals(name) || "choice".equals(name) || "all".equals(name)) {
                component = new IconicModelGroup(diagram, element);
            } else if ("group".equals(name)) {
                component = new NamedModelGroup(diagram, element);
            } else if ("any".equals(name)) {
                component = new AnyModelGroup(diagram, element);
            } else if ("schema".equals(name)) {
                component = new SchemaRootComponent(diagram, element);
            } else if ("attribute".equals(name)) {
                component = new AttributeDeclaration(diagram, element);
            } else if ("attributeGroup".equals(name)) {
                component = new AttributeGroup(diagram, element);
            } else if ("include".equals(name)) {
                component = new Include(diagram, element);
            } else if ("import".equals(name)) {
                component = new Import(diagram, element);
            } else if ("anyAttribute".equals(name)) {
                component = new AnyAttribute(diagram, element);
            } else if ("list".equals(name)) {
                component = new List(diagram, element);
            } else if ("union".equals(name)) {
                component = new Union(diagram, element);
            }
        }
        return component;
    }
}

