/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.util.ArrayList;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;

public class DerivationEditor
extends ListComponent {
    public static final int DERIVATION_UNKNOWN = 0;
    public static final int DERIVATION_TYPE = 1;
    public static final int DERIVATION_EXTENSION = 2;
    public static final int DERIVATION_RESTRICTION = 4;
    private int value;

    public DerivationEditor(Diagram diagram) {
        this(diagram, 6);
    }

    public DerivationEditor(Diagram diagram, int possibleValues) {
        this(diagram, possibleValues, 0);
    }

    public DerivationEditor(Diagram diagram, int possibleValues, int value) {
        super(diagram, false);
        this.setPossibleValues(possibleValues);
        this.setValue(value);
    }

    public int getPreferredWidth() {
        if (this.value != 0) {
            return super.getPreferredWidth();
        }
        return 0;
    }

    public int getPreferredHeight() {
        if (this.value != 0) {
            return super.getPreferredHeight();
        }
        return 0;
    }

    public void setValue(int value) {
        this.value = value;
        this.setText(this.getTextForValue(value));
    }

    public int getValue() {
        return this.value;
    }

    public void setPossibleValues(int possibleValues) {
        ArrayList<String> itemList = new ArrayList<String>(3);
        if ((possibleValues & 1) == 1) {
            itemList.add(this.getTextForValue(1));
        }
        if ((possibleValues & 2) == 2) {
            itemList.add(this.getTextForValue(2));
        }
        if ((possibleValues & 4) == 4) {
            itemList.add(this.getTextForValue(4));
        }
        this.setItems(itemList.toArray(new String[0]));
    }

    protected String getEditorValue() {
        String text = super.getEditorValue();
        this.value = this.getValueFromText(text);
        return text;
    }

    public void setValueFromReferenceType(int refType) {
        switch (refType) {
            case 4: {
                this.setValue(1);
                break;
            }
            case 3: {
                this.setValue(2);
                break;
            }
            case 2: {
                this.setValue(4);
                break;
            }
            default: {
                this.setValue(0);
                break;
            }
        }
    }

    private String getTextForValue(int value) {
        switch (value) {
            case 1: {
                return XmlSchemaArb.getString(15);
            }
            case 2: {
                return XmlSchemaArb.getString(50);
            }
            case 4: {
                return XmlSchemaArb.getString(20);
            }
        }
        return null;
    }

    private int getValueFromText(String text) {
        if (XmlSchemaArb.getString(15).equals(text)) {
            return 1;
        }
        if (XmlSchemaArb.getString(50).equals(text)) {
            return 2;
        }
        if (XmlSchemaArb.getString(20).equals(text)) {
            return 4;
        }
        return 0;
    }
}

