/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.XmlGui;
import oracle.jdevimpl.xml.schema.XmlSchemaDesignGui;
import oracle.jdevimpl.xml.schema.XmlSchemaLayoutView;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.diagram.ComponentFactory;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramDropHandler;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSelectionManager;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.Subtree;
import oracle.jdevimpl.xml.schema.diagram.VerticalTree;
import org.w3c.dom.Node;

public class Diagram
extends JPanel
implements Scrollable {
    private float zoomFactor;
    private int zoomLevel;
    private HierarchalSchemaComponent root;
    private ComponentFactory factory;
    private XmlSchemaDesignGui gui;
    private Subtree tree;
    private DiagramSelectionManager selectionManager;
    private boolean focused;
    private HashMap nodeMap;

    private void $init$() {
        this.zoomFactor = 1.0f;
        this.nodeMap = new HashMap();
    }

    public Diagram(Node node, XmlSchemaDesignGui gui, ComponentFactory factory) {
        super(false);
        this.$init$();
        this.gui = gui;
        this.setBackground(GraphicsUtils.DIAGRAM_BACKGROUND_COLOR);
        DiagramDropHandler dropHandler = new DiagramDropHandler(this);
        DropTarget dropTarget = new DropTarget(this, 3, (DropTargetListener)((Object)dropHandler), true);
        this.setDropTarget(dropTarget);
        this.selectionManager = new DiagramSelectionManager(this);
        this.factory = factory;
        this.setRoot(node);
    }

    public void dispose() {
        this.selectionManager.dispose();
        this.removeAll();
        this.setDropTarget(null);
        this.nodeMap.clear();
        if (this.tree != null) {
            this.tree.destroy();
        }
        this.tree = null;
        if (this.root != null) {
            this.root.destroy();
        }
        this.root = null;
        this.gui = null;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? (int)visibleRect.getHeight() - 10 : (int)visibleRect.getWidth() - 10;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public float getMinimumZoom() {
        return 0.1f;
    }

    public float getMaximumZoom() {
        return 10.0f;
    }

    public float getZoomMultiplier() {
        return 1.5f;
    }

    public void setZoomFactor(float zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public float getZoomFactor() {
        return this.zoomFactor;
    }

    public Dimension getPreferredSize() {
        Dimension size = this.tree != null ? new Dimension((int)((float)this.tree.getPreferredWidth() * this.zoomFactor), (int)((float)this.tree.getPreferredHeight() * this.zoomFactor)) : new Dimension(0, 0);
        return size;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphics = (Graphics2D)g;
        AffineTransform transform = graphics.getTransform();
        graphics.scale(this.zoomFactor, this.zoomFactor);
        g.translate(this.tree.getX(), this.tree.getY());
        this.tree.paint(g);
        g.translate(-this.tree.getX(), -this.tree.getY());
        graphics.setTransform(transform);
    }

    public XmlSchemaLayoutView getView() {
        return (XmlSchemaLayoutView)this.getGui().getView();
    }

    public void setRoot(Node node) {
        this.root = this.factory.createSchemaComponent(this, node);
        if (this.root != null) {
            this.tree = new VerticalTree(this, this.root);
            this.tree.setInsets(new Insets(10, 10, 10, 10));
            this.tree.setExpanded(true);
        } else {
            this.tree = null;
        }
        this.revalidate();
    }

    public DiagramSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public ComponentFactory getComponentFactory() {
        return this.factory;
    }

    public DiagramSchemaComponent getRootComponent() {
        return this.root;
    }

    public Subtree getTree() {
        return this.tree;
    }

    public XmlGui getGui() {
        return this.gui;
    }

    public void doLayout() {
        if (this.tree != null) {
            this.tree.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.tree.validate();
        }
    }

    public void zoomIn(Point center) {
        float zoomMax = this.getMaximumZoom();
        float zoomIncrement = this.getZoomMultiplier();
        float zoomFactor = (float)Math.pow(zoomIncrement, this.zoomLevel + 1);
        if (zoomFactor <= zoomMax) {
            if (center != null) {
                this.centerPoint(center);
            }
            ++this.zoomLevel;
            this.setZoomFactor(zoomFactor);
            this.revalidate();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void zoomOut(Point center) {
        float zoomMin = this.getMinimumZoom();
        float zoomIncrement = this.getZoomMultiplier();
        float zoomFactor = (float)Math.pow(zoomIncrement, this.zoomLevel - 1);
        if (zoomFactor >= zoomMin) {
            if (center != null) {
                this.centerPoint(center);
            }
            --this.zoomLevel;
            this.setZoomFactor(zoomFactor);
            this.revalidate();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void add(Node node, DiagramComponent component) {
        LinkedList<DiagramComponent> list = (LinkedList<DiagramComponent>)this.nodeMap.get(node);
        if (list == null) {
            list = new LinkedList<DiagramComponent>();
            this.nodeMap.put(node, list);
        }
        list.add(component);
    }

    public void remove(Node node, DiagramComponent component) {
        List list = (List)this.nodeMap.get(node);
        if (list != null) {
            list.remove(component);
            if (list.isEmpty()) {
                this.nodeMap.remove(node);
            }
        }
    }

    public List getDiagramComponentsForNode(Node node) {
        return (List)this.nodeMap.get(node);
    }

    public DiagramComponent getDiagramComponentAt(Point p) {
        Point scaled = new Point((int)((float)p.x / this.zoomFactor), (int)((float)p.y / this.zoomFactor));
        return this.tree != null ? this.tree.getComponentAt(scaled) : null;
    }

    public DiagramSchemaComponent getSchemaComponentAt(Point p) {
        DiagramComponent component = this.getDiagramComponentAt(p);
        while (component != null && !(component instanceof DiagramSchemaComponent)) {
            component = component.getParent();
        }
        return (DiagramSchemaComponent)component;
    }

    public DomPosition getDomPosition(Point p) {
        Point scaled = new Point((int)((float)p.x / this.zoomFactor), (int)((float)p.y / this.zoomFactor));
        return this.tree.getDomPosition(scaled);
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        if (this.focused != focused) {
            this.focused = focused;
            if (focused) {
                this.gui.activate();
            } else {
                this.gui.deactivate();
            }
            DiagramSchemaComponent active = this.selectionManager.getActiveComponent();
            if (active != null) {
                active.repaint();
            }
            Iterator iterator = this.selectionManager.getSelectedComponents().iterator();
            while (iterator.hasNext()) {
                ((DiagramComponent)iterator.next()).repaint();
            }
        }
    }

    public void scrollToVisible(DiagramComponent component) {
        if (!component.valid) {
            this.doLayout();
        }
        Rectangle rect = component.getBounds(null);
        DiagramComponent parent = component.getParent();
        while (parent != null) {
            rect.x += parent.getX();
            rect.y += parent.getY();
            parent = parent.getParent();
        }
        rect.x = (int)((float)rect.x * this.zoomFactor);
        rect.y = (int)((float)rect.y * this.zoomFactor);
        rect.width = (int)((float)rect.width * this.zoomFactor);
        rect.height = (int)((float)rect.height * this.zoomFactor);
        this.scrollRectToVisible(rect);
    }

    public final XmlSchemaModel getModel() {
        return (XmlSchemaModel)this.getGui().getView().getBaseModel();
    }

    private void centerPoint(Point center) {
    }

    public void scaledRepaint(int x, int y, int width, int height) {
        this.repaint((int)((float)x * this.zoomFactor), (int)((float)y * this.zoomFactor), (int)((float)(width + 1) * this.zoomFactor), (int)((float)(height + 1) * this.zoomFactor));
    }

    private Rectangle getZoomRectangle(Rectangle r) {
        r.setBounds((int)((float)r.x * this.zoomFactor), (int)((float)r.y * this.zoomFactor), (int)((float)(r.width + 1) * this.zoomFactor), (int)((float)(r.height + 1) * this.zoomFactor));
        return r;
    }
}

