/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;

public abstract class DiagramComponent {
    protected Diagram diagram;
    protected DiagramComponent parent;
    protected int numChildren;
    protected DiagramComponent[] children;
    protected boolean valid;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean visible;
    protected Insets insets;
    protected Color background;
    protected Color foreground;
    protected boolean showBorder;
    protected Stroke stroke;

    private void $init$() {
        this.children = new DiagramComponent[0];
        this.visible = true;
        this.insets = GraphicsUtils.ZERO_INSETS;
    }

    public DiagramComponent(Diagram diagram) {
        this.$init$();
        this.diagram = diagram;
    }

    public void setParent(DiagramComponent parent) {
        this.parent = parent;
    }

    public DiagramComponent getParent() {
        return this.parent;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
        this.invalidate();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        if (this.parent != null) {
            return this.parent.getBackground();
        }
        return this.diagram.getBackground();
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        if (this.parent != null) {
            return this.parent.getForeground();
        }
        return this.diagram.getForeground();
    }

    public Color getBorderColor() {
        return Color.BLACK;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
    }

    public boolean getShowBorder() {
        return this.showBorder;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void insert(DiagramComponent child, int index) {
        DiagramComponent oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.remove(child);
        }
        child.setParent(this);
        int size = this.children.length;
        if (this.numChildren == this.children.length) {
            size = this.children.length * 2 + 1;
        }
        DiagramComponent[] newChildren = new DiagramComponent[size];
        if (index > 0) {
            System.arraycopy(this.children, 0, newChildren, 0, index - 1);
        }
        System.arraycopy(this.children, index, newChildren, index + 1, this.numChildren - index);
        this.children = newChildren;
        this.children[index] = child;
        ++this.numChildren;
        this.invalidate();
    }

    public void add(DiagramComponent child) {
        DiagramComponent oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.remove(child);
        }
        child.setParent(this);
        if (this.numChildren == this.children.length) {
            DiagramComponent[] newChildren = new DiagramComponent[this.children.length * 2 + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.numChildren);
            this.children = newChildren;
        }
        this.children[this.numChildren++] = child;
        this.invalidate();
    }

    public void remove(DiagramComponent child) {
        int i = 0;
        while (i < this.numChildren) {
            if (this.children[i] == child) {
                System.arraycopy(this.children, i + 1, this.children, i, this.numChildren - i - 1);
                this.children[--this.numChildren] = null;
            }
            ++i;
        }
        child.setParent(null);
        this.invalidate();
    }

    public void removeAll() {
        int i = 0;
        while (i < this.numChildren) {
            this.children[i].setParent(null);
            ++i;
        }
        this.numChildren = 0;
        this.invalidate();
    }

    public int getChildCount() {
        return this.numChildren;
    }

    public DiagramComponent getChild(int index) {
        return this.children[index];
    }

    public void invalidate() {
        this.valid = false;
        if (this.parent != null) {
            this.parent.invalidate();
        } else {
            this.diagram.revalidate();
        }
    }

    public void validate() {
        if (!this.valid) {
            this.layout();
            int i = 0;
            while (i < this.numChildren) {
                this.children[i].validate();
                ++i;
            }
            this.valid = true;
        }
    }

    public void layout() {
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintComponent(g);
        this.paintChildren(g);
    }

    public void paintBackground(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        Shape shape = this.getShape();
        Color originalColor = g.getColor();
        g.setColor(this.diagram.getBackground());
        graphics.fill(shape);
        g.setColor(this.getBackground());
        graphics.fill(shape);
        if (this.showBorder) {
            g.setColor(this.parent != null ? this.parent.getBackground() : Color.WHITE);
            graphics.draw(shape);
            g.setColor(this.getBorderColor());
            Stroke originalStroke = null;
            if (this.stroke != null) {
                originalStroke = graphics.getStroke();
                graphics.setStroke(this.stroke);
            }
            graphics.draw(shape);
            if (originalStroke != null) {
                graphics.setStroke(originalStroke);
            }
        } else {
            graphics.draw(shape);
        }
        g.setColor(originalColor);
    }

    public void paintComponent(Graphics g) {
    }

    public void paintChildren(Graphics g) {
        Rectangle clipRect = g.getClipBounds();
        Rectangle bounds = new Rectangle();
        int i = this.numChildren - 1;
        while (i >= 0) {
            if (this.children[i].isVisible()) {
                bounds = this.children[i].getBounds(bounds);
                bounds.grow(5, 5);
                if (bounds.intersects(clipRect)) {
                    g.translate(this.children[i].x, this.children[i].y);
                    this.children[i].paint(g);
                    g.translate(-this.children[i].x, -this.children[i].y);
                }
            }
            --i;
        }
    }

    public Shape getShape() {
        return new Rectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public abstract int getPreferredWidth();

    public abstract int getPreferredHeight();

    public void setBounds(int x, int y, int width, int height) {
        int oldX = this.x;
        int oldY = this.y;
        int oldWidth = this.width;
        int oldHeight = this.height;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        if (this.x != oldX || this.y != oldY || this.width != oldWidth || this.height != oldHeight) {
            this.repaint(oldX - this.x, oldY - this.y, oldWidth, oldHeight);
            this.repaint();
            this.invalidate();
        }
    }

    public Rectangle getBounds(Rectangle r) {
        if (r == null) {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }
        r.setBounds(this.x, this.y, this.width, this.height);
        return r;
    }

    public DiagramComponent getComponentAt(Point p) {
        Rectangle bounds = new Rectangle();
        int i = 0;
        while (i < this.numChildren) {
            if (this.children[i].isVisible() && this.children[i].getBounds(bounds).contains(p)) {
                p.translate(-this.children[i].x, -this.children[i].y);
                return this.children[i].getComponentAt(p);
            }
            ++i;
        }
        if (this.getShape().contains(p)) {
            return this;
        }
        return null;
    }

    public DomPosition getDomPosition(Point p) {
        DomPosition pos = null;
        Rectangle bounds = new Rectangle();
        int i = 0;
        while (pos == null && i < this.numChildren) {
            if (this.children[i].isVisible() && this.children[i].getBounds(bounds).contains(p)) {
                p.translate(-this.children[i].x, -this.children[i].y);
                pos = this.children[i].getDomPosition(p);
                p.translate(this.children[i].x, this.children[i].y);
            }
            ++i;
        }
        return pos;
    }

    public Shape getDomPositionShape(DiagramComponent component, int relativePosition) {
        Rectangle shape = null;
        if (relativePosition == 0) {
            shape = component.getBounds(null);
        }
        return shape;
    }

    public void repaint(int x, int y, int width, int height) {
        if (this.parent != null) {
            this.parent.repaint(this.getX() + x, this.getY() + y, width, height);
        } else {
            this.diagram.scaledRepaint(this.getX() + x, this.getY() + y, width, height);
        }
    }

    public void repaint() {
        if (this.visible) {
            this.repaint(0, 0, this.width, this.height);
        }
    }

    public void destroy() {
        int i = 0;
        while (i < this.numChildren) {
            this.children[i].destroy();
            this.children[i] = null;
            ++i;
        }
        this.numChildren = 0;
    }
}

