/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.swing.dnd.DefaultDragGestureRecognizer;
import oracle.bali.xml.gui.swing.dnd.DragGestureIdentifier;
import oracle.bali.xml.gui.swing.dnd.ModelDragHandler;
import oracle.bali.xml.model.Selection;
import oracle.javatools.util.PlatformUtils;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaDesignGui;
import oracle.jdevimpl.xml.schema.diagram.AttributeDeclaration;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSelectionManager;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.MouseAware;
import oracle.jdevimpl.xml.schema.diagram.ReferenceSubtree;
import oracle.jdevimpl.xml.schema.diagram.SchemaToolTip;
import oracle.jdevimpl.xml.schema.diagram.Subtree;
import oracle.jdevimpl.xml.schema.diagram.TopLevelComponent;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DiagramGlassPane
extends JPanel {
    private Diagram diagram;
    private boolean valid;
    private boolean supported;
    private MultiLineLabel error;
    private int mode;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_GRAB = 1;
    public static final int MODE_GRABBING = 2;
    public static final int MODE_ZOOM_IN = 3;
    public static final int MODE_ZOOM_OUT = 4;
    private static Cursor GRAB_CURSOR;
    private static Cursor GRABBING_CURSOR;
    private static Cursor ZOOM_IN_CURSOR;
    private static Cursor ZOOM_OUT_CURSOR;
    private Point grabStart;

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension cursorSize = toolkit.getBestCursorSize(32, 32);
        if (cursorSize.getWidth() == 0.0 && cursorSize.getHeight() == 0.0) {
            GRABBING_CURSOR = GRAB_CURSOR = Cursor.getPredefinedCursor(12);
            ZOOM_OUT_CURSOR = ZOOM_IN_CURSOR = Cursor.getDefaultCursor();
        } else {
            URL grabURL = DiagramGlassPane.class.getResource("/oracle/jdevimpl/xml/schema/resource/images/grab.gif");
            URL grabbingURL = DiagramGlassPane.class.getResource("/oracle/jdevimpl/xml/schema/resource/images/grabbing.gif");
            URL zoomInURL = DiagramGlassPane.class.getResource("/oracle/jdevimpl/xml/schema/resource/images/zoomin.gif");
            URL zoomOutURL = DiagramGlassPane.class.getResource("/oracle/jdevimpl/xml/schema/resource/images/zoomout.gif");
            GRAB_CURSOR = grabURL != null ? toolkit.createCustomCursor(toolkit.createImage(grabURL), new Point(0, 0), "jdev.grab") : Cursor.getPredefinedCursor(12);
            GRABBING_CURSOR = grabbingURL != null ? toolkit.createCustomCursor(toolkit.createImage(grabbingURL), new Point(0, 0), "jdev.grabbing") : GRAB_CURSOR;
            ZOOM_IN_CURSOR = zoomInURL != null ? toolkit.createCustomCursor(toolkit.createImage(zoomInURL), new Point(0, 0), "jdev.zoomin") : Cursor.getDefaultCursor();
            ZOOM_OUT_CURSOR = zoomOutURL != null ? toolkit.createCustomCursor(toolkit.createImage(zoomOutURL), new Point(0, 0), "jdev.zoomout") : ZOOM_IN_CURSOR;
        }
    }

    public DiagramGlassPane() {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setLayout(null);
        this.setFocusCycleRoot(true);
        this.addKeyListener(new DiagramKeyHandler(null));
        DragIdentifier dragIdentifier = new DragIdentifier(null);
        dragIdentifier.setDelegatee(new DiagramMouseHandler(null));
        dragIdentifier.registerListeners(this);
        this.addFocusListener(new 1());
    }

    public void dispose() {
        this.removeAll();
        if (this.getActionMap() != null) {
            this.getActionMap().clear();
        }
    }

    public void setMode(int mode) {
        if (this.mode != mode) {
            this.mode = mode;
            switch (mode) {
                case 0: {
                    this.setCursor(Cursor.getDefaultCursor());
                    break;
                }
                case 1: {
                    this.setCursor(GRAB_CURSOR);
                    break;
                }
                case 2: {
                    this.setCursor(GRABBING_CURSOR);
                    break;
                }
                case 3: {
                    this.setCursor(ZOOM_IN_CURSOR);
                    break;
                }
                case 4: {
                    this.setCursor(ZOOM_OUT_CURSOR);
                    break;
                }
            }
        }
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        this.updateError();
    }

    public void setSupported(boolean supported) {
        this.supported = supported;
        this.updateError();
    }

    public void doLayout() {
        if (this.error != null) {
            Dimension prefSize = this.error.getPreferredSize();
            Rectangle visible = this.getVisibleRect();
            this.error.setBounds(Math.max(0, (int)(visible.getWidth() - prefSize.getWidth()) / 2), Math.max(0, (int)(visible.getHeight() - prefSize.getHeight()) / 2), (int)prefSize.getWidth(), (int)prefSize.getHeight());
        }
    }

    private void updateError() {
        if (!this.supported) {
            this.setError(XmlSchemaArb.getString(63));
        } else if (!this.valid) {
            this.setError(XmlSchemaArb.getString(34));
        } else {
            this.setError(null);
        }
    }

    private void setError(String message) {
        if (message != null) {
            this.error = new MultiLineLabel();
            this.error.setText(message);
            this.error.setOpaque(true);
            this.error.setForeground(GraphicsUtils.ERROR_FOREGROUND);
            this.error.setBackground(GraphicsUtils.ERROR_BACKGROUND);
            this.error.setTextWrapper(WordWrapper.getTextWrapper());
            this.error.setPreferredColumns(60);
            this.error.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(3, 5, 3, 5)));
            this.error.setVisible(this.hasFocus());
            this.add((Component)this.error);
        } else if (this.error != null) {
            this.remove((Component)this.error);
            this.error = null;
        }
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.valid || !this.supported) {
            Color transparent = new Color(255, 255, 255, 150);
            Color oldColor = g.getColor();
            g.setColor(transparent);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(oldColor);
            if (this.error != null && this.error.isVisible()) {
                GraphicsUtils.drawDropShadow(g, this.error.getBounds());
            }
        } else if (this.diagram != null) {
            Selection selection = this.diagram.getGui().getView().getSelection();
            selection.acquireModelReadLock();
            try {
                List list;
                DomPosition dropPosition = selection.getDropLocation();
                if (dropPosition != null && (list = this.diagram.getDiagramComponentsForNode(dropPosition.getTargetNode())) != null) {
                    Iterator iterator = list.iterator();
                    Graphics2D graphics = (Graphics2D)g;
                    graphics.translate(this.diagram.getX(), this.diagram.getY());
                    AffineTransform transform = graphics.getTransform();
                    graphics.scale(this.diagram.getZoomFactor(), this.diagram.getZoomFactor());
                    while (iterator.hasNext()) {
                        Shape shape;
                        DiagramComponent parent;
                        DiagramSchemaComponent component = (DiagramSchemaComponent)iterator.next();
                        if (!this.isVisible(component) || (parent = component.getParent()) == null || (shape = parent.getDomPositionShape(component, dropPosition.getRelativePosition())) == null) continue;
                        AffineTransform oldTransform = graphics.getTransform();
                        while (parent != null) {
                            graphics.translate(parent.getX(), parent.getY());
                            parent = parent.getParent();
                        }
                        Stroke oldStroke = graphics.getStroke();
                        graphics.setStroke(new BasicStroke(2.0f));
                        graphics.setXORMode(Color.GRAY);
                        graphics.draw(shape);
                        graphics.setXORMode(Color.BLACK);
                        graphics.setStroke(oldStroke);
                        graphics.setTransform(oldTransform);
                    }
                    graphics.setTransform(transform);
                    graphics.translate(-this.diagram.getX(), -this.diagram.getY());
                }
            }
            finally {
                selection.releaseModelReadLock();
            }
        }
    }

    private boolean isVisible(DiagramComponent component) {
        boolean visible = component.isVisible();
        DiagramComponent parent = component.getParent();
        while (visible && parent != null) {
            visible = parent.isVisible();
            parent = parent.getParent();
        }
        return visible;
    }

    private Rectangle getBounds(DiagramComponent component, Rectangle bounds) {
        bounds = component.getBounds(bounds);
        DiagramComponent parent = component.getParent();
        while (parent != null) {
            bounds.x += parent.getX();
            bounds.y += parent.getY();
            parent = parent.getParent();
        }
        return bounds;
    }

    private Subtree getSubtree(DiagramComponent component) {
        DiagramComponent parent = component.getParent();
        while (parent != null && !(parent instanceof Subtree)) {
            parent = parent.getParent();
        }
        return (Subtree)parent;
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
        this.setValid(diagram.getView().getBaseModel().isDocumentValid());
    }

    public String getToolTipText(MouseEvent event) {
        if (!this.valid || !this.supported) {
            return null;
        }
        event.translatePoint(-this.diagram.getX(), -this.diagram.getY());
        DiagramSchemaComponent component = this.diagram.getSchemaComponentAt(event.getPoint());
        if (component != null) {
            this.diagram.getView().acquireReadLock();
            try {
                ReferenceNode refNode;
                Node focusNode;
                StringBuffer buffer = new StringBuffer();
                String annotation = ModelUtils.getAnnotation(this.diagram.getGui().getView().getTreeTraversal(), component.getDomElement());
                String name = ModelUtils.getName(component.getDomElement());
                if (name == null) {
                    name = ModelUtils.getAttribute(component.getDomElement(), "ref");
                }
                if (name == null) {
                    name = component.getDomElement().getLocalName();
                }
                if (name != null) {
                    buffer.append("%%%");
                    buffer.append(name);
                    buffer.append("%%%");
                }
                if (annotation != null) {
                    buffer.append(annotation);
                }
                if ((focusNode = this.diagram.getView().getTreeTraversal().getFirstChild((Node)component.getDomElement())) instanceof ReferenceNode && (refNode = (ReferenceNode)((Object)focusNode)).getReferee() == null && !refNode.getReference().isBuiltInType()) {
                    buffer.append("~~");
                    buffer.append(refNode.getReference().getName() + " - ");
                    buffer.append(XmlSchemaArb.getString(59));
                }
                String string = buffer.length() > 0 ? buffer.toString() : null;
                return string;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.diagram.getView().releaseReadLock();
            }
        }
        event.translatePoint(this.diagram.getX(), this.diagram.getY());
        return null;
    }

    public JToolTip createToolTip() {
        return new SchemaToolTip();
    }

    static boolean ra$valid(DiagramGlassPane diagramGlassPane) {
        return diagramGlassPane.valid;
    }

    static boolean ra$supported(DiagramGlassPane diagramGlassPane) {
        return diagramGlassPane.supported;
    }

    static Diagram ra$diagram(DiagramGlassPane diagramGlassPane) {
        return diagramGlassPane.diagram;
    }

    static int ra$mode(DiagramGlassPane diagramGlassPane) {
        return diagramGlassPane.mode;
    }

    static Point ra$grabStart(DiagramGlassPane diagramGlassPane) {
        return diagramGlassPane.grabStart;
    }

    static void wa$grabStart(DiagramGlassPane diagramGlassPane, Point point) {
        diagramGlassPane.grabStart = point;
    }

    static Subtree mav$getSubtree(DiagramGlassPane diagramGlassPane, DiagramComponent diagramComponent) {
        return diagramGlassPane.getSubtree(diagramComponent);
    }

    static MultiLineLabel ra$error(DiagramGlassPane diagramGlassPane) {
        return diagramGlassPane.error;
    }

    final class 1
    implements FocusListener {
        public void focusGained(FocusEvent fe) {
            if (DiagramGlassPane.ra$error(DiagramGlassPane.this) != null) {
                DiagramGlassPane.ra$error(DiagramGlassPane.this).setVisible(true);
                DiagramGlassPane.this.repaint();
            }
        }

        public void focusLost(FocusEvent fe) {
            if (DiagramGlassPane.ra$error(DiagramGlassPane.this) != null) {
                DiagramGlassPane.ra$error(DiagramGlassPane.this).setVisible(false);
                DiagramGlassPane.this.repaint();
            }
        }
    }

    private class DragIdentifier
    extends DragGestureIdentifier {
        protected boolean isDragPossible(MouseEvent e) {
            if (DiagramGlassPane.ra$valid(DiagramGlassPane.this) && DiagramGlassPane.ra$supported(DiagramGlassPane.this) && DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 0 && DiagramGlassPane.ra$diagram(DiagramGlassPane.this) != null) {
                e.translatePoint(-DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), -DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                DiagramSchemaComponent component = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSchemaComponentAt(e.getPoint());
                e.translatePoint(DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                if (component != null) {
                    if (component instanceof AttributeDeclaration && ((AttributeDeclaration)component).isInherited()) {
                        return false;
                    }
                    Element node = component.getDomElement();
                    Selection selection = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getGui().getView().getSelection();
                    selection.acquireModelReadLock();
                    try {
                        boolean bl = selection.contains((Node)node);
                        return bl;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        selection.releaseModelReadLock();
                    }
                }
            }
            return false;
        }

        protected void startDrag(MouseEvent currentEvent, MouseEvent armingEvent) {
            if (DiagramGlassPane.ra$valid(DiagramGlassPane.this) && DiagramGlassPane.ra$supported(DiagramGlassPane.this)) {
                ModelDragHandler dragHandler = new ModelDragHandler(DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getGui(), null, null);
                new DefaultDragGestureRecognizer((DragGestureListener)dragHandler).requestDragStart((Component)DiagramGlassPane.this, currentEvent, 3, 2);
            }
        }

        private DragIdentifier() {
        }

        DragIdentifier(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DiagramMouseHandler
    extends MouseInputAdapter {
        private boolean selectedOnPress;

        public void mousePressed(MouseEvent e) {
            this.selectedOnPress = false;
            if (!e.isConsumed()) {
                DiagramGlassPane.this.requestFocus();
                if (DiagramGlassPane.ra$valid(DiagramGlassPane.this) && DiagramGlassPane.ra$supported(DiagramGlassPane.this) && !this.handlePopup(e)) {
                    if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 1) {
                        DiagramGlassPane.this.setMode(2);
                        DiagramGlassPane.wa$grabStart(DiagramGlassPane.this, e.getPoint());
                        e.consume();
                    } else if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 0) {
                        this.selectedOnPress = this.handleSelection(e);
                        if (!this.selectedOnPress) {
                            DiagramComponent component = this.getComponentForEvent(e);
                            boolean consumed = false;
                            while (!consumed && component != null) {
                                if (component instanceof MouseAware) {
                                    consumed = ((MouseAware)((Object)component)).mousePressed(e);
                                }
                                component = component.getParent();
                            }
                            if (consumed) {
                                e.consume();
                            }
                        }
                    }
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (!e.isConsumed() && DiagramGlassPane.ra$valid(DiagramGlassPane.this) && DiagramGlassPane.ra$supported(DiagramGlassPane.this) && !this.selectedOnPress && DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 0) {
                DiagramComponent component = this.getComponentForEvent(e);
                boolean consumed = false;
                while (!consumed && component != null) {
                    if (component instanceof MouseAware) {
                        consumed = ((MouseAware)((Object)component)).mouseClicked(e);
                    }
                    component = component.getParent();
                }
                if (consumed) {
                    e.consume();
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (DiagramGlassPane.ra$valid(DiagramGlassPane.this) && DiagramGlassPane.ra$supported(DiagramGlassPane.this) && !e.isConsumed() && !this.handlePopup(e)) {
                if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 2) {
                    DiagramGlassPane.this.setMode(1);
                    e.consume();
                } else if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 3) {
                    DiagramGlassPane.ra$diagram(DiagramGlassPane.this).zoomIn(e.getPoint());
                    e.consume();
                } else if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 4) {
                    DiagramGlassPane.ra$diagram(DiagramGlassPane.this).zoomOut(e.getPoint());
                    e.consume();
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (DiagramGlassPane.ra$valid(DiagramGlassPane.this) && DiagramGlassPane.ra$supported(DiagramGlassPane.this) && !e.isConsumed() && DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 2) {
                Point grabEnd = e.getPoint();
                Rectangle visible = DiagramGlassPane.this.getVisibleRect();
                visible.x += DiagramGlassPane.ra$grabStart((DiagramGlassPane)DiagramGlassPane.this).x - grabEnd.x;
                visible.y += DiagramGlassPane.ra$grabStart((DiagramGlassPane)DiagramGlassPane.this).y - grabEnd.y;
                DiagramGlassPane.this.scrollRectToVisible(visible);
            }
        }

        private boolean handlePopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                e.translatePoint(-DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), -DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                DiagramSchemaComponent component = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSchemaComponentAt(e.getPoint());
                e.translatePoint(DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                DiagramSelectionManager manager = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager();
                if (component != null && !manager.isActive(component) && !manager.isSelected(component)) {
                    manager.select(component);
                }
                ((XmlSchemaDesignGui)DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getGui()).showPopupMenu(e);
                e.consume();
                return true;
            }
            return false;
        }

        private boolean handleSelection(MouseEvent e) {
            DiagramSelectionManager manager = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager();
            if (this.isToggleSelectionEvent(e)) {
                e.translatePoint(-DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), -DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                DiagramSchemaComponent component = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSchemaComponentAt(e.getPoint());
                e.translatePoint(DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                if (component != null) {
                    if (manager.isSelected(component)) {
                        manager.remove(component);
                    } else {
                        manager.add(component);
                    }
                    DiagramGlassPane.ra$diagram(DiagramGlassPane.this).scrollToVisible(component);
                    return true;
                }
            } else if (!this.isExtendSelectionEvent(e) && SwingUtilities.isLeftMouseButton(e)) {
                List selected;
                e.translatePoint(-DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), -DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                DiagramSchemaComponent component = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSchemaComponentAt(e.getPoint());
                e.translatePoint(DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                if (component != null && ((selected = manager.getSelectedComponents()).size() != 1 || selected.get(0) != component)) {
                    manager.select(component);
                    DiagramGlassPane.ra$diagram(DiagramGlassPane.this).scrollToVisible(component);
                    return true;
                }
            }
            return false;
        }

        private boolean isToggleSelectionEvent(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                return PlatformUtils.isMac() ? e.isShiftDown() : e.isControlDown();
            }
            return false;
        }

        private boolean isExtendSelectionEvent(MouseEvent e) {
            return !PlatformUtils.isMac() && SwingUtilities.isLeftMouseButton(e) && e.isShiftDown();
        }

        private DiagramComponent getComponentForEvent(MouseEvent e) {
            e.translatePoint(-DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), -DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
            DiagramComponent component = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getDiagramComponentAt(e.getPoint());
            e.translatePoint(DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
            return component;
        }

        private DiagramMouseHandler() {
        }

        DiagramMouseHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DiagramKeyHandler
    extends KeyAdapter {
        private boolean isZoomEvent(KeyEvent e) {
            return PlatformUtils.isMac() ? e.isShiftDown() : e.isControlDown();
        }

        public void keyPressed(KeyEvent e) {
            if (!DiagramGlassPane.ra$valid(DiagramGlassPane.this) || !DiagramGlassPane.ra$supported(DiagramGlassPane.this)) {
                return;
            }
            switch (e.getKeyCode()) {
                case 32: {
                    if (this.isZoomEvent(e)) {
                        if (e.isAltDown()) {
                            DiagramGlassPane.this.setMode(4);
                            e.consume();
                            break;
                        }
                        DiagramGlassPane.this.setMode(3);
                        e.consume();
                        break;
                    }
                    if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 2 || e.getModifiers() != 0) break;
                    DiagramGlassPane.this.setMode(1);
                    e.consume();
                    break;
                }
                case 18: {
                    if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) != 3) break;
                    DiagramGlassPane.this.setMode(4);
                    e.consume();
                    break;
                }
                case 107: {
                    DiagramComponent parent;
                    if (e.isControlDown()) {
                        DiagramGlassPane.ra$diagram(DiagramGlassPane.this).zoomIn(null);
                        e.consume();
                        break;
                    }
                    if (!e.isShiftDown()) break;
                    DiagramSchemaComponent active = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager().getActiveComponent();
                    if (active != null && (parent = active.getParent()) instanceof TopLevelComponent) {
                        ((TopLevelComponent)parent).getTree().setExpanded(true);
                    }
                    e.consume();
                    break;
                }
                case 109: {
                    DiagramComponent parent;
                    if (e.isControlDown()) {
                        DiagramGlassPane.ra$diagram(DiagramGlassPane.this).zoomOut(null);
                        e.consume();
                        break;
                    }
                    if (!e.isShiftDown()) break;
                    DiagramSchemaComponent active = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager().getActiveComponent();
                    if (active != null && (parent = active.getParent()) instanceof TopLevelComponent) {
                        ((TopLevelComponent)parent).getTree().setExpanded(false);
                    }
                    e.consume();
                    break;
                }
                case 106: {
                    DiagramComponent parent;
                    if (!e.isShiftDown()) break;
                    DiagramSchemaComponent active = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager().getActiveComponent();
                    if (active != null && (parent = active.getParent()) instanceof TopLevelComponent) {
                        ((TopLevelComponent)parent).getTree().expandAll();
                    }
                    e.consume();
                    break;
                }
                case 39: {
                    DiagramSelectionManager manager = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager();
                    DiagramSchemaComponent active = manager.getActiveComponent();
                    if (active == null || e.getModifiers() != 0 && !e.isControlDown() && !e.isShiftDown()) break;
                    Subtree subtree = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, active);
                    if (subtree != null) {
                        Subtree first = subtree.getFirstSubtree();
                        while (first != null && first instanceof ReferenceSubtree) {
                            first = first.getFirstSubtree();
                        }
                        if (first != null) {
                            if (!subtree.isExpanded()) {
                                subtree.setExpanded(true);
                            }
                            HierarchalSchemaComponent component = first.getRoot().getComponent();
                            if (e.isControlDown()) {
                                manager.activate(component);
                            } else if (!e.isShiftDown()) {
                                manager.select(component);
                            }
                            DiagramGlassPane.ra$diagram(DiagramGlassPane.this).scrollToVisible(first.getRoot());
                        }
                    }
                    e.consume();
                    break;
                }
                case 37: {
                    DiagramSelectionManager manager = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager();
                    DiagramSchemaComponent active = manager.getActiveComponent();
                    if (active == null || e.getModifiers() != 0 && !e.isControlDown() && !e.isShiftDown()) break;
                    Subtree subtree = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, active));
                    while (subtree != null && subtree instanceof ReferenceSubtree) {
                        subtree = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, subtree);
                    }
                    if (subtree != null) {
                        HierarchalSchemaComponent component = subtree.getRoot().getComponent();
                        if (e.isControlDown()) {
                            manager.activate(component);
                        } else if (!e.isShiftDown()) {
                            manager.select(component);
                        }
                        DiagramGlassPane.ra$diagram(DiagramGlassPane.this).scrollToVisible(subtree.getRoot());
                    }
                    e.consume();
                    break;
                }
                case 38: {
                    DiagramSelectionManager manager = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager();
                    DiagramSchemaComponent active = manager.getActiveComponent();
                    if (active == null || e.getModifiers() != 0 && !e.isControlDown() && !e.isShiftDown()) break;
                    Subtree current = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, active);
                    Subtree subtree = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, current);
                    if (subtree != null) {
                        Subtree previous = subtree.getPreviousSubtree(current);
                        while (previous == null && subtree instanceof ReferenceSubtree) {
                            current = subtree;
                            subtree = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, subtree);
                            previous = subtree.getNextSubtree(current);
                        }
                        while (previous != null && previous instanceof ReferenceSubtree) {
                            previous = previous.getFirstSubtree();
                        }
                        if (previous != null) {
                            if (!subtree.isExpanded()) {
                                subtree.setExpanded(true);
                            }
                            HierarchalSchemaComponent component = previous.getRoot().getComponent();
                            if (e.isControlDown()) {
                                manager.activate(component);
                            } else if (!e.isShiftDown()) {
                                manager.select(component);
                            }
                            DiagramGlassPane.ra$diagram(DiagramGlassPane.this).scrollToVisible(previous.getRoot());
                        }
                    }
                    e.consume();
                    break;
                }
                case 40: {
                    DiagramSelectionManager manager = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager();
                    DiagramSchemaComponent active = manager.getActiveComponent();
                    if (active == null || e.getModifiers() != 0 && !e.isControlDown() && !e.isShiftDown()) break;
                    Subtree current = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, active);
                    Subtree subtree = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, current);
                    if (subtree != null) {
                        Subtree next = subtree.getNextSubtree(current);
                        while (next == null && subtree instanceof ReferenceSubtree) {
                            current = subtree;
                            subtree = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, subtree);
                            next = subtree.getNextSubtree(current);
                        }
                        while (next != null && next instanceof ReferenceSubtree) {
                            next = next.getFirstSubtree();
                        }
                        if (next != null) {
                            if (!subtree.isExpanded()) {
                                subtree.setExpanded(true);
                            }
                            HierarchalSchemaComponent component = next.getRoot().getComponent();
                            if (e.isControlDown()) {
                                manager.activate(component);
                            } else if (!e.isShiftDown()) {
                                manager.select(component);
                            }
                            DiagramGlassPane.ra$diagram(DiagramGlassPane.this).scrollToVisible(next.getRoot());
                        }
                    }
                    e.consume();
                    break;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            if (!DiagramGlassPane.ra$valid(DiagramGlassPane.this) || !DiagramGlassPane.ra$supported(DiagramGlassPane.this)) {
                return;
            }
            switch (e.getKeyCode()) {
                case 32: {
                    if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 0) break;
                    DiagramGlassPane.this.setMode(0);
                    e.consume();
                    break;
                }
                case 18: {
                    if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) != 4) break;
                    DiagramGlassPane.this.setMode(3);
                    e.consume();
                    break;
                }
            }
        }

        private DiagramKeyHandler() {
        }

        DiagramKeyHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

