/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.ViewportLayout;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.swing.util.ActionUtils;
import oracle.jdevimpl.xml.schema.XmlSchemaDesignGui;
import oracle.jdevimpl.xml.schema.diagram.ComponentFactory;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramGlassPane;
import org.w3c.dom.Node;

public class DiagramPanel
extends JLayeredPane
implements Scrollable {
    private Diagram diagram;
    private XmlSchemaDesignGui gui;
    private DiagramGlassPane glassPane;
    private ComponentFactory factory;

    public DiagramPanel(XmlSchemaDesignGui gui, ComponentFactory factory) {
        this.gui = gui;
        this.factory = factory;
        this.setLayout(new DiagramPanelLayout(null));
        this.glassPane = new DiagramGlassPane();
        this.glassPane.setOpaque(false);
        this.add((Component)this.glassPane, JLayeredPane.MODAL_LAYER);
        this.glassPane.setVisible(true);
        this.setOpaque(true);
        this.glassPane.addFocusListener(new 1());
        String[] commands = new String[]{"cut", "copy", "paste", "clear", "customizeNode"};
        ActionUtils.addInputMappings((JComponent)this.glassPane, (String[])commands, (XmlGui)gui);
    }

    public void dispose() {
        this.removeAll();
        if (this.diagram != null) {
            this.diagram.dispose();
        }
        this.diagram = null;
        if (this.glassPane != null) {
            this.glassPane.dispose();
        }
        this.glassPane = null;
        if (this.getActionMap() != null) {
            this.getActionMap().clear();
        }
        this.gui = null;
    }

    public void addNotify() {
        super.addNotify();
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            ((JViewport)parent).setLayout(new DiagramViewportLayout(null));
        }
    }

    public void setValid(boolean valid) {
        this.glassPane.setValid(valid);
    }

    public void setSupported(boolean supported) {
        this.glassPane.setSupported(supported);
    }

    public void setDiagramRoot(Node node) {
        if (this.diagram != null) {
            this.remove(this.diagram);
        }
        this.diagram = new Diagram(node, this.gui, this.factory);
        this.glassPane.setDiagram(this.diagram);
        this.add((Component)this.diagram, JLayeredPane.DEFAULT_LAYER);
        this.setBackground(this.diagram.getBackground());
        if (this.glassPane.hasFocus()) {
            this.diagram.setFocused(true);
        }
        this.repaint();
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public DiagramGlassPane getGlassPane() {
        return this.glassPane;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.diagram != null) {
            return this.diagram.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return 0;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.diagram != null) {
            return this.diagram.getScrollableBlockIncrement(visibleRect, orientation, direction);
        }
        return 0;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.diagram != null) {
            return this.diagram.getScrollableTracksViewportWidth();
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.diagram != null) {
            return this.diagram.getScrollableTracksViewportWidth();
        }
        return false;
    }

    static Diagram ra$diagram(DiagramPanel diagramPanel) {
        return diagramPanel.diagram;
    }

    static DiagramGlassPane ra$glassPane(DiagramPanel diagramPanel) {
        return diagramPanel.glassPane;
    }

    final class 1
    extends FocusAdapter {
        public void focusGained(FocusEvent e) {
            if (DiagramPanel.ra$diagram(DiagramPanel.this) != null) {
                DiagramPanel.ra$diagram(DiagramPanel.this).setFocused(true);
            }
        }

        public void focusLost(FocusEvent e) {
            if (DiagramPanel.ra$glassPane(DiagramPanel.this) != null && !DiagramPanel.ra$glassPane(DiagramPanel.this).isAncestorOf(e.getOppositeComponent()) && DiagramPanel.ra$diagram(DiagramPanel.this) != null) {
                DiagramPanel.ra$diagram(DiagramPanel.this).setFocused(false);
            }
        }
    }

    private class DiagramPanelLayout
    implements LayoutManager2,
    Serializable {
        public Dimension preferredLayoutSize(Container parent) {
            if (DiagramPanel.ra$diagram(DiagramPanel.this) == null) {
                return new Dimension(0, 0);
            }
            Dimension diagramSize = DiagramPanel.ra$diagram(DiagramPanel.this).getPreferredSize();
            Insets i = DiagramPanel.this.getInsets();
            return new Dimension(diagramSize.width + i.left + i.right, diagramSize.height + i.top + i.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            if (DiagramPanel.ra$diagram(DiagramPanel.this) == null) {
                return new Dimension(0, 0);
            }
            Dimension diagramSize = DiagramPanel.ra$diagram(DiagramPanel.this).getMinimumSize();
            Insets i = DiagramPanel.this.getInsets();
            return new Dimension(diagramSize.width + i.left + i.right, diagramSize.height + i.top + i.bottom);
        }

        public Dimension maximumLayoutSize(Container target) {
            if (DiagramPanel.ra$diagram(DiagramPanel.this) == null) {
                return new Dimension(0, 0);
            }
            Dimension diagramSize = DiagramPanel.ra$diagram(DiagramPanel.this).getMaximumSize();
            Insets i = DiagramPanel.this.getInsets();
            return new Dimension(diagramSize.width + i.left + i.right, diagramSize.height + i.top + i.bottom);
        }

        public void layoutContainer(Container parent) {
            if (DiagramPanel.ra$diagram(DiagramPanel.this) != null) {
                Rectangle b = parent.getBounds();
                Insets i = DiagramPanel.this.getInsets();
                int w = b.width - i.right - i.left;
                int h = b.height - i.top - i.bottom;
                DiagramPanel.ra$glassPane(DiagramPanel.this).setBounds(i.left, i.top, w, h);
                Dimension diagramSize = DiagramPanel.ra$diagram(DiagramPanel.this).getPreferredSize();
                int y = i.top;
                w = Math.max(diagramSize.width, w);
                DiagramPanel.ra$diagram(DiagramPanel.this).setBounds(i.left, y, w, diagramSize.height);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }

        private DiagramPanelLayout() {
        }

        DiagramPanelLayout(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DiagramViewportLayout
    extends ViewportLayout {
        public void layoutContainer(Container parent) {
            JViewport viewport = (JViewport)parent;
            Component view = viewport.getView();
            if (view == null) {
                return;
            }
            Dimension viewPrefSize = view.getPreferredSize();
            Dimension viewportSize = viewport.getSize();
            Dimension viewSize = new Dimension();
            viewSize.width = Math.max(viewportSize.width, viewPrefSize.width);
            viewSize.height = Math.max(viewportSize.height, viewPrefSize.height);
            Point viewPosition = viewport.getViewPosition();
            Dimension extentSize = viewport.toViewCoordinates(viewportSize);
            if (viewPosition.x + extentSize.width > viewSize.width) {
                viewPosition.x = Math.max(0, Math.min(viewSize.width - extentSize.width, viewPosition.x));
            }
            if (viewPosition.y + extentSize.height > viewSize.height) {
                viewPosition.y = Math.max(0, viewSize.height - extentSize.height);
            }
            viewport.setViewPosition(viewPosition);
            viewport.setViewSize(viewSize);
        }

        private DiagramViewportLayout() {
        }

        DiagramViewportLayout(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

