/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.bali.xml.util.NodeCreator;
import oracle.bali.xml.util.NodeCustomizer;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.ide.controller.IdeAction;
import oracle.jdevimpl.xml.schema.NodeListener;
import oracle.jdevimpl.xml.schema.ProxyNode;
import oracle.jdevimpl.xml.schema.XmlSchemaEditorController;
import oracle.jdevimpl.xml.schema.XmlSchemaLayoutView;
import oracle.jdevimpl.xml.schema.XmlSchemaMetadataResolver;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.MouseAware;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DiagramSchemaComponent
extends DiagramComponent
implements MouseAware,
NodeListener {
    protected Element element;

    public DiagramSchemaComponent(Diagram diagram, Element element) {
        super(diagram);
        this.element = element;
        diagram.getView().addNodeListener(element, this);
        diagram.add(element, this);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.diagram.getSelectionManager().isActive(this) && this.diagram.isFocused()) {
            this.paintActiveBorder(g);
        }
    }

    public Color getForeground() {
        if (this.diagram.getSelectionManager().isSelected(this)) {
            return this.diagram.isFocused() ? GraphicsUtils.SELECTION_FOREGROUND_COLOR : GraphicsUtils.INACTIVE_SELECTION_FOREGROUND_COLOR;
        }
        return super.getForeground();
    }

    public Color getBackground() {
        if (this.diagram.getSelectionManager().isSelected(this)) {
            return this.diagram.isFocused() ? GraphicsUtils.SELECTION_BACKGROUND_COLOR : GraphicsUtils.INACTIVE_SELECTION_BACKGROUND_COLOR;
        }
        return super.getBackground();
    }

    public void paintActiveBorder(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        Shape shape = this.getShape();
        Color oldColor = graphics.getColor();
        Stroke oldStroke = graphics.getStroke();
        Stroke stroke = this.getStroke();
        if (stroke != null) {
            graphics.setStroke(stroke);
        }
        graphics.setXORMode(Color.GRAY);
        graphics.setColor(Color.BLACK);
        graphics.draw(shape);
        if (stroke != null) {
            graphics.setStroke(oldStroke);
        }
        graphics.setPaintMode();
        graphics.setColor(oldColor);
    }

    public Element getDomElement() {
        return this.element;
    }

    public void destroy() {
        super.destroy();
        this.diagram.getView().removeNodeListener(this.element, this);
        this.diagram.remove(this.element, this);
    }

    public void nodeChanged(Node node) {
        this.update();
    }

    public void update() {
    }

    public DomPosition getDomPosition(Point p) {
        DomPosition pos = super.getDomPosition(p);
        if (pos == null) {
            pos = DomPositionFactory.createDomPosition((Node)this.element, (int)0);
        }
        return pos;
    }

    public List getActions() {
        if (this.element instanceof ProxyNode) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(new Integer(XmlSchemaEditorController.EDIT_ANNOTATION_CMD_ID));
    }

    public boolean handleAction(IdeAction action) {
        if (action.getCommandId() == XmlSchemaEditorController.EDIT_ANNOTATION_CMD_ID) {
            boolean doCommit = false;
            XmlSchemaLayoutView view = this.diagram.getView();
            view.startTransaction(XmlSchemaArb.getString(31));
            try {
                XmlContext context = view.getContext();
                XmlSchemaMetadataResolver resolver = (XmlSchemaMetadataResolver)this.diagram.getView().getXmlMetadataResolver();
                Node annotation = ModelUtils.getChild(this.element, "annotation");
                if (annotation == null) {
                    XmlKey key = ImmutableXmlKey.createElementKey((String)"http://www.w3.org/2001/XMLSchema", (String)"annotation");
                    DomPosition position = ModelUtils.getAnnotationInsertionPosition(this.element);
                    NodeCreator creator = resolver.getCreationWizard(key);
                    if (creator != null && (annotation = XmlModelUtils.invokeCreator((NodeCreator)creator, (XmlContext)context, (XmlKey)key, (DomPosition)position, null)) != null) {
                        NamespaceUtils.fixPrefixes((Node)position.getContainerNode(), (Node)annotation, (DefaultPrefixLookup)this.diagram.getModel().getDefaultPrefixLookup());
                        if (position.isBefore()) {
                            this.element.insertBefore(annotation, position.getTargetNode());
                        } else {
                            this.element.appendChild(annotation);
                        }
                        doCommit = true;
                    }
                } else {
                    XmlKey key = resolver.getNodeXmlKey(annotation);
                    NodeCustomizer customizer = XmlModelUtils.getCustomizerOrDefault((AbstractModel)view, (XmlKey)key, (Node)annotation);
                    if (customizer != null && customizer.isNodeCustomizable(context, annotation, key)) {
                        doCommit = customizer.customizeNode(context, annotation, key);
                    }
                }
            }
            catch (RuntimeException re) {
                view.rollbackTransaction();
                throw re;
            }
            catch (ThreadDeath th) {
                view.rollbackTransaction();
                throw th;
            }
            catch (Throwable t) {
                view.rollbackTransaction();
                throw new IllegalStateException("unexpected throwable: " + t.getMessage());
            }
            if (doCommit) {
                try {
                    view.commitTransaction();
                }
                catch (XmlCommitException xce) {
                    view.rollbackTransaction();
                }
            } else {
                view.rollbackTransaction();
            }
            return true;
        }
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        return false;
    }

    public boolean mousePressed(MouseEvent e) {
        return false;
    }
}

