/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlView;
import oracle.jdevimpl.xml.schema.SelectionListener;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.Expandable;
import oracle.jdevimpl.xml.schema.diagram.Subtree;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DiagramSelectionManager
implements SelectionListener {
    private Diagram diagram;
    private DiagramSchemaComponent active;
    private LinkedList selected;

    private void $init$() {
        this.selected = new LinkedList();
    }

    public DiagramSelectionManager(Diagram diagram) {
        this.$init$();
        this.diagram = diagram;
        diagram.getView().addSelectionListener(this);
    }

    public void dispose() {
        this.diagram.getView().removeSelectionListener(this);
    }

    public DiagramSchemaComponent getActiveComponent() {
        return this.active;
    }

    public List getSelectedComponents() {
        return (List)this.selected.clone();
    }

    public DiagramSchemaComponent getFirstSelectedComponent() {
        return (DiagramSchemaComponent)this.selected.get(0);
    }

    public void selectionChanged() {
        List oldSelection = (List)this.selected.clone();
        DiagramSchemaComponent oldActive = this.active;
        this.active = null;
        this.selected.clear();
        Selection selection = this.diagram.getGui().getView().getSelection();
        selection.acquireModelReadLock();
        try {
            DomPosition cursorLocation = selection.getCursorLocation();
            this.active = cursorLocation != null && cursorLocation.isInside() ? this.getComponentForNode(cursorLocation.getTargetNode()) : null;
            Iterator iterator = selection.getSelectedNodes();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                DiagramSchemaComponent component = this.getComponentForNode(node);
                if (component == null) continue;
                this.selected.add(component);
            }
            this.repaint(oldSelection);
            if (oldActive != this.active) {
                if (oldActive != null) {
                    oldActive.repaint();
                }
                if (this.active != null) {
                    this.active.repaint();
                }
            }
            for (DiagramSchemaComponent component : this.selected) {
                Subtree subtree = this.getSubtree(component);
                if (subtree != null) {
                    this.expand(subtree);
                }
                component.repaint();
            }
            if (this.active != null) {
                this.diagram.scrollToVisible(this.active);
            }
        }
        finally {
            selection.releaseModelReadLock();
        }
    }

    public void add(DiagramSchemaComponent component) {
        if (component != null && !this.selected.contains(component)) {
            this.selected.add(component);
            component.repaint();
            XmlView view = this.diagram.getGui().getView();
            Selection selection = view.getSelection();
            view.startTransaction("");
            try {
                Element node = component.getDomElement();
                selection.add((Node)node);
                selection.setCursorLocation(DomPositionFactory.createDomPosition((Node)node, (int)0));
                view.commitTransaction();
            }
            catch (XmlCommitException xce) {
                view.rollbackTransaction();
            }
            catch (RuntimeException e) {
                view.rollbackTransaction();
                throw e;
            }
            catch (ThreadDeath td) {
                view.rollbackTransaction();
                throw td;
            }
            catch (Throwable t) {
                view.rollbackTransaction();
            }
        }
    }

    public void remove(DiagramSchemaComponent component) {
        if (component != null && this.selected.remove(component)) {
            component.repaint();
            XmlView view = this.diagram.getGui().getView();
            Selection selection = view.getSelection();
            view.startTransaction("");
            try {
                Element node = component.getDomElement();
                if (this.active == component) {
                    selection.setCursorLocation(null);
                }
                selection.remove((Node)node);
                view.commitTransaction();
            }
            catch (XmlCommitException xce) {
                view.rollbackTransaction();
            }
            catch (RuntimeException e) {
                view.rollbackTransaction();
                throw e;
            }
            catch (ThreadDeath td) {
                view.rollbackTransaction();
                throw td;
            }
            catch (Throwable t) {
                view.rollbackTransaction();
            }
        }
    }

    public void select(DiagramSchemaComponent component) {
        List oldSelection = (List)this.selected.clone();
        DiagramSchemaComponent oldActive = this.active;
        this.selected.clear();
        if (component != null) {
            this.selected.add(component);
        }
        this.active = component;
        if (oldActive != null) {
            oldActive.repaint();
        }
        this.repaint(oldSelection);
        if (component != null) {
            component.repaint();
            XmlView view = this.diagram.getGui().getView();
            Selection selection = view.getSelection();
            view.startTransaction("");
            try {
                Element node = component.getDomElement();
                selection.set((Node)node);
                selection.setCursorLocation(DomPositionFactory.createDomPosition((Node)node, (int)0));
                view.commitTransaction();
            }
            catch (XmlCommitException xce) {
                view.rollbackTransaction();
            }
            catch (RuntimeException e) {
                view.rollbackTransaction();
                throw e;
            }
            catch (ThreadDeath td) {
                view.rollbackTransaction();
                throw td;
            }
            catch (Throwable t) {
                view.rollbackTransaction();
            }
        }
    }

    public void activate(DiagramSchemaComponent component) {
        DiagramSchemaComponent oldActive = this.active;
        this.active = component;
        if (oldActive != null) {
            oldActive.repaint();
        }
        if (component != null) {
            component.repaint();
            XmlView view = this.diagram.getGui().getView();
            Selection selection = view.getSelection();
            view.startTransaction("");
            try {
                Element node = component.getDomElement();
                selection.setCursorLocation(DomPositionFactory.createDomPosition((Node)node, (int)0));
                view.commitTransaction();
            }
            catch (XmlCommitException xce) {
                view.rollbackTransaction();
            }
            catch (RuntimeException e) {
                view.rollbackTransaction();
                throw e;
            }
            catch (ThreadDeath td) {
                view.rollbackTransaction();
                throw td;
            }
            catch (Throwable t) {
                view.rollbackTransaction();
            }
        }
    }

    public boolean isActive(DiagramComponent component) {
        return component == this.active;
    }

    public boolean isSelected(DiagramComponent component) {
        for (DiagramSchemaComponent current : this.selected) {
            if (!this.isAncestor(current, component)) continue;
            return true;
        }
        return false;
    }

    private boolean isAncestor(DiagramComponent parent, DiagramComponent child) {
        DiagramComponent current = child;
        while (current != null) {
            if (current == parent) {
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    private void expand(DiagramComponent component) {
        DiagramComponent parent = component.getParent();
        while (parent != null && parent instanceof Expandable) {
            ((Expandable)((Object)parent)).setExpanded(true);
            parent = parent.getParent();
        }
    }

    private DiagramSchemaComponent getComponentForNode(Node node) {
        List list = this.diagram.getDiagramComponentsForNode(node);
        if (list != null) {
            return (DiagramSchemaComponent)list.get(0);
        }
        Stack<DiagramComponent> stack = new Stack<DiagramComponent>();
        DiagramSchemaComponent root = this.diagram.getRootComponent();
        if (root != null) {
            stack.push(root);
        }
        while (!stack.isEmpty()) {
            DiagramSchemaComponent schemaComponent;
            DiagramComponent component = (DiagramComponent)stack.pop();
            if (component instanceof DiagramSchemaComponent && (schemaComponent = (DiagramSchemaComponent)component).getDomElement().equals(node)) {
                return schemaComponent;
            }
            int i = component.getChildCount() - 1;
            while (i >= 0) {
                stack.push(component.getChild(i));
                --i;
            }
        }
        return null;
    }

    private Subtree getSubtree(DiagramComponent component) {
        DiagramComponent parent = component.getParent();
        while (parent != null) {
            if (parent instanceof Subtree) {
                return (Subtree)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private void repaint(List list) {
        for (DiagramSchemaComponent component : list) {
            component.repaint();
        }
    }
}

