/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramGlassPane;
import oracle.jdevimpl.xml.schema.diagram.DiagramPanel;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.MouseAware;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;

public class EditableTextComponent
extends TextComponent
implements MouseAware {
    private ArrayList listeners;
    protected EditorListener listener;
    protected boolean editable;
    protected JComponent editor;

    private void $init$() {
        this.listener = new EditorListener(null);
        this.editable = true;
    }

    public EditableTextComponent(Diagram diagram) {
        super(diagram);
        this.$init$();
    }

    public void addTextListener(TextListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeTextListener(TextListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public boolean mouseClicked(MouseEvent e) {
        return false;
    }

    public boolean mousePressed(MouseEvent e) {
        if (!e.isShiftDown() && !e.isControlDown() && SwingUtilities.isLeftMouseButton(e)) {
            DiagramSchemaComponent active = this.diagram.getSelectionManager().getActiveComponent();
            if (this.diagram.isFocused() && this.isAncestor(active)) {
                this.startEditing();
                return true;
            }
        }
        return false;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    protected void startEditing() {
        DiagramGlassPane glassPane;
        if (this.editable && (glassPane = this.getGlassPane()) != null) {
            this.editor = this.createEditor();
            float zoomFactor = this.diagram.getZoomFactor();
            AffineTransform tranform = AffineTransform.getScaleInstance(zoomFactor, zoomFactor);
            this.editor.setFont(this.getFont().deriveFont(tranform));
            glassPane.add(this.editor);
            this.editor.setBounds(this.getEditorBounds());
            this.editor.revalidate();
            this.diagram.setFocused(true);
            this.focusEditor();
        }
    }

    protected JComponent createEditor() {
        JTextField field = new JTextField(this.text);
        field.setBorder(BorderFactory.createEmptyBorder(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right));
        field.addActionListener(this.listener);
        field.addFocusListener(this.listener);
        field.addKeyListener(this.listener);
        field.setBackground(this.getBackground());
        field.setForeground(this.getForeground());
        return field;
    }

    protected void destroyEditor(JComponent editor) {
        ((JTextField)editor).removeActionListener(this.listener);
        editor.removeFocusListener(this.listener);
        editor.removeKeyListener(this.listener);
    }

    protected String getEditorValue() {
        return ((JTextField)this.editor).getText();
    }

    protected void focusEditor() {
        this.editor.requestFocus();
    }

    protected void stopEditing() {
        if (this.editor != null) {
            this.destroyEditor(this.editor);
            this.text = this.getEditorValue();
            this.invalidate();
            this.diagram.revalidate();
            DiagramGlassPane glassPane = this.getGlassPane();
            glassPane.remove(this.editor);
            glassPane.repaint();
            this.editor = null;
            this.fireTextChanged();
        }
    }

    protected void cancelEditing() {
        if (this.editor != null) {
            this.destroyEditor(this.editor);
            DiagramGlassPane glassPane = this.getGlassPane();
            glassPane.remove(this.editor);
            glassPane.repaint();
            this.editor = null;
        }
    }

    protected Rectangle getEditorBounds() {
        Rectangle bounds = this.getBounds(null);
        DiagramComponent parent = this.getParent();
        while (parent != null) {
            bounds.x += parent.getX();
            bounds.y += parent.getY();
            parent = parent.getParent();
        }
        float zoomFactor = this.diagram.getZoomFactor();
        bounds.x = (int)((float)bounds.x * zoomFactor);
        bounds.y = (int)((float)bounds.y * zoomFactor);
        bounds.width = (int)((float)bounds.width * zoomFactor);
        bounds.height = (int)((float)bounds.height * zoomFactor);
        bounds.x += this.diagram.getX();
        bounds.y += this.diagram.getY();
        return bounds;
    }

    protected void fireTextChanged() {
        if (this.listeners != null) {
            for (TextListener listener : (List)this.listeners.clone()) {
                listener.textValueChanged(new TextEvent(this, 900));
            }
        }
    }

    protected DiagramGlassPane getGlassPane() {
        DiagramGlassPane glassPane = null;
        Container component = this.diagram.getParent();
        if (component instanceof DiagramPanel) {
            glassPane = ((DiagramPanel)component).getGlassPane();
        }
        return glassPane;
    }

    private boolean isAncestor(DiagramComponent component) {
        DiagramComponent parent = this.getParent();
        while (parent != null && !(parent instanceof DiagramSchemaComponent)) {
            parent = parent.getParent();
        }
        return parent != null && parent == component;
    }

    private class EditorListener
    implements ActionListener,
    FocusListener,
    KeyListener {
        public void actionPerformed(ActionEvent ae) {
            EditableTextComponent.this.stopEditing();
            if (EditableTextComponent.this.editor == null) {
                EditableTextComponent.this.getGlassPane().requestFocus();
            }
        }

        public void focusLost(FocusEvent fe) {
            DiagramGlassPane glassPane = EditableTextComponent.this.getGlassPane();
            if (glassPane == null) {
                if (EditableTextComponent.this.editor != null) {
                    EditableTextComponent.this.destroyEditor(EditableTextComponent.this.editor);
                }
            } else {
                EditableTextComponent.this.stopEditing();
                if (EditableTextComponent.this.editor == null && !glassPane.isAncestorOf(fe.getOppositeComponent())) {
                    EditableTextComponent.this.diagram.setFocused(false);
                }
            }
        }

        public void keyPressed(KeyEvent ke) {
            if (ke.getKeyCode() == 27) {
                EditableTextComponent.this.cancelEditing();
                EditableTextComponent.this.getGlassPane().requestFocus();
                ke.consume();
            }
        }

        public void focusGained(FocusEvent fe) {
        }

        public void keyReleased(KeyEvent ke) {
        }

        public void keyTyped(KeyEvent ke) {
        }

        private EditorListener() {
        }

        EditorListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

