/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.xml.schema.ProxyElement;
import oracle.jdevimpl.xml.schema.ProxyNode;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaEditorController;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.diagram.AttrEditor;
import oracle.jdevimpl.xml.schema.diagram.AttributeContainer;
import oracle.jdevimpl.xml.schema.diagram.DerivationEditor;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.EditableTextComponent;
import oracle.jdevimpl.xml.schema.diagram.FacetContainer;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ImageComponent;
import oracle.jdevimpl.xml.schema.diagram.ListChangeListener;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.TypeEditor;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementDeclaration
extends HierarchalSchemaComponent
implements ListChangeListener {
    private EditableTextComponent name;
    private DerivationEditor derivation;
    private AttributeContainer attributes;
    private FacetContainer facets;
    private ImageComponent image;
    private TypeEditor type;
    private Element referee;
    private static final int MINIMUM_WIDTH = 60;
    private static final int MAXIMUM_WIDTH = 300;
    private static final Color COLOR = new Color(51, 102, 153);

    public ElementDeclaration(Diagram diagram, Element element) {
        super(diagram, element);
        this.setBackground(COLOR);
        this.setForeground(Color.WHITE);
        this.derivation = new DerivationEditor(diagram, 7);
        this.derivation.addListChangeListener(this);
        this.derivation.setInsets(new Insets(0, 5, 2, 5));
        this.add(this.derivation);
        this.attributes = new AttributeContainer(diagram, element);
        this.add(this.attributes);
        this.facets = new FacetContainer(diagram, element);
        this.facets.setForeground(Color.BLACK);
        this.add(this.facets);
        this.type = new TypeEditor(diagram, element, 4);
        this.type.setInsets(new Insets(0, 0, 2, 5));
        this.type.addListChangeListener(this);
        this.add(this.type);
        this.update();
    }

    public void destroy() {
        super.destroy();
        this.type.removeListChangeListener(this);
        if (this.name != null && this.name instanceof TypeEditor) {
            ((TypeEditor)this.name).removeListChangeListener(this);
            this.derivation.removeListChangeListener(this);
        }
    }

    public int getPreferredWidth() {
        int width = 0;
        if (this.name != null) {
            width = this.name.getPreferredWidth();
        }
        width = this.image != null ? (width += this.image.getPreferredWidth()) : (width += 5);
        width = Math.max(width, this.derivation.getPreferredWidth() + this.type.getPreferredWidth());
        width = Math.max(width, this.attributes.getPreferredWidth());
        width = Math.max(width, this.facets.getPreferredWidth());
        width += this.insets.left + this.insets.right;
        width = Math.max(width, 60);
        width = Math.min(width, 300);
        return width;
    }

    public int getPreferredHeight() {
        int typeHeight;
        int nameHeight;
        int attHeight = this.attributes.getPreferredHeight();
        int facetHeight = this.facets.getPreferredHeight();
        int n = nameHeight = this.name != null ? this.name.getPreferredHeight() : 0;
        if (this.image != null) {
            nameHeight = Math.max(nameHeight, this.image.getPreferredHeight());
        }
        if ((typeHeight = this.type.getPreferredHeight()) == 0) {
            typeHeight = 2;
        }
        int derivationHeight = this.derivation.getPreferredHeight();
        return nameHeight + attHeight + facetHeight + Math.max(typeHeight, derivationHeight) + this.insets.top + this.insets.bottom + (attHeight > 0 || facetHeight > 0 ? 1 : 0);
    }

    public void layout() {
        int nameHeight;
        int w;
        int nameWidth = w = this.width - this.insets.left - this.insets.right;
        if (this.image != null) {
            int height = this.name == null ? this.image.getPreferredHeight() : Math.max(this.image.getPreferredHeight(), this.name.getPreferredHeight());
            this.image.setBounds(this.insets.left + w - this.image.getPreferredWidth(), this.insets.top, this.image.getPreferredWidth(), height);
            nameWidth -= this.image.getWidth();
        } else {
            nameWidth -= 5;
        }
        int y = this.insets.top;
        if (this.name != null) {
            this.name.setBounds(this.insets.left, this.insets.top, nameWidth, this.name.getPreferredHeight());
        }
        int n = nameHeight = this.name != null ? this.name.getHeight() : 0;
        if (this.image != null) {
            nameHeight = Math.max(nameHeight, this.image.getHeight());
        }
        this.derivation.setBounds(this.insets.left, y += nameHeight, this.derivation.getPreferredWidth(), this.derivation.getPreferredHeight());
        this.type.setBounds(this.insets.left + this.derivation.getWidth(), y, w - this.derivation.getWidth(), this.type.getPreferredHeight());
        int typeHeight = Math.max(this.type.getHeight(), this.derivation.getHeight());
        y += typeHeight > 0 ? typeHeight : 2;
        this.attributes.setBounds(this.insets.left, ++y, w, this.attributes.getPreferredHeight());
        this.facets.setBounds(this.insets.left, y += this.attributes.getHeight(), w, this.facets.getPreferredHeight());
    }

    public Shape getShape() {
        int width = this.getWidth();
        int height = this.getHeight();
        int[] xpoints = new int[]{1, width - 2, width - 1, width - 1, width - 2, 1, 0, 0, 1};
        int[] ypoints = new int[]{0, 0, 1, height - 2, height - 1, height - 1, height - 2, 1, 0};
        return new Polygon(xpoints, ypoints, xpoints.length);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.attributes.getHeight() > 0 || this.facets.getHeight() > 0) {
            int y = this.insets.top + this.type.getHeight();
            if (this.image != null && this.name != null) {
                y += Math.max(this.name.getHeight(), this.image.getHeight());
            } else if (this.image != null) {
                y += this.image.getHeight();
            } else if (this.name != null) {
                y += this.name.getHeight();
            }
            if (this.type.getHeight() == 0) {
                y += 2;
            }
            g.drawLine(this.insets.left, y, this.width - 1, y);
        }
    }

    public void update() {
        super.update();
        if (this.name != null) {
            if (this.name instanceof TypeEditor) {
                ((TypeEditor)this.name).removeListChangeListener(this);
            }
            this.remove(this.name);
            this.name = null;
        }
        if (this.image != null) {
            this.remove(this.image);
            this.image = null;
        }
        this.referee = null;
        this.diagram.getView().acquireReadLock();
        try {
            Attr attr;
            TreeTraversal traversal = this.diagram.getView().getTreeTraversal();
            Node child = traversal.getFirstChild((Node)this.element);
            if (child instanceof ReferenceNode) {
                ReferenceNode reference = (ReferenceNode)((Object)child);
                int refType = reference.getReference().getReferenceType();
                this.derivation.setValueFromReferenceType(refType);
                if (refType == 1) {
                    this.name = new TypeEditor(this.diagram, this.element, 1);
                    ((TypeEditor)this.name).addListChangeListener(this);
                    ((TypeEditor)this.name).setReference(reference);
                    this.name.setInsets(new Insets(3, 5, 0, 0));
                    this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
                    this.add(this.name);
                    this.image = new ImageComponent(this.diagram, XmlSchemaArb.getInstance(), 58);
                    this.image.setInsets(new Insets(2, 3, 0, 5));
                    this.add(this.image);
                    this.referee = (Element)reference.getReferee();
                    reference = null;
                    if (this.referee != null && (child = traversal.getFirstChild((Node)this.referee)) instanceof ReferenceNode) {
                        reference = (ReferenceNode)((Object)child);
                        refType = reference.getReference().getReferenceType();
                    }
                }
                this.type.setReference(reference);
                if (reference != null) {
                    refType = reference.getReference().getReferenceType();
                    this.derivation.setValueFromReferenceType(refType);
                } else {
                    this.derivation.setValue(0);
                }
            } else {
                this.derivation.setValue(0);
                this.type.setReference(null);
            }
            if (this.name == null && (attr = this.element.getAttributeNodeNS(null, "name")) != null) {
                this.name = new AttrEditor(this.diagram, attr);
                this.name.setInsets(new Insets(3, 5, 0, 5));
                this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
                this.add(this.name);
            }
            Element target = this.referee != null ? this.referee : this.element;
            boolean editable = (target instanceof ProxyElement && ((ProxyElement)target).isExternal()) ^ true;
            this.derivation.setEditable(editable);
            this.type.setEditable(editable);
            if (this.name != null) {
                this.name.setEditable(editable);
            }
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    public List getActions() {
        ArrayList<Integer> list = new ArrayList<Integer>(3);
        list.addAll(super.getActions());
        this.diagram.getView().acquireReadLock();
        try {
            if (!(this.element instanceof ProxyElement) || !((ProxyElement)this.element).isExternal()) {
                TreeTraversal traversal;
                Node child;
                if (!ModelUtils.isGlobal(this.element)) {
                    list.add(new Integer(XmlSchemaEditorController.TOGGLE_REFERENCE_CMD_ID));
                }
                if (!((child = (traversal = this.diagram.getView().getTreeTraversal()).getFirstChild((Node)this.element)) instanceof ReferenceNode) && ModelUtils.getAnonymousType(this.element) == null) {
                    list.add(new Integer(XmlSchemaEditorController.SET_TYPE_CMD_ID));
                }
            }
            ArrayList<Integer> arrayList = list;
            return arrayList;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    public boolean handleAction(IdeAction action) {
        int id = action.getCommandId();
        if (id == XmlSchemaEditorController.TOGGLE_REFERENCE_CMD_ID) {
            this.toggleReference();
            return true;
        }
        if (id == XmlSchemaEditorController.SET_TYPE_CMD_ID) {
            this.setType();
            return true;
        }
        return super.handleAction(action);
    }

    public void valueChanged(ListComponent component) {
        if (component == this.type) {
            this.handleTypeChange();
        } else if (component == this.name) {
            this.handleNameChange();
        } else if (component == this.derivation) {
            this.handleDerivationChange();
        }
    }

    private void handleTypeChange() {
        this.diagram.getModel().startTransaction(XmlSchemaArb.getString(28));
        try {
            if (this.type.getText() == null || this.type.getText().trim().length() == 0) {
                this.removeType();
            } else {
                this.changeType();
            }
            this.diagram.getModel().commitTransaction();
        }
        catch (XmlCommitException xce) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
        }
        catch (ThreadDeath td) {
            this.diagram.getModel().rollbackTransaction();
            throw td;
        }
        catch (Throwable t) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)t);
        }
    }

    private void handleNameChange() {
        String value = this.name.getText().trim();
        this.diagram.getModel().startTransaction(XmlSchemaArb.getString(22));
        try {
            Attr attr = ((TypeEditor)this.name).getAttr();
            attr.setValue(value);
            this.diagram.getModel().commitTransaction();
        }
        catch (XmlCommitException xce) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
        }
        catch (ThreadDeath td) {
            this.diagram.getModel().rollbackTransaction();
            throw td;
        }
        catch (Throwable t) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)t);
        }
    }

    private void handleDerivationChange() {
        this.diagram.getModel().startTransaction(XmlSchemaArb.getString(5));
        try {
            this.changeType();
            this.diagram.getModel().commitTransaction();
        }
        catch (XmlCommitException xce) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
        }
        catch (ThreadDeath td) {
            this.diagram.getModel().rollbackTransaction();
            throw td;
        }
        catch (Throwable t) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)t);
        }
    }

    private void removeType() {
        Attr attr = this.type.getAttr();
        Element owner = attr.getOwnerElement();
        if (owner != null) {
            this.diagram.getModel().startTransaction(XmlSchemaArb.getString(28));
            try {
                Element target;
                owner.removeAttributeNode(attr);
                Element element = target = this.referee != null ? this.referee : this.element;
                if (owner != target) {
                    ModelUtils.removePath(target, owner);
                }
                this.diagram.getModel().commitTransaction();
            }
            catch (XmlCommitException xce) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
            }
            catch (ThreadDeath td) {
                this.diagram.getModel().rollbackTransaction();
                throw td;
            }
            catch (Throwable t) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)t);
            }
        } else {
            this.type.setAttr(null);
        }
    }

    private void changeType() {
        XmlSchemaModel model = this.diagram.getModel();
        int value = this.derivation.getValue();
        String base = this.type.getText();
        Element target = this.referee != null ? this.referee : this.element;
        ModelUtils.removeContent(target);
        if (value == 1 || value == 0) {
            target.setAttributeNS(null, "type", base);
        } else if (value == 2) {
            ModelUtils.createAnonymousComplexTypeWithExtension(model, target, base);
        } else if (value == 4) {
            if (ModelUtils.isSimpleType(model, target, base)) {
                ModelUtils.createAnonymousSimpleType(model, target, base);
            } else {
                ModelUtils.createAnonymousComplexTypeWithRestriction(model, target, base);
            }
        }
    }

    private void toggleReference() {
        Node node = this.element;
        if (node instanceof ProxyNode) {
            node = ((ProxyNode)node).getReferee();
        }
        XmlModel model = this.diagram.getGui().getView().getBaseModel();
        model.startTransaction(XmlSchemaArb.getString(48));
        try {
            ModelUtils.toggleReference(node);
            model.commitTransaction();
        }
        catch (ThreadDeath td) {
            this.diagram.getModel().rollbackTransaction();
            throw td;
        }
        catch (Throwable t) {
            this.diagram.getModel().rollbackTransaction();
        }
    }

    private void setType() {
        this.diagram.getView().acquireReadLock();
        try {
            Attr attr = this.diagram.getView().getDocument().createAttributeNS(null, "type");
            this.type.setAttr(attr);
            this.type.startEditing();
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }
}

