/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.Expandable;
import oracle.jdevimpl.xml.schema.diagram.MouseAware;

public class Expander
extends DiagramComponent
implements MouseAware {
    private Expandable expandable;

    public Expander(Diagram diagram) {
        this(diagram, null);
        this.setShowBorder(true);
    }

    public Expander(Diagram diagram, Expandable expandable) {
        super(diagram);
        this.setShowBorder(true);
        this.setExpandable(expandable);
    }

    public void setExpandable(Expandable expandable) {
        this.expandable = expandable;
    }

    public int getPreferredWidth() {
        return 11;
    }

    public int getPreferredHeight() {
        return 11;
    }

    public Color getBackground() {
        return Color.WHITE;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        Color oldColor = g.getColor();
        g.setColor(Color.BLACK);
        g.drawLine(2, height / 2, width - 3, height / 2);
        if (!this.expandable.isExpanded()) {
            g.drawLine(width / 2, 2, width / 2, height - 3);
        }
        g.setColor(oldColor);
    }

    public Shape getShape() {
        int[] xpoints = new int[]{1, this.width - 2, this.width - 1, this.width - 1, this.width - 2, 1, 0, 0, 1};
        int[] ypoints = new int[]{0, 0, 1, this.height - 2, this.height - 1, this.height - 1, this.height - 2, 1, 0};
        return new Polygon(xpoints, ypoints, xpoints.length);
    }

    public boolean mouseClicked(MouseEvent e) {
        return false;
    }

    public boolean mousePressed(MouseEvent e) {
        if (this.expandable != null) {
            this.expandable.setExpanded(this.expandable.isExpanded() ^ true);
            this.repaint();
            return true;
        }
        return false;
    }
}

