/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import oracle.jdevimpl.xml.schema.ProxyElement;
import oracle.jdevimpl.xml.schema.diagram.AttrEditor;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.FacetContainer;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import org.w3c.dom.Element;

public class Facet
extends DiagramSchemaComponent {
    private TextComponent label;
    private AttrEditor value;

    public Facet(Diagram diagram, Element element) {
        super(diagram, element);
        this.setBackground(Color.WHITE);
        this.label = new TextComponent(diagram);
        this.label.setText(element.getLocalName());
        this.label.setInsets(new Insets(1, 5, 1, 3));
        this.add(this.label);
        this.value = new AttrEditor(diagram);
        this.value.setInsets(new Insets(1, 3, 1, 5));
        this.add(this.value);
        this.update();
    }

    public TextComponent getLabel() {
        return this.label;
    }

    public void update() {
        this.value.setAttr(this.element.getAttributeNodeNS(null, "value"));
        boolean editable = (this.element instanceof ProxyElement && ((ProxyElement)this.element).isExternal()) ^ true;
        this.value.setEditable(editable);
    }

    public int getPreferredWidth() {
        return this.insets.left + this.insets.right + ((FacetContainer)this.parent).getLabelWidth() + this.value.getPreferredWidth() + 1;
    }

    public int getPreferredHeight() {
        return this.insets.top + this.insets.bottom + Math.max(this.label.getPreferredHeight(), this.value.getPreferredHeight());
    }

    public void layout() {
        int w = this.width - this.insets.left - this.insets.right;
        int labelWidth = ((FacetContainer)this.parent).getLabelWidth();
        this.label.setBounds(this.insets.left, this.insets.top, labelWidth, this.height);
        this.value.setBounds(this.insets.left + labelWidth + 1, this.insets.top, w - labelWidth - 1, this.height);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        g.setColor(Color.BLACK);
        int x = this.insets.left + this.label.getWidth();
        g.drawLine(x, 0, x, this.height - 1);
        g.setColor(oldColor);
    }
}

