/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.jdevimpl.xml.schema.NodeListener;
import oracle.jdevimpl.xml.schema.XmlSchemaMetadataResolver;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.Facet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FacetContainer
extends DiagramComponent
implements NodeListener {
    private Element element;
    private Node parentNode;
    private int labelWidth;

    private void $init$() {
        this.labelWidth = -1;
    }

    public FacetContainer(Diagram diagram, Element element) {
        super(diagram);
        this.$init$();
        this.element = element;
        diagram.getView().acquireReadLock();
        try {
            XmlSchemaMetadataResolver resolver = (XmlSchemaMetadataResolver)diagram.getView().getXmlMetadataResolver();
            int role = resolver.getSchemaRole(element);
            if (role == 15 || role == 21) {
                this.parentNode = diagram.getView().getTreeTraversal().getParentNode((Node)element);
                diagram.getView().addNodeListener(this.parentNode, this);
            } else {
                diagram.getView().addNodeListener(element, this);
            }
        }
        finally {
            diagram.getView().releaseReadLock();
        }
        this.update();
    }

    public void nodeChanged(Node node) {
        this.update();
    }

    public void invalidate() {
        super.invalidate();
        this.labelWidth = -1;
    }

    public void update() {
        this.destroyAll();
        if (this.element != null) {
            this.diagram.getView().acquireReadLock();
            try {
                TreeTraversal traversal = this.diagram.getView().getTreeTraversal();
                XmlSchemaMetadataResolver resolver = (XmlSchemaMetadataResolver)this.diagram.getView().getXmlMetadataResolver();
                Node child = this.parentNode != null ? traversal.getFirstChild(this.parentNode) : traversal.getFirstChild((Node)this.element);
                while (child != null) {
                    DiagramSchemaComponent facet;
                    int role = resolver.getSchemaRole(child);
                    if (this.parentNode == null) {
                        if (role == 15) break;
                        if (role == 21) {
                            break;
                        }
                    }
                    if (role == 11 && (facet = this.createFacetComponent(child)) != null) {
                        this.add(facet);
                    }
                    child = traversal.getNextSibling(child);
                }
            }
            finally {
                this.diagram.getView().releaseReadLock();
            }
        }
    }

    public void destroy() {
        if (this.parentNode != null) {
            this.diagram.getView().removeNodeListener(this.parentNode, this);
        } else {
            this.diagram.getView().removeNodeListener(this.element, this);
        }
        this.element = null;
        super.destroy();
    }

    public int getPreferredWidth() {
        if (this.numChildren > 0) {
            int width = 0;
            int i = 0;
            while (i < this.numChildren) {
                width = Math.max(width, this.children[i].getPreferredWidth());
                ++i;
            }
            return width + this.insets.left + this.insets.right;
        }
        return 0;
    }

    public int getPreferredHeight() {
        if (this.numChildren > 0) {
            int height = this.insets.top + this.insets.bottom;
            if (this.children != null) {
                int i = 0;
                while (i < this.numChildren) {
                    height += this.children[i].getPreferredHeight();
                    if (i < this.numChildren - 1) {
                        ++height;
                    }
                    ++i;
                }
            }
            return height;
        }
        return 0;
    }

    public void layout() {
        if (this.children != null) {
            int y = this.insets.top;
            int i = 0;
            while (i < this.numChildren) {
                this.children[i].setBounds(this.insets.left, y, this.width - this.insets.left - this.insets.right, this.children[i].getPreferredHeight());
                y += this.children[i].getHeight() + 1;
                ++i;
            }
        }
    }

    public DomPosition getDomPosition(Point p) {
        DomPosition pos = null;
        Rectangle bounds = new Rectangle();
        int i = 0;
        while (pos == null && i < this.numChildren) {
            bounds = this.children[i].getBounds(bounds);
            if (p.getY() < bounds.getY() + bounds.getHeight() / 2.0) {
                pos = DomPositionFactory.createDomPosition((Node)((DiagramSchemaComponent)this.children[i]).getDomElement(), (int)1);
            } else if (p.getY() < bounds.getY() + bounds.getHeight()) {
                pos = DomPositionFactory.createDomPosition((Node)((DiagramSchemaComponent)this.children[i]).getDomElement(), (int)2);
            }
            ++i;
        }
        return pos;
    }

    public Shape getDomPositionShape(DiagramComponent component, int relativePosition) {
        Shape shape = null;
        if (relativePosition == 1) {
            Rectangle bounds = component.getBounds(null);
            return new Line2D.Double(bounds.getX(), bounds.getY(), bounds.getX() + bounds.getWidth(), bounds.getY());
        }
        if (relativePosition == 2) {
            Rectangle bounds = component.getBounds(null);
            return new Line2D.Double(bounds.getX(), bounds.getY() + bounds.getHeight(), bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
        }
        shape = super.getDomPositionShape(component, relativePosition);
        return shape;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        g.setColor(Color.BLACK);
        int i = 0;
        while (i < this.numChildren - 1) {
            int y = this.children[i].getY() + this.children[i].getHeight();
            g.drawLine(this.insets.left, y, this.width - this.insets.right, y);
            ++i;
        }
        g.setColor(oldColor);
    }

    public int getLabelWidth() {
        if (this.labelWidth == -1) {
            this.computeLabelWidth();
        }
        return this.labelWidth;
    }

    private void computeLabelWidth() {
        this.labelWidth = 0;
        int i = 0;
        while (i < this.numChildren) {
            Facet facet = (Facet)this.children[i];
            this.labelWidth = Math.max(facet.getLabel().getPreferredWidth(), this.labelWidth);
            ++i;
        }
    }

    private DiagramSchemaComponent createFacetComponent(Node node) {
        return new Facet(this.diagram, (Element)node);
    }

    private void destroyAll() {
        int i = 0;
        while (i < this.numChildren) {
            Element element = ((DiagramSchemaComponent)this.children[i]).getDomElement();
            this.children[i].setParent(null);
            this.children[i].destroy();
            ++i;
        }
        this.numChildren = 0;
    }
}

