/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Graphics;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.Row;

public class Grid
extends DiagramComponent {
    private Row[] rows;

    private void $init$() {
        this.rows = new Row[0];
    }

    public Grid(Diagram diagram) {
        super(diagram);
        this.$init$();
    }

    public void addRow(Row row) {
        Row[] oldRows = this.rows;
        this.rows = new Row[this.rows.length + 1];
        System.arraycopy(oldRows, 0, this.rows, 0, this.rows.length - 1);
        this.rows[this.rows.length - 1] = row;
        int i = 0;
        while (i < row.getColumnCount()) {
            this.add(row.getColumn(i));
            ++i;
        }
    }

    public void removeRow(Row row) {
        int i = 0;
        while (i < this.rows.length) {
            if (row == this.rows[i]) {
                Row[] oldRows = this.rows;
                this.rows = new Row[this.rows.length - 1];
                System.arraycopy(oldRows, 0, this.rows, 0, i);
                System.arraycopy(oldRows, i + 1, this.rows, i, oldRows.length - i - 1);
                return;
            }
            ++i;
        }
    }

    public void removeAllRows() {
        int r = 0;
        while (r < this.rows.length) {
            Row row = this.rows[r];
            int i = 0;
            while (i < row.getColumnCount()) {
                this.remove(row.getColumn(i));
                ++i;
            }
            this.rows[r] = null;
            ++r;
        }
        this.rows = new Row[0];
    }

    public int getPreferredWidth() {
        int firstColumnWidth = 0;
        int r = 0;
        while (r < this.rows.length) {
            firstColumnWidth = Math.max(firstColumnWidth, this.rows[r].getColumn(0).getPreferredWidth());
            ++r;
        }
        int width = 0;
        int r2 = 0;
        while (r2 < this.rows.length) {
            Row row = this.rows[r2];
            int rowWidth = firstColumnWidth;
            int c = 1;
            while (c < row.getColumnCount()) {
                rowWidth += row.getColumn(c).getPreferredWidth();
                ++c;
            }
            if (row.getColumnCount() > 0) {
                rowWidth += row.getColumnCount() - 1;
            }
            width = Math.max(width, rowWidth);
            ++r2;
        }
        return width;
    }

    public int getPreferredHeight() {
        if (this.rows.length == 0) {
            return 0;
        }
        int height = 0;
        int r = 0;
        while (r < this.rows.length) {
            height += this.rows[r].getRowHeight();
            ++r;
        }
        return height + this.rows.length - 1;
    }

    public void layout() {
        int firstColumnWidth = 0;
        int r = 0;
        while (r < this.rows.length) {
            firstColumnWidth = Math.max(firstColumnWidth, this.rows[r].getColumn(0).getPreferredWidth());
            ++r;
        }
        firstColumnWidth = Math.min(this.width, firstColumnWidth);
        int y = 0;
        int r2 = 0;
        while (r2 < this.rows.length) {
            Row row = this.rows[r2];
            int columnWidth = row.getColumnCount() > 1 ? (this.width - firstColumnWidth - row.getColumnCount() + 1) / (row.getColumnCount() - 1) : 0;
            int x = 0;
            int rowHeight = row.getRowHeight();
            int c = 0;
            while (c < row.getColumnCount()) {
                DiagramComponent component = row.getColumn(c);
                int width = c == 0 ? firstColumnWidth : columnWidth;
                component.setBounds(x, y, width, rowHeight);
                x += width + 1;
                ++c;
            }
            y += rowHeight + 1;
            ++r2;
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int y = 0;
        int r = 0;
        while (r < this.rows.length) {
            Row row = this.rows[r];
            int rowHeight = row.getRowHeight();
            int c = 0;
            while (c < row.getColumnCount() - 1) {
                DiagramComponent column = row.getColumn(c);
                int x = column.getX() + column.getWidth();
                g.drawLine(x, y, x, y + rowHeight);
                ++c;
            }
            y += rowHeight;
            if (r < this.rows.length - 1) {
                g.drawLine(0, y, this.width, y);
            }
            ++y;
            ++r;
        }
    }

    public int getRowCount() {
        return this.rows.length;
    }
}

