/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.ImageComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelGroup;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Element;

public class IconicModelGroup
extends ModelGroup {
    private ImageComponent image;

    public IconicModelGroup(Diagram diagram, Element element) {
        super(diagram, element);
        this.setExpandable(false);
        String name = element.getLocalName();
        int key = -1;
        if ("sequence".equals(name)) {
            key = 53;
        } else if ("choice".equals(name)) {
            key = 36;
        } else if ("all".equals(name)) {
            key = 4;
        }
        if (key > 0) {
            this.image = new ImageComponent(diagram, XmlSchemaArb.getInstance(), key);
            this.add(this.image);
        }
        this.update();
    }

    public int getPreferredWidth() {
        int width = 0;
        if (this.image != null) {
            width = this.image.getPreferredWidth() + 10;
        }
        return width;
    }

    public int getPreferredHeight() {
        int height = 0;
        if (this.image != null) {
            height = this.image.getPreferredHeight() + 4;
        }
        return height;
    }

    public void layout() {
        super.layout();
        if (this.image != null) {
            this.image.setBounds(5, 2, this.image.getPreferredWidth(), this.height - 4);
        }
    }
}

