/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import oracle.ide.util.ArrayResourceBundle;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;

public class ImageComponent
extends DiagramComponent {
    protected ArrayResourceBundle bundle;
    protected int key;
    protected Image image;

    public ImageComponent(Diagram diagram) {
        super(diagram);
    }

    public ImageComponent(Diagram diagram, ArrayResourceBundle bundle, int key) {
        super(diagram);
        this.bundle = bundle;
        this.key = key;
    }

    public void setImage(ArrayResourceBundle bundle, int key) {
        this.bundle = bundle;
        this.key = key;
        this.image = null;
        this.invalidate();
        this.repaint();
    }

    public int getPreferredWidth() {
        int width = this.insets.left + this.insets.right;
        if (this.image == null) {
            this.loadImage();
        }
        if (this.image != null) {
            width += this.image.getWidth(null);
        }
        return width;
    }

    public int getPreferredHeight() {
        int height = this.insets.top + this.insets.bottom;
        if (this.image == null) {
            this.loadImage();
        }
        if (this.image != null) {
            height += this.image.getHeight(null);
        }
        return height;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            int offset = (this.height - this.insets.top - this.insets.bottom - this.image.getHeight(null)) / 2;
            offset = Math.max(offset, 0);
            this.paintImage(g, this.insets.left, this.insets.top + offset);
        }
    }

    protected void paintImage(Graphics g, int x, int y) {
        g.drawImage(this.image, x, y, null);
    }

    protected void loadImage() {
        if (this.bundle != null) {
            MediaTracker tracker = new MediaTracker(this.diagram);
            this.image = this.bundle.getImageImpl(this.key);
            tracker.addImage(this.image, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

