/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.EditableTextComponent;
import oracle.jdevimpl.xml.schema.diagram.ListChangeListener;

public class ListComponent
extends EditableTextComponent {
    private ArrayList listeners;
    private boolean fieldEditable;
    private String[] items;
    private ListListener listListener;

    private void $init$() {
        this.listListener = new ListListener(null);
    }

    public ListComponent(Diagram diagram) {
        this(diagram, true);
    }

    public ListComponent(Diagram diagram, boolean fieldEditable) {
        super(diagram);
        this.$init$();
        this.fieldEditable = fieldEditable;
    }

    public void setItems(String[] items) {
        this.items = items;
    }

    public void setFieldEditable(boolean fieldEditable) {
        this.fieldEditable = fieldEditable;
        if (this.editor != null) {
            ((JComboBox)this.editor).setEditable(fieldEditable);
        }
    }

    public void addListChangeListener(ListChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListChangeListener(ListChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected JComponent createEditor() {
        JComboBox comboBox = new JComboBox();
        SortedComboBoxModel model = new SortedComboBoxModel();
        int i = 0;
        while (i < this.items.length) {
            model.addElement((Object)this.items[i]);
            ++i;
        }
        comboBox.setModel(model);
        comboBox.setEditable(this.fieldEditable);
        comboBox.setSelectedItem(this.text);
        comboBox.addActionListener(this.listListener);
        comboBox.addFocusListener(this.listListener);
        comboBox.addPopupMenuListener(this.listListener);
        comboBox.addKeyListener(this.listener);
        comboBox.getEditor().getEditorComponent().addKeyListener(this.listener);
        comboBox.getEditor().getEditorComponent().addFocusListener(this.listListener);
        return comboBox;
    }

    protected void destroyEditor(JComponent editor) {
        JComboBox comboBox = (JComboBox)editor;
        comboBox.removeActionListener(this.listListener);
        comboBox.removeFocusListener(this.listListener);
        comboBox.removePopupMenuListener(this.listListener);
        comboBox.removeKeyListener(this.listener);
        comboBox.getEditor().getEditorComponent().removeKeyListener(this.listener);
        comboBox.getEditor().getEditorComponent().removeFocusListener(this.listListener);
    }

    protected void focusEditor() {
        JComboBox comboBox = (JComboBox)this.editor;
        if (comboBox.isEditable()) {
            comboBox.getEditor().getEditorComponent().requestFocus();
        } else {
            comboBox.requestFocus();
        }
    }

    protected String getEditorValue() {
        return (String)((JComboBox)this.editor).getSelectedItem();
    }

    protected Rectangle getEditorBounds() {
        Rectangle bounds = super.getEditorBounds();
        Dimension prefSize = this.editor.getPreferredSize();
        bounds.width = Math.max(prefSize.width, bounds.width);
        bounds.height = Math.max(prefSize.height, bounds.height);
        return bounds;
    }

    protected void stopEditing() {
        boolean fireEvent = this.editor != null;
        super.stopEditing();
        if (fireEvent) {
            this.fireValueChanged();
        }
    }

    protected void fireValueChanged() {
        if (this.listeners != null) {
            for (ListChangeListener listener : (List)this.listeners.clone()) {
                listener.valueChanged(this);
            }
        }
    }

    private class ListListener
    implements PopupMenuListener,
    ActionListener,
    FocusListener {
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)ListComponent.this.editor;
            if (!comboBox.isPopupVisible()) {
                ListComponent.this.stopEditing();
                if (ListComponent.this.editor == null) {
                    ListComponent.this.getGlassPane().requestFocus();
                }
            }
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            SwingUtilities.invokeLater(new 1());
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void focusGained(FocusEvent fe) {
        }

        public void focusLost(FocusEvent fe) {
            if (ListComponent.this.editor != null && !((JComboBox)ListComponent.this.editor).isPopupVisible()) {
                ListComponent.this.stopEditing();
            }
        }

        private ListListener() {
        }

        ListListener(1 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            public void run() {
                ListComponent.this.stopEditing();
                if (ListComponent.this.editor == null) {
                    ListComponent.this.getGlassPane().requestFocus();
                }
            }
        }
    }
}

