/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.ProxyNode;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaLayoutView;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelUtils {
    public static final int CONTENT_TYPE_SIMPLE = 0;
    public static final int CONTENT_TYPE_COMPLEX = 1;
    public static final int CONTENT_TYPE_UNKNOWN = 2;
    private static String[] markupTable = new String[]{"&apos;", "'", "&lt;", "<", "&gt;", ">", "&quot;", "\"", "&amp;", "&"};
    private static HashMap roleMap = new HashMap();

    static {
        Integer role = new Integer(13);
        roleMap.put("key", role);
        roleMap.put("keyref", role);
        roleMap.put("unique", role);
        role = new Integer(1);
        roleMap.put("annotation", role);
        roleMap.put("documentation", role);
        role = new Integer(11);
        roleMap.put("enumeration", role);
        roleMap.put("fractionDigits", role);
        roleMap.put("length", role);
        roleMap.put("maxExclusive", role);
        roleMap.put("maxInclusive", role);
        roleMap.put("maxLength", role);
        roleMap.put("minExclusive", role);
        roleMap.put("minInclusive", role);
        roleMap.put("minLength", role);
        roleMap.put("pattern", role);
        roleMap.put("totalDigits", role);
        roleMap.put("whiteSpace", role);
        role = new Integer(14);
        roleMap.put("import", role);
        roleMap.put("include", role);
        roleMap.put("redefine", role);
        roleMap.put("all", new Integer(0));
        roleMap.put("any", new Integer(2));
        roleMap.put("anyAttribute", new Integer(3));
        roleMap.put("attribute", new Integer(4));
        roleMap.put("attributeGroup", new Integer(5));
        roleMap.put("choice", new Integer(6));
        roleMap.put("complexContent", new Integer(7));
        roleMap.put("complexType", new Integer(8));
        roleMap.put("element", new Integer(9));
        roleMap.put("extension", new Integer(10));
        roleMap.put("group", new Integer(12));
        roleMap.put("list", new Integer(15));
        roleMap.put("restriction", new Integer(16));
        roleMap.put("schema", new Integer(17));
        roleMap.put("sequence", new Integer(18));
        roleMap.put("simpleContent", new Integer(19));
        roleMap.put("simpleType", new Integer(20));
        roleMap.put("union", new Integer(21));
    }

    private ModelUtils() {
    }

    public static final String getType(Node node) {
        String type = null;
        if (node.getNodeType() == 1 && (type = ((Element)node).getAttributeNS(null, "type")) != null && type.length() == 0) {
            type = null;
        }
        return type;
    }

    public static final String getName(String qname) {
        int colon = qname.indexOf(58);
        if (colon != -1) {
            return qname.substring(colon + 1);
        }
        return qname;
    }

    public static final String getPrefix(String qname) {
        int colon = qname.indexOf(58);
        if (colon != -1) {
            return qname.substring(0, colon);
        }
        return null;
    }

    public static final boolean isElementDeclaration(Node node) {
        return ModelUtils.isType(node, "element");
    }

    public static final boolean isComplexTypeDefinition(Node node) {
        return ModelUtils.isType(node, "complexType");
    }

    public static final boolean isSimpleTypeDefinition(Node node) {
        return ModelUtils.isType(node, "simpleType");
    }

    public static final boolean isList(Node node) {
        return ModelUtils.isType(node, "list");
    }

    public static final boolean isUnion(Node node) {
        return ModelUtils.isType(node, "union");
    }

    public static final boolean isType(Node node, String type) {
        return type.equals(node.getLocalName()) && "http://www.w3.org/2001/XMLSchema".equals(node.getNamespaceURI());
    }

    public static final boolean isAttributeRole(int role) {
        return role == 3 || role == 4 || role == 5;
    }

    public static final boolean isModelGroupRole(int role) {
        return role == 0 || role == 6 || role == 18 || role == 12;
    }

    public static final boolean isContainerRole(int role) {
        return role == 7 || role == 19 || role == 10 || role == 16;
    }

    public static final String getAnnotation(TreeTraversal traversal, Node node) {
        Element documentation;
        Node ref = ModelUtils.getRef(traversal, node);
        if (ref != null) {
            return ModelUtils.getAnnotation(traversal, ref);
        }
        Element annotation = ModelUtils.getChild(node, "annotation");
        if (annotation != null && (documentation = ModelUtils.getChild(annotation, "documentation")) != null) {
            StringBuffer buffer = new StringBuffer();
            Node child = documentation.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 3) {
                    if (buffer.length() > 0) {
                        buffer.append("\n");
                    }
                    buffer.append(child.getNodeValue());
                }
                child = child.getNextSibling();
            }
            String str = buffer.toString().trim();
            if (str.length() > 0) {
                return ModelUtils.translateXmlMarkup(str);
            }
        }
        return null;
    }

    public static final Node getRef(TreeTraversal traversal, Node node) {
        ReferenceNode refNode;
        Node child = traversal.getFirstChild(node);
        if (child instanceof ReferenceNode && (refNode = (ReferenceNode)((Object)child)).getReference().getReferenceType() == 1) {
            return refNode.getReferee();
        }
        return null;
    }

    public static final boolean isGlobal(Node node) {
        Node parent = node.getParentNode();
        if (parent != null) {
            return (parent = parent.getParentNode()) != null && parent.getNodeType() == 9;
        }
        return false;
    }

    public static final Element getFirstElementChild(TreeTraversal traversal, Node node) {
        Node child = traversal.getFirstChild(node);
        while (child != null) {
            if (child.getNodeType() == 1) {
                return (Element)child;
            }
            child = traversal.getNextSibling(child);
        }
        return null;
    }

    public static final String translateXmlMarkup(String str) {
        int i = 0;
        while (i < markupTable.length) {
            Pattern apos = Pattern.compile(markupTable[i]);
            Matcher m = apos.matcher(str);
            str = m.replaceAll(markupTable[i + 1]);
            i += 2;
        }
        return str;
    }

    public static final String getName(Node node) {
        String name = null;
        if (node.getNodeType() == 1) {
            name = ModelUtils.getAttribute((Element)node, "name");
        }
        return name;
    }

    public static final String getAttribute(Element element, String name) {
        Attr attr = element.getAttributeNodeNS(null, name);
        return attr != null ? attr.getValue() : null;
    }

    public static final boolean areDifferent(Object one, Object two) {
        return one == null && two != null || one != null && two == null || one != null && !one.equals(two);
    }

    public static final boolean isAttribute(Node child) {
        String name = child.getLocalName();
        return "attribute".equals(name) || "attributeGroup".equals(name);
    }

    public static final boolean isContent(Node parent, Node child) {
        String name;
        String name2;
        int childRole = ModelUtils.getSchemaRole(child);
        int parentRole = ModelUtils.getSchemaRole(parent);
        if (ModelUtils.isContainerRole(childRole) || childRole == -1 || childRole == 1 || childRole == 11 || childRole == 13) {
            return false;
        }
        if (ModelUtils.isAttributeRole(childRole) && parentRole != 17) {
            return false;
        }
        if (childRole == 20 && (name2 = ModelUtils.getName(child)) == null && parentRole != 15 && parentRole != 21) {
            return false;
        }
        return childRole != 8 || (name = ModelUtils.getName(child)) != null;
    }

    public static final boolean hasContent(XmlView view, Node node) {
        view.acquireReadLock();
        try {
            TreeTraversal traversal = view.getTreeTraversal();
            Stack<Node> stack = new Stack<Node>();
            stack.push(node);
            while (!stack.isEmpty()) {
                ReferenceNode refNode;
                Node current = (Node)stack.pop();
                if (current instanceof ReferenceNode && ((refNode = (ReferenceNode)((Object)current)).isCyclicReference() || (current = refNode.getReferee()) == null)) continue;
                int childCount = traversal.getChildCount(current);
                int i = 0;
                while (i < childCount) {
                    Node child = traversal.getChild(current, i);
                    if (child instanceof ReferenceNode) {
                        ReferenceNode refNode2 = (ReferenceNode)((Object)child);
                        int refType = refNode2.getReference().getReferenceType();
                        if (refType != 2) {
                            stack.push(child);
                        }
                    } else if (ModelUtils.isContent(node, child)) {
                        boolean bl = true;
                        return bl;
                    }
                    ++i;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            view.releaseReadLock();
        }
    }

    public static final int getContentCount(XmlView view, Node node) {
        view.acquireReadLock();
        try {
            TreeTraversal traversal = view.getTreeTraversal();
            int count = 0;
            Node child = traversal.getFirstChild(node);
            while (child != null) {
                if (ModelUtils.isContent(node, child)) {
                    ++count;
                }
                child = traversal.getNextSibling(child);
            }
            int n = count;
            return n;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            view.releaseReadLock();
        }
    }

    public static final void toggleReference(Node node) {
        Element element = (Element)node;
        Attr ref = element.getAttributeNodeNS(null, "ref");
        Attr name = element.getAttributeNodeNS(null, "name");
        if (ref == null) {
            ModelUtils.removeContent(node);
            NamedNodeMap map = element.getAttributes();
            int length = map.getLength();
            int i = length - 1;
            while (i >= 0) {
                Attr attr = (Attr)map.item(i);
                if (!"minOccurs".equals(attr.getLocalName()) && !"maxOccurs".equals(attr.getLocalName())) {
                    element.removeAttributeNode(attr);
                }
                --i;
            }
            element.setAttributeNS(null, "ref", name.getValue());
        } else {
            element.setAttributeNS(null, "name", ModelUtils.getName(ref.getValue()));
            element.removeAttributeNS(null, "ref");
        }
    }

    public static final void removeContent(Node node) {
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        int i = length - 1;
        while (i >= 0) {
            Node child = children.item(i);
            int role = ModelUtils.getSchemaRole(child);
            if (role != 1 && role != -1) {
                node.removeChild(child);
            }
            --i;
        }
    }

    public static final void removeFacets(Node node) {
        Node restriction = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction");
        if (restriction != null) {
            NodeList children = restriction.getChildNodes();
            int length = children.getLength();
            int i = length - 1;
            while (i >= 0) {
                Node child = children.item(i);
                if (ModelUtils.getSchemaRole(child) == 11) {
                    restriction.removeChild(child);
                }
                --i;
            }
        }
    }

    public static final void copyContent(Node source, Node destination, TreeTraversal traversal, DefaultPrefixLookup prefixLookup) {
        Node current = source;
        Stack<Node> stack = new Stack<Node>();
        while (current != null) {
            ReferenceNode refNode;
            stack.push(current);
            Node child = traversal.getFirstChild(current);
            current = null;
            if (!(child instanceof ReferenceNode) || (refNode = (ReferenceNode)((Object)child)).isCyclicReference()) continue;
            current = refNode.getReferee();
        }
        Node content = null;
        boolean createdSequence = false;
        Document document = destination.getOwnerDocument();
        while (!stack.isEmpty()) {
            current = (Node)stack.pop();
            int childCount = traversal.getChildCount(current);
            int i = 0;
            while (i < childCount) {
                Node child = traversal.getChild(current, i);
                int role = ModelUtils.getSchemaRole(child);
                if (ModelUtils.isModelGroupRole(role)) {
                    Node toCopy = child;
                    if (child instanceof ProxyNode) {
                        toCopy = ((ProxyNode)child).getReferee();
                    }
                    Node childCopy = ModelUtils.copyNode(toCopy, document);
                    if (content != null) {
                        if (!createdSequence) {
                            Element sequence = document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
                            sequence.appendChild(content);
                            content = sequence;
                            createdSequence = true;
                        }
                        content.appendChild(childCopy);
                    } else {
                        content = childCopy;
                    }
                }
                ++i;
            }
        }
        if (content != null) {
            NamespaceUtils.fixPrefixes((Node)destination, content, (DefaultPrefixLookup)prefixLookup);
            destination.appendChild(content);
        }
    }

    public static final Node copyNode(Node node, Document document) {
        if (node.getOwnerDocument() == document) {
            return node.cloneNode(true);
        }
        return document.importNode(node, true);
    }

    public static final void copyAttr(Element source, Element destination, String namespace, String name) {
        Attr attr = source.getAttributeNodeNS(namespace, name);
        if (attr != null) {
            destination.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getValue());
        }
    }

    public static final int getSchemaRole(Node node) {
        if (node.getNodeType() != 1) {
            return -1;
        }
        return ModelUtils.getSchemaRole(node.getNamespaceURI(), node.getLocalName());
    }

    public static final int getSchemaRole(String namespace, String name) {
        Integer role;
        if ("http://www.w3.org/2001/XMLSchema".equals(namespace) && (role = (Integer)roleMap.get(name)) != null) {
            return role;
        }
        return -1;
    }

    public static final boolean isSimpleType(XmlSchemaModel model, Node referringNode, String qname) {
        GlobalReference reference = new GlobalReference(model.getNamespace(referringNode, qname), ModelUtils.getName(qname), 4);
        if (reference.isBuiltInType()) {
            return true;
        }
        Node node = model.resolveReference(reference);
        return node != null && ModelUtils.getSchemaRole(node) == 20;
    }

    public static final boolean hasSimpleContent(XmlSchemaModel model, Node referringNode, String qname) {
        GlobalReference reference = new GlobalReference(model.getNamespace(referringNode, qname), ModelUtils.getName(qname), 4);
        if (reference.isBuiltInType()) {
            return true;
        }
        Node node = model.resolveReference(reference);
        return node != null && ModelUtils.hasSimpleContent(node);
    }

    public static final boolean hasSimpleContent(Node node) {
        if (ModelUtils.isSimpleTypeDefinition(node)) {
            return true;
        }
        if (ModelUtils.isComplexTypeDefinition(node)) {
            Node simpleContent = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleContent");
            return simpleContent != null;
        }
        return false;
    }

    public static Node createAnonymousSimpleType(XmlSchemaModel model, Element element) {
        String base = null;
        Attr type = element.getAttributeNodeNS(null, "type");
        if (type != null) {
            base = type.getValue();
        }
        return ModelUtils.createAnonymousSimpleType(model, element, base);
    }

    public static Node createAnonymousSimpleType(XmlSchemaModel model, Element element, String base) {
        Attr type = element.getAttributeNodeNS(null, "type");
        if (type != null) {
            element.removeAttributeNode(type);
        }
        DefaultPrefixLookup prefixLookup = model.getDefaultPrefixLookup();
        Document document = element.getOwnerDocument();
        Element simpleType = document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        NamespaceUtils.fixPrefixes((Node)element, (Node)simpleType, (DefaultPrefixLookup)prefixLookup);
        element.appendChild(simpleType);
        Element target = simpleType;
        if (base != null) {
            Element restriction = document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
            restriction.setAttributeNS(null, "base", base);
            NamespaceUtils.fixPrefixes((Node)simpleType, (Node)restriction, (DefaultPrefixLookup)prefixLookup);
            simpleType.appendChild(restriction);
            target = restriction;
        }
        return target;
    }

    public static Node createAnonymousComplexTypeWithExtension(XmlSchemaModel model, Element element) {
        String base = null;
        Attr type = element.getAttributeNodeNS(null, "type");
        if (type != null) {
            base = type.getValue();
        }
        return ModelUtils.createAnonymousComplexTypeWithExtension(model, element, base);
    }

    public static Node createAnonymousComplexTypeWithExtension(XmlSchemaModel model, Element element, String base) {
        Attr type = element.getAttributeNodeNS(null, "type");
        if (type != null) {
            element.removeAttributeNode(type);
        }
        DefaultPrefixLookup prefixLookup = model.getDefaultPrefixLookup();
        Document document = element.getOwnerDocument();
        Element complexType = document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        NamespaceUtils.fixPrefixes((Node)element, (Node)complexType, (DefaultPrefixLookup)prefixLookup);
        element.appendChild(complexType);
        Element target = complexType;
        if (base != null) {
            Element complexContent;
            Element simpleContent;
            int contentType = ModelUtils.getContentType(model, element, base);
            target = contentType == 0 ? (simpleContent = document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent")) : (complexContent = document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent"));
            NamespaceUtils.fixPrefixes((Node)complexType, (Node)target, (DefaultPrefixLookup)prefixLookup);
            complexType.appendChild(target);
            Element extension = document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
            extension.setAttributeNS(null, "base", base);
            NamespaceUtils.fixPrefixes((Node)target, (Node)extension, (DefaultPrefixLookup)prefixLookup);
            target.appendChild(extension);
            target = extension;
        }
        return target;
    }

    public static Node createAnonymousComplexTypeWithRestriction(XmlSchemaModel model, Element element) {
        String base = null;
        Attr type = element.getAttributeNodeNS(null, "type");
        if (type != null) {
            base = type.getValue();
        }
        return ModelUtils.createAnonymousComplexTypeWithRestriction(model, element, base);
    }

    public static Node createAnonymousComplexTypeWithRestriction(XmlSchemaModel model, Element element, String base) {
        Attr type = element.getAttributeNodeNS(null, "type");
        if (type != null) {
            element.removeAttributeNode(type);
        }
        DefaultPrefixLookup prefixLookup = model.getDefaultPrefixLookup();
        Document document = element.getOwnerDocument();
        Element complexType = document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        NamespaceUtils.fixPrefixes((Node)element, (Node)complexType, (DefaultPrefixLookup)prefixLookup);
        element.appendChild(complexType);
        Element target = complexType;
        if (base != null) {
            GlobalReference reference;
            Node node;
            Element complexContent;
            Element simpleContent;
            int contentType = ModelUtils.getContentType(model, element, base);
            target = contentType == 0 ? (simpleContent = document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent")) : (complexContent = document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent"));
            NamespaceUtils.fixPrefixes((Node)complexType, (Node)target, (DefaultPrefixLookup)prefixLookup);
            complexType.appendChild(target);
            Element restriction = document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
            restriction.setAttributeNS(null, "base", base);
            NamespaceUtils.fixPrefixes((Node)target, (Node)restriction, (DefaultPrefixLookup)prefixLookup);
            target.appendChild(restriction);
            target = restriction;
            if (contentType == 1 && (node = model.resolveReference(reference = new GlobalReference(model.getNamespace(element, base), ModelUtils.getName(base), 4))) != null) {
                ModelUtils.copyContent(node, target, (TreeTraversal)model.getSchemaTraversal(), prefixLookup);
            }
        }
        return target;
    }

    public static final void removePath(Node from, Node to) {
        Node parent;
        Node node = to;
        do {
            if ((parent = node.getParentNode()) == null) continue;
            parent.removeChild(node);
        } while ((node = parent) != null && node != from);
    }

    public static final int getContentType(XmlSchemaModel model, Node referringNode, String qname) {
        GlobalReference reference = new GlobalReference(model.getNamespace(referringNode, qname), ModelUtils.getName(qname), 4);
        if (reference.isBuiltInType()) {
            return 0;
        }
        Node node = model.resolveReference(reference);
        if (node != null) {
            if (ModelUtils.hasSimpleContent(node)) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public static final void setBaseType(XmlSchemaLayoutView view, Node complexType, String base) {
        Node baseTypeNode = null;
        boolean isSimpleContent = false;
        GlobalReference reference = new GlobalReference(view.getNamespace(complexType, base), ModelUtils.getName(base), 4);
        baseTypeNode = view.resolveReference(reference);
        if (baseTypeNode != null) {
            isSimpleContent = ModelUtils.hasSimpleContent(baseTypeNode);
        } else if (reference.isBuiltInType()) {
            isSimpleContent = true;
        }
        boolean isRestriction = false;
        view.getBaseModel().startTransaction(XmlSchemaArb.getString(28));
        try {
            Node simpleContent = DomUtils.getNamedChild((Node)complexType, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleContent");
            Node complexContent = DomUtils.getNamedChild((Node)complexType, (String)"http://www.w3.org/2001/XMLSchema", (String)"complexContent");
            Node content = isSimpleContent ? simpleContent : complexContent;
            Node oldContent = isSimpleContent ? complexContent : simpleContent;
            Document document = complexType.getOwnerDocument();
            DefaultPrefixLookup prefixLookup = view.getBaseModel().getDefaultPrefixLookup();
            if (content == null) {
                Node restriction;
                ModelUtils.removeContent(complexType);
                content = document.createElementNS("http://www.w3.org/2001/XMLSchema", isSimpleContent ? "simpleContent" : "complexContent");
                NamespaceUtils.fixPrefixes((Node)complexType, (Node)content, (DefaultPrefixLookup)prefixLookup);
                complexType.appendChild(content);
                if (oldContent != null && (restriction = DomUtils.getNamedChild((Node)oldContent, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction")) != null) {
                    isRestriction = true;
                }
            } else {
                Node restriction = DomUtils.getNamedChild((Node)content, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction");
                if (restriction != null) {
                    isRestriction = true;
                }
            }
            Node derivationNode = null;
            if (isRestriction) {
                derivationNode = DomUtils.getNamedChild((Node)content, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction");
                if (derivationNode == null) {
                    derivationNode = document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                    NamespaceUtils.fixPrefixes((Node)content, (Node)derivationNode, (DefaultPrefixLookup)prefixLookup);
                    content.appendChild(derivationNode);
                }
                ModelUtils.removeContent(derivationNode);
                if (!isSimpleContent && baseTypeNode != null) {
                    ModelUtils.copyContent(baseTypeNode, derivationNode, view.getTreeTraversal(), prefixLookup);
                }
            } else {
                derivationNode = DomUtils.getNamedChild((Node)content, (String)"http://www.w3.org/2001/XMLSchema", (String)"extension");
                if (derivationNode == null) {
                    derivationNode = document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                    NamespaceUtils.fixPrefixes((Node)content, (Node)derivationNode, (DefaultPrefixLookup)prefixLookup);
                    content.appendChild(derivationNode);
                }
            }
            ((Element)derivationNode).setAttributeNS(null, "base", base);
            view.getBaseModel().commitTransaction();
        }
        catch (XmlCommitException xce) {
            view.getBaseModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
        }
        catch (ThreadDeath td) {
            view.getBaseModel().rollbackTransaction();
            throw td;
        }
        catch (Throwable t) {
            view.getBaseModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)t);
        }
    }

    public static final Element getChild(Node parent, String name) {
        Node node = DomUtils.getNamedChild((Node)parent, (String)"http://www.w3.org/2001/XMLSchema", (String)name);
        if (node != null && node.getNodeType() == 1) {
            return (Element)node;
        }
        return null;
    }

    public static final Node getAnonymousType(Node element) {
        Element type = ModelUtils.getChild(element, "simpleType");
        if (type == null) {
            type = ModelUtils.getChild(element, "complexType");
        }
        return type;
    }

    public static final DomPosition getAnnotationInsertionPosition(Node node) {
        int parentRole = ModelUtils.getSchemaRole(node);
        if (parentRole != 17 && parentRole != 14) {
            Node child = node.getFirstChild();
            while (child != null) {
                int role = ModelUtils.getSchemaRole(child);
                if (role != 1 && role != -1) break;
                child = child.getNextSibling();
            }
            if (child != null) {
                return DomPositionFactory.createDomPosition((Node)child, (int)1);
            }
        }
        return DomPositionFactory.createDomPosition((Node)node, (int)0);
    }
}

