/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.model.XmlCommitException;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.diagram.AttrEditor;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.EditableTextComponent;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.ListChangeListener;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelGroup;
import oracle.jdevimpl.xml.schema.diagram.TypeEditor;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NamedModelGroup
extends ModelGroup
implements ListChangeListener {
    private EditableTextComponent name;
    private static final int MINIMUM_WIDTH = 60;
    private static final int MAXIMUM_WIDTH = 200;

    public NamedModelGroup(Diagram diagram, Element element) {
        super(diagram, element);
        this.setForeground(Color.BLACK);
        this.update();
    }

    public void destroy() {
        super.destroy();
        if (this.name != null && this.name instanceof TypeEditor) {
            ((TypeEditor)this.name).removeListChangeListener(this);
        }
    }

    public int getPreferredWidth() {
        if (this.name != null) {
            int width = this.name.getPreferredWidth() + 20;
            width = Math.max(width, 60);
            width = Math.min(width, 200);
            return width;
        }
        return 0;
    }

    public int getPreferredHeight() {
        if (this.name != null) {
            return this.name.getPreferredHeight() + 6;
        }
        return 0;
    }

    public void layout() {
        if (this.name != null) {
            this.name.setBounds(10, 3, this.width - 20, this.height - 6);
        }
    }

    public void update() {
        super.update();
        if (this.name != null) {
            if (this.name instanceof TypeEditor) {
                ((TypeEditor)this.name).removeListChangeListener(this);
            }
            this.remove(this.name);
            this.name = null;
        }
        this.diagram.getView().acquireReadLock();
        try {
            Attr attr;
            ReferenceNode reference;
            int refType;
            TreeTraversal traversal = this.diagram.getView().getTreeTraversal();
            Node child = traversal.getFirstChild((Node)this.element);
            if (child instanceof ReferenceNode && (refType = (reference = (ReferenceNode)((Object)child)).getReference().getReferenceType()) == 1) {
                this.name = new TypeEditor(this.diagram, this.element, 5);
                this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
                ((TypeEditor)this.name).addListChangeListener(this);
                ((TypeEditor)this.name).setReference(reference);
                this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
                this.add(this.name);
            }
            if (this.name == null && (attr = this.element.getAttributeNodeNS(null, "name")) != null) {
                this.name = new AttrEditor(this.diagram, attr);
                this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
                this.add(this.name);
            }
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    public void valueChanged(ListComponent component) {
        if (component == this.name) {
            this.handleNameChange();
        }
    }

    private void handleNameChange() {
        String value = this.name.getText().trim();
        this.diagram.getModel().startTransaction(XmlSchemaArb.getString(22));
        try {
            Attr attr = ((TypeEditor)this.name).getAttr();
            attr.setValue(value);
            this.diagram.getModel().commitTransaction();
        }
        catch (XmlCommitException xce) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
        }
        catch (ThreadDeath td) {
            this.diagram.getModel().rollbackTransaction();
            throw td;
        }
        catch (Throwable t) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)t);
        }
    }
}

