/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Point;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import org.w3c.dom.Element;

public class ReferenceComponent
extends DiagramSchemaComponent {
    private TextComponent name;
    private static int MAXIMUM_WIDTH = 200;

    public ReferenceComponent(Diagram diagram, Element element) {
        super(diagram, element);
        this.name = new TextComponent(diagram);
        this.name.setText(element.getAttributeNS(null, "name"));
        this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
        this.add(this.name);
    }

    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        this.name.setForeground(foreground);
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        this.name.setBackground(background);
    }

    public void update() {
        super.update();
        if (this.name != null) {
            this.name.setText(this.element.getAttributeNS(null, "name"));
        }
    }

    public int getPreferredWidth() {
        int width = this.insets.left + this.name.getPreferredWidth() + this.insets.right;
        width = Math.min(width, MAXIMUM_WIDTH);
        return width;
    }

    public int getPreferredHeight() {
        return this.insets.top + this.name.getPreferredHeight() + this.insets.bottom;
    }

    public void layout() {
        this.name.setBounds(this.insets.left, this.insets.top, this.width - this.insets.left - this.insets.right, this.height - this.insets.top - this.insets.bottom);
    }

    public DomPosition getDomPosition(Point p) {
        return null;
    }
}

