/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import oracle.bali.xml.model.XmlCommitException;
import oracle.jdevimpl.xml.schema.XmlSchemaLayoutView;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.EditableTextComponent;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SchemaRootComponent
extends HierarchalSchemaComponent
implements TextListener {
    private static final String DEFAULT_NAMESPACE = XmlSchemaArb.getString(46);
    private TextComponent name;
    private TextComponent label;
    private EditableTextComponent targetNamespace;

    public SchemaRootComponent(Diagram diagram, Element element) {
        super(diagram, element);
        this.setExpandable(false);
        this.name = new TextComponent(diagram);
        this.name.setInsets(new Insets(3, 10, 3, 10));
        this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
        this.name.setText("<schema>");
        this.add(this.name);
        this.label = new TextComponent(diagram);
        this.label.setInsets(new Insets(2, 3, 2, 3));
        this.label.setText("targetNamespace");
        this.add(this.label);
        this.targetNamespace = new EditableTextComponent(diagram);
        this.targetNamespace.setInsets(new Insets(2, 3, 2, 3));
        this.targetNamespace.addTextListener(this);
        this.add(this.targetNamespace);
        this.update();
    }

    public void destroy() {
        if (this.targetNamespace != null) {
            this.targetNamespace.removeTextListener(this);
        }
    }

    public int getChildConnectionXOffset() {
        return 15;
    }

    public int getChildConnectionYOffset() {
        return this.getPreferredHeight();
    }

    public Shape getShape() {
        int[] xpoints = new int[]{0, this.width - 6, this.width - 1, this.width - 1, 0, 0};
        int[] ypoints = new int[]{0, 0, 5, this.height - 1, this.height - 1, 0};
        return new Polygon(xpoints, ypoints, xpoints.length);
    }

    public int getPreferredWidth() {
        int width = this.name.getPreferredWidth() + 5;
        if (this.targetNamespace != null) {
            width = Math.max(width, this.label.getPreferredWidth() + this.targetNamespace.getPreferredWidth() + 1);
        }
        return width += this.insets.left + this.insets.right;
    }

    public int getPreferredHeight() {
        int height = this.name.getPreferredHeight() + this.insets.top + this.insets.bottom;
        if (this.targetNamespace != null) {
            height += Math.max(this.label.getPreferredHeight(), this.targetNamespace.getPreferredHeight()) + 1;
        }
        return height;
    }

    public void layout() {
        this.name.setBounds(this.insets.left, this.insets.top, this.width - this.insets.left - this.insets.right - 5, this.name.getPreferredHeight());
        if (this.targetNamespace != null) {
            int nsHeight = Math.max(this.label.getPreferredHeight(), this.targetNamespace.getPreferredHeight());
            this.label.setBounds(this.insets.left, this.insets.top + this.name.getHeight() + 1, this.label.getPreferredWidth(), nsHeight);
            this.targetNamespace.setBounds(this.insets.left + this.label.getWidth() + 1, this.insets.top + this.name.getHeight() + 1, this.targetNamespace.getPreferredWidth(), nsHeight);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.targetNamespace != null) {
            int y = this.insets.top + this.name.getHeight();
            g.drawLine(0, y, this.width - 1, y);
            int x = this.label.getX() + this.label.getWidth();
            g.drawLine(x, y, x, this.height - 1);
        }
        g.drawLine(this.width - 6, 0, this.width - 6, 6);
        g.drawLine(this.width - 6, 6, this.width - 1, 6);
    }

    public void update() {
        Attr attr = this.element.getAttributeNodeNS(null, "targetNamespace");
        if (attr != null) {
            this.targetNamespace.setText(attr.getValue());
        } else if (this.targetNamespace != null) {
            this.targetNamespace.setText(DEFAULT_NAMESPACE);
        }
    }

    public void textValueChanged(TextEvent e) {
        String targetNS = this.targetNamespace.getText().trim();
        Attr attr = this.element.getAttributeNodeNS(null, "targetNamespace");
        String oldNS = attr != null ? attr.getValue() : null;
        XmlSchemaLayoutView view = this.diagram.getView();
        boolean wasRemoved = false;
        view.startTransaction(XmlSchemaArb.getString(22));
        try {
            if (targetNS.length() == 0 || DEFAULT_NAMESPACE.equals(targetNS)) {
                if (attr != null) {
                    attr.getOwnerElement().removeAttributeNode(attr);
                }
                wasRemoved = true;
            } else if (attr == null) {
                this.element.setAttributeNS(null, "targetNamespace", targetNS);
            } else {
                attr.setValue(targetNS);
            }
            if (oldNS != null && !wasRemoved) {
                NamedNodeMap attributes = this.element.getAttributes();
                int i = 0;
                while (i < attributes.getLength()) {
                    Attr current = (Attr)attributes.item(i);
                    if ("http://www.w3.org/2000/xmlns/".equals(current.getNamespaceURI()) && oldNS.equals(current.getValue())) {
                        current.setValue(targetNS);
                    }
                    ++i;
                }
            }
            view.commitTransaction();
        }
        catch (XmlCommitException xce) {
            view.rollbackTransaction();
        }
        catch (ThreadDeath td) {
            view.rollbackTransaction();
            throw td;
        }
        catch (Throwable t) {
            view.rollbackTransaction();
        }
        this.update();
    }
}

