/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;

public class SchemaToolTip
extends JToolTip {
    private JLabel nameLabel;
    private MultiLineLabel annotationLabel;
    private MultiLineLabel errorLabel;

    public void updateUI() {
        super.updateUI();
        this.createLabels();
        this.nameLabel.setForeground(null);
        this.nameLabel.setBackground(null);
        this.nameLabel.setFont(this.getFont().deriveFont(1));
        this.annotationLabel.setForeground(null);
        this.annotationLabel.setBackground(null);
        this.annotationLabel.setFont(null);
        this.errorLabel.setForeground(Color.RED);
        this.errorLabel.setBackground(null);
        this.errorLabel.setFont(this.getFont().deriveFont(0));
    }

    protected void paintComponent(Graphics g) {
        Color oldColor = g.getColor();
        Insets insets = this.getInsets();
        g.setColor(this.getBackground());
        g.fillRect(insets.top, insets.left, this.getWidth() - insets.right - insets.left, this.getHeight() - insets.top - insets.bottom);
        g.setColor(oldColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension = this.getLayout().preferredLayoutSize(this);
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension = this.getLayout().minimumLayoutSize(this);
            return dimension;
        }
    }

    public void setTipText(String text) {
        int endTag;
        this.createLabels();
        String name = null;
        String annotation = text;
        String error = null;
        if (text != null && text.startsWith("%%%") && (endTag = text.indexOf("%%%", 3)) != -1) {
            annotation = "";
            name = text.substring(3, endTag);
            int errTag = text.indexOf("~~");
            if (errTag != -1) {
                error = text.substring(errTag + 2);
                if (error.length() == 0) {
                    error = null;
                }
                if (endTag + 3 < errTag) {
                    annotation = text.substring(endTag + 3, errTag);
                }
            } else {
                annotation = text.substring(endTag + 3);
            }
            if (annotation.length() == 0) {
                annotation = null;
            }
        }
        this.nameLabel.setText(name);
        this.nameLabel.setVisible(name != null);
        this.annotationLabel.setText(annotation);
        this.annotationLabel.setVisible(annotation != null);
        this.errorLabel.setText(error);
        this.errorLabel.setVisible(error != null);
        super.setTipText(text);
    }

    private void createLabels() {
        if (this.nameLabel == null) {
            this.setLayout(new BorderLayout());
            this.nameLabel = new JLabel();
            this.nameLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            this.add((Component)this.nameLabel, "North");
            this.annotationLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), null);
            this.annotationLabel.setPreferredColumns(50);
            this.annotationLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            this.add((Component)this.annotationLabel, "Center");
            this.errorLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), null);
            this.errorLabel.setPreferredColumns(50);
            this.errorLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            this.add((Component)this.errorLabel, "South");
        }
    }
}

