/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaEditorController;
import oracle.jdevimpl.xml.schema.diagram.AttrEditor;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.FacetContainer;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ListChangeListener;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import oracle.jdevimpl.xml.schema.diagram.TypeEditor;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleTypeDefinition
extends HierarchalSchemaComponent
implements ListChangeListener {
    private TextComponent name;
    private TypeEditor type;
    private TextComponent restricts;
    private FacetContainer facets;
    private static final int MINIMUM_WIDTH = 60;
    private static final int MAXIMUM_WIDTH = 200;
    private static final Color COLOR = new Color(90, 186, 90);

    public SimpleTypeDefinition(Diagram diagram, Element element) {
        super(diagram, element);
        this.setBackground(COLOR);
        this.setForeground(Color.BLACK);
        this.restricts = new TextComponent(diagram);
        this.restricts.setText(XmlSchemaArb.getString(20));
        this.restricts.setInsets(new Insets(0, 10, 2, 5));
        this.add(this.restricts);
        this.type = new TypeEditor(diagram, element, 3);
        this.type.setInsets(new Insets(0, 0, 2, 0));
        this.type.addListChangeListener(this);
        this.add(this.type);
        this.update();
    }

    public void destroy() {
        super.destroy();
        this.type.removeListChangeListener(this);
    }

    public int getPreferredWidth() {
        int width = this.name.getPreferredWidth() + 10;
        if (this.facets != null) {
            width = Math.max(width, this.facets.getPreferredWidth());
        }
        int typeWidth = this.type.getPreferredWidth() + 10;
        if (this.restricts.isVisible()) {
            typeWidth += this.restricts.getPreferredWidth();
        }
        width = Math.max(width, typeWidth);
        width += this.insets.left + this.insets.right;
        width = Math.max(width, 60);
        width = Math.min(width, 200);
        return width;
    }

    public int getPreferredHeight() {
        int typeHeight = this.type.getPreferredHeight();
        if (typeHeight == 0) {
            typeHeight = 2;
        }
        if (this.restricts.isVisible()) {
            typeHeight = Math.max(this.restricts.getPreferredHeight(), typeHeight);
        }
        int facetHeight = 0;
        if (this.facets != null) {
            facetHeight = this.facets.getPreferredHeight();
        }
        return this.insets.top + this.name.getPreferredHeight() + typeHeight + facetHeight + (facetHeight > 0 ? 1 : 0) + this.insets.bottom;
    }

    public Shape getShape() {
        int width = this.getWidth();
        int[] xpoints = new int[]{0, 5, width - 6, width - 1, width - 1, width - 2, 1, 0, 0};
        int[] ypoints = new int[]{5, 0, 0, 5, this.height - 2, this.height - 1, this.height - 1, this.height - 2, 5};
        return new Polygon(xpoints, ypoints, xpoints.length);
    }

    public void layout() {
        int w = this.width - this.insets.left - this.insets.right;
        int nameWidth = w - 10;
        this.name.setBounds(this.insets.left + 5, this.insets.top, nameWidth, this.name.getPreferredHeight());
        int y = this.insets.left;
        int typeWidth = w;
        if (this.restricts.isVisible()) {
            this.restricts.setBounds(y, this.insets.top + this.name.getHeight(), this.restricts.getPreferredWidth(), this.restricts.getPreferredHeight());
            y += this.restricts.getWidth();
            typeWidth -= this.restricts.getWidth();
        }
        this.type.setBounds(y, this.insets.top + this.name.getHeight(), typeWidth, this.type.getPreferredHeight());
        int typeHeight = Math.max(this.type.getHeight(), this.restricts.getHeight());
        if (typeHeight == 0) {
            typeHeight = 2;
        }
        if (this.facets != null) {
            this.facets.setBounds(this.insets.left, this.insets.top + this.name.getHeight() + typeHeight + 1, w, this.facets.getPreferredHeight());
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.facets != null) {
            int y = this.insets.top + this.name.getHeight() + Math.max(this.type.getHeight(), this.restricts.getHeight());
            if (this.type.getHeight() == 0) {
                y += 2;
            }
            g.drawLine(this.insets.left, y, this.width - 1, y);
        }
    }

    public void update() {
        super.update();
        if (this.name != null) {
            this.name.destroy();
            this.remove(this.name);
            this.name = null;
        }
        this.diagram.getView().acquireReadLock();
        try {
            Attr attr = this.element.getAttributeNodeNS(null, "name");
            if (attr != null) {
                this.name = new AttrEditor(this.diagram, attr);
            } else {
                this.name = new TextComponent(this.diagram);
                this.name.setText("<simpleType>");
            }
            this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
            this.name.setInsets(new Insets(3, 5, 0, 5));
            this.add(this.name);
            Node child = this.diagram.getView().getTreeTraversal().getFirstChild((Node)this.element);
            if (child instanceof ReferenceNode) {
                this.restricts.setVisible(true);
                this.type.setReference((ReferenceNode)((Object)child));
            } else {
                this.restricts.setVisible(false);
                this.type.setReference(null);
            }
            Node list = DomUtils.getNamedChild((TreeTraversal)this.diagram.getView().getTreeTraversal(), (Node)this.element, (String)"http://www.w3.org/2001/XMLSchema", (String)"list");
            Node union = DomUtils.getNamedChild((TreeTraversal)this.diagram.getView().getTreeTraversal(), (Node)this.element, (String)"http://www.w3.org/2001/XMLSchema", (String)"union");
            if (list == null && union == null) {
                if (this.facets == null) {
                    this.facets = new FacetContainer(this.diagram, this.element);
                    this.add(this.facets);
                }
            } else if (this.facets != null) {
                this.facets.destroy();
                this.remove(this.facets);
                this.facets = null;
            }
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    public List getActions() {
        ArrayList<Integer> list = new ArrayList<Integer>(3);
        list.addAll(super.getActions());
        this.diagram.getView().acquireReadLock();
        try {
            TreeTraversal traversal = this.diagram.getView().getTreeTraversal();
            Node child = traversal.getFirstChild((Node)this.element);
            if (!(child instanceof ReferenceNode)) {
                list.add(new Integer(XmlSchemaEditorController.SET_BASE_TYPE_CMD_ID));
            }
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
        return list;
    }

    public boolean handleAction(IdeAction action) {
        if (action.getCommandId() == XmlSchemaEditorController.SET_BASE_TYPE_CMD_ID) {
            this.setBaseType();
            return true;
        }
        return super.handleAction(action);
    }

    private void setBaseType() {
        this.diagram.getView().acquireReadLock();
        try {
            Attr attr = this.diagram.getView().getDocument().createAttributeNS(null, "base");
            this.type.setAttr(attr);
            this.type.startEditing();
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    public void valueChanged(ListComponent component) {
        if (component == this.type) {
            this.handleTypeChange();
        }
    }

    private void handleTypeChange() {
        String value = this.type.getText().trim();
        if (value.length() == 0) {
            this.removeType();
        } else {
            this.setType(value);
        }
    }

    private void removeType() {
        Attr attr = this.type.getAttr();
        Element owner = attr.getOwnerElement();
        if (owner != null) {
            this.diagram.getModel().startTransaction(XmlSchemaArb.getString(28));
            try {
                owner.removeAttributeNode(attr);
                if (owner != this.element) {
                    ModelUtils.removePath(this.element, owner);
                }
                this.diagram.getModel().commitTransaction();
            }
            catch (XmlCommitException xce) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
            }
            catch (ThreadDeath td) {
                this.diagram.getModel().rollbackTransaction();
                throw td;
            }
            catch (Throwable t) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)t);
            }
        } else {
            this.type.setAttr(null);
        }
    }

    private void setType(String type) {
        this.diagram.getModel().startTransaction(XmlSchemaArb.getString(28));
        try {
            Document document = this.element.getOwnerDocument();
            DefaultPrefixLookup prefixLookup = this.diagram.getView().getBaseModel().getDefaultPrefixLookup();
            Element restriction = (Element)DomUtils.getNamedChild((Node)this.element, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction");
            if (restriction == null) {
                restriction = document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                NamespaceUtils.fixPrefixes((Node)this.element, (Node)restriction, (DefaultPrefixLookup)prefixLookup);
                this.element.appendChild(restriction);
            }
            restriction.setAttributeNS(null, "base", type);
            ModelUtils.removeFacets(this.element);
            this.diagram.getModel().commitTransaction();
        }
        catch (XmlCommitException xce) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
        }
        catch (ThreadDeath td) {
            this.diagram.getModel().rollbackTransaction();
            throw td;
        }
        catch (Throwable t) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)t);
        }
    }
}

