/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.model.XmlView;
import oracle.jdevimpl.xml.schema.NodeListener;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.Expandable;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.IconicModelGroup;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.ReferenceSubtree;
import oracle.jdevimpl.xml.schema.diagram.TopLevelComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Subtree
extends DiagramComponent
implements Expandable,
NodeListener {
    protected TopLevelComponent root;
    protected Subtree[] subtrees;
    protected boolean expanded;
    protected static final int PARENT_CHILD_SPACING = 20;
    protected static final int SIBLING_SPACING = 5;
    private static final Object EXPANDED = new Object();
    protected int layoutWidth;
    protected int layoutHeight;
    private int a;
    private int b;
    private int rootChildCount;

    private void $init$() {
        this.layoutWidth = -1;
        this.layoutHeight = -1;
        this.rootChildCount = -1;
    }

    public Subtree(Diagram diagram, TopLevelComponent root) {
        super(diagram);
        this.$init$();
        this.root = root;
        this.add(root);
        if (root.getComponent() instanceof IconicModelGroup) {
            this.setExpanded(true);
        }
        this.rootChildCount = ModelUtils.getContentCount((XmlView)diagram.getView(), root.getComponent().getDomElement());
        diagram.getView().addNodeListener(root.getComponent().getDomElement(), this);
    }

    public void destroy() {
        super.destroy();
        this.destroySubtrees();
        this.root.destroy();
        this.diagram.getView().removeNodeListener(this.root.getComponent().getDomElement(), this);
    }

    public void nodeChanged(Node node) {
        this.update();
    }

    public void referenceChanged(Node node) {
        this.update();
    }

    public TopLevelComponent getRoot() {
        return this.root;
    }

    public void update() {
        this.expandIfNodesAdded();
        if (this.expanded || this.subtrees != null) {
            Map state = this.saveExpansionState();
            this.destroySubtrees();
            this.createSubtrees();
            this.restoreExpansionState(state);
        }
    }

    public int getPreferredWidth() {
        if (this.layoutWidth == -1) {
            this.computeSizes();
        }
        return this.layoutWidth;
    }

    public int getPreferredHeight() {
        if (this.layoutWidth == -1) {
            this.computeSizes();
        }
        return this.layoutHeight;
    }

    public Color getBackground() {
        if (this.parent != null) {
            return this.parent.getBackground();
        }
        return super.getBackground();
    }

    public Subtree getFirstSubtree() {
        if (this.subtrees == null) {
            this.createSubtrees();
        }
        return this.subtrees.length == 0 ? null : this.subtrees[0];
    }

    public Subtree getNextSubtree(Subtree subtree) {
        if (this.subtrees.length == 1) {
            return null;
        }
        int index = this.getIndexOf(subtree);
        if (index == -1) {
            return null;
        }
        return index < this.subtrees.length - 1 ? this.subtrees[index + 1] : this.subtrees[0];
    }

    public Subtree getPreviousSubtree(Subtree subtree) {
        if (this.subtrees.length == 1) {
            return null;
        }
        int index = this.getIndexOf(subtree);
        if (index == -1) {
            return null;
        }
        return index > 0 ? this.subtrees[index - 1] : this.subtrees[this.subtrees.length - 1];
    }

    protected void computeSizes() {
        this.layoutWidth = this.insets.left + (this.root.isVisible() ? this.root.getPreferredWidth() : 0) + this.insets.right;
        if (this.expanded && this.subtrees.length > 0) {
            this.layoutWidth = this.subtrees.length == 1 ? (this.layoutWidth += 10) : (this.layoutWidth += 20);
            int maxSubtreeWidth = 0;
            this.a = this.root.isVisible() ? this.root.getChildConnectionYOffset() : 0;
            this.b = 0;
            int totalSubtreeHeight = 0;
            int i = 0;
            while (i < this.subtrees.length) {
                if (this.subtrees[i].getPreferredWidth() > maxSubtreeWidth) {
                    maxSubtreeWidth = this.subtrees[i].getPreferredWidth();
                }
                totalSubtreeHeight += this.subtrees[i].getPreferredHeight();
                this.b = i == this.subtrees.length - 1 ? (this.b += this.subtrees[i].getConnectionYOffset()) : (this.b += this.subtrees[i].getPreferredHeight());
                if (i == 0) {
                    this.b -= this.subtrees[i].getConnectionYOffset();
                }
                ++i;
            }
            this.layoutWidth += maxSubtreeWidth;
            int spacing = 5 * (this.subtrees.length - 1);
            this.b += spacing;
            this.b = this.b / 2 + this.subtrees[0].getConnectionYOffset();
            int c = this.root.isVisible() ? this.root.getPreferredHeight() - this.a : 0;
            int d = (totalSubtreeHeight += spacing) - this.b;
            this.layoutHeight = this.insets.top + Math.max(this.a, this.b) + Math.max(c, d) + this.insets.bottom;
        } else {
            this.b = 0;
            this.a = 0;
            this.layoutWidth = this.insets.left + this.root.getPreferredWidth() + this.insets.right;
            this.layoutHeight = this.insets.top + this.root.getPreferredHeight() + this.insets.bottom;
        }
    }

    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.expanded && this.subtrees.length > 0) {
            this.paintEdges(g);
        }
    }

    protected void paintEdges(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        int x = this.root.isVisible() ? this.root.getX() + this.root.getChildConnectionXOffset() : this.insets.left;
        int y = this.root.isVisible() ? this.root.getY() + this.root.getChildConnectionYOffset() : this.b + this.insets.top;
        int i = 0;
        while (i < this.subtrees.length) {
            Subtree subtree = this.subtrees[i];
            Stroke stroke = subtree.getRoot().getStroke();
            Stroke originalStroke = null;
            if (stroke != null) {
                originalStroke = graphics.getStroke();
                graphics.setStroke(stroke);
            }
            int x1 = x;
            int y1 = y;
            int x2 = this.root.isVisible() ? (this.root.getX() + this.root.getWidth() + subtree.getX()) / 2 : (x + subtree.getX()) / 2;
            int y2 = y1;
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y2 = subtree.getY() + subtree.getConnectionYOffset();
            g.drawLine(x1, y1, x2, y2);
            y1 = y2;
            x2 = subtree.getX() + subtree.getConnectionXOffset();
            g.drawLine(x1, y1, x2, y2);
            if (originalStroke != null) {
                graphics.setStroke(originalStroke);
            }
            ++i;
        }
    }

    public void layout() {
        int y;
        if (this.layoutWidth == -1) {
            this.computeSizes();
        }
        if (this.expanded && this.subtrees.length > 0) {
            if (this.a > this.b) {
                this.root.setBounds(this.insets.left, this.insets.top, this.root.getPreferredWidth(), this.root.getPreferredHeight());
                y = this.insets.top + this.a - this.b;
            } else {
                this.root.setBounds(this.insets.left, this.insets.top + this.b - this.a, this.root.getPreferredWidth(), this.root.getPreferredHeight());
                y = this.insets.top;
            }
        } else {
            this.root.setBounds(this.insets.left, this.insets.top, this.root.getPreferredWidth(), this.root.getPreferredHeight());
            y = 0;
        }
        if (this.expanded) {
            int x = this.insets.left + (this.root.isVisible() ? this.root.getWidth() : 0) + (this.subtrees.length > 1 ? 20 : 10);
            int i = 0;
            while (i < this.subtrees.length) {
                this.subtrees[i].setBounds(x, y, this.subtrees[i].getPreferredWidth(), this.subtrees[i].getPreferredHeight());
                y += this.subtrees[i].getHeight();
                if (i < this.subtrees.length - 1) {
                    y += 5;
                }
                ++i;
            }
        }
    }

    public int getConnectionXOffset() {
        return this.insets.left + (this.root.isVisible() ? this.root.getParentConnectionXOffset() : 0);
    }

    public int getConnectionYOffset() {
        if (this.layoutWidth == -1) {
            this.computeSizes();
        }
        if (this.expanded && this.subtrees.length > 0) {
            if (this.a > this.b) {
                return this.insets.top + this.a;
            }
            return this.insets.top + this.b;
        }
        return this.insets.top + this.root.getChildConnectionYOffset();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        if (expanded != this.expanded) {
            this.expanded = expanded;
            if (expanded && this.subtrees == null) {
                this.createSubtrees();
            }
            if (this.subtrees != null) {
                int i = 0;
                while (i < this.subtrees.length) {
                    this.subtrees[i].setVisible(expanded);
                    ++i;
                }
                this.invalidate();
            }
        }
    }

    public void expandAll() {
        this.setExpanded(true);
        int i = 0;
        while (i < this.subtrees.length) {
            this.subtrees[i].expandAll();
            ++i;
        }
    }

    public void invalidate() {
        super.invalidate();
        this.layoutWidth = -1;
    }

    public int getChildCount() {
        if (this.subtrees == null) {
            this.createSubtrees();
        }
        return super.getChildCount();
    }

    public DiagramComponent getChild(int index) {
        if (this.subtrees == null) {
            this.createSubtrees();
        }
        return super.getChild(index);
    }

    protected void createSubtrees() {
        XmlView view = this.diagram.getGui().getView();
        view.acquireReadLock();
        try {
            TreeTraversal traversal = view.getTreeTraversal();
            Element rootNode = this.root.getComponent().getDomElement();
            int count = traversal.getChildCount((Node)rootNode);
            ArrayList<DiagramComponent> subtreeList = new ArrayList<DiagramComponent>(count);
            int i = 0;
            while (i < count) {
                HierarchalSchemaComponent component;
                DiagramComponent subtree = null;
                Node child = traversal.getChild((Node)rootNode, i);
                if (child instanceof ReferenceNode) {
                    ReferenceNode refNode = (ReferenceNode)((Object)child);
                    int refType = refNode.getReference().getReferenceType();
                    if (refType != 2 && ModelUtils.hasContent(view, child) && !refNode.isCyclicReference()) {
                        subtree = new ReferenceSubtree(this.diagram, refNode);
                    }
                } else if (ModelUtils.isContent(rootNode, child) && (component = this.diagram.getComponentFactory().createSchemaComponent(this.diagram, child)) != null) {
                    subtree = new Subtree(this.diagram, new TopLevelComponent(this.diagram, component));
                }
                if (subtree != null) {
                    subtree.setVisible(this.expanded);
                    subtreeList.add(subtree);
                    this.add(subtree);
                }
                ++i;
            }
            this.subtrees = subtreeList.toArray(new Subtree[subtreeList.size()]);
        }
        finally {
            view.releaseReadLock();
        }
    }

    private void destroySubtrees() {
        if (this.subtrees == null) {
            return;
        }
        int i = 0;
        while (i < this.subtrees.length) {
            this.remove(this.subtrees[i]);
            this.subtrees[i].destroy();
            ++i;
        }
        this.subtrees = null;
    }

    public DomPosition getDomPosition(Point p) {
        Rectangle bounds = new Rectangle();
        if (this.root.isVisible()) {
            if ((bounds = this.root.getBounds(bounds)).contains(p)) {
                p.translate(-this.root.x, -this.root.y);
                return this.root.getDomPosition(p);
            }
            if (this.parent != null && p.getX() < bounds.getX() + bounds.getWidth()) {
                return DomPositionFactory.createDomPosition((Node)this.root.getComponent().getDomElement(), (int)(p.getY() < bounds.getY() ? 1 : 2));
            }
        }
        if (this.expanded) {
            int i = 0;
            while (i < this.subtrees.length) {
                bounds = this.subtrees[i].getBounds(bounds);
                if (p.getY() < bounds.getY() + bounds.getHeight() + 2.0 || i == this.subtrees.length - 1) {
                    p.translate(-this.subtrees[i].x, -this.subtrees[i].y);
                    return this.subtrees[i].getDomPosition(p);
                }
                ++i;
            }
        }
        return null;
    }

    public Shape getDomPositionShape(DiagramComponent component, int relativePosition) {
        Shape shape = null;
        if (relativePosition == 1) {
            Rectangle bounds = component.getBounds(null);
            return new Line2D.Double(bounds.getX(), bounds.getY() - 2.0, bounds.getX() + bounds.getWidth(), bounds.getY() - 2.0);
        }
        if (relativePosition == 2) {
            Rectangle bounds = component.getBounds(null);
            return new Line2D.Double(bounds.getX(), bounds.getY() + bounds.getHeight() + 2.0, bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight() + 2.0);
        }
        shape = super.getDomPositionShape(component, relativePosition);
        return shape;
    }

    private int getIndexOf(Subtree subtree) {
        int i = 0;
        while (i < this.subtrees.length) {
            if (this.subtrees[i] == subtree) break;
            ++i;
        }
        return i == this.subtrees.length ? -1 : i;
    }

    private void expandIfNodesAdded() {
        int oldCount = this.rootChildCount;
        this.rootChildCount = ModelUtils.getContentCount((XmlView)this.diagram.getView(), this.root.getComponent().getDomElement());
        if (oldCount != -1 && this.rootChildCount > oldCount) {
            this.expanded = true;
        }
    }

    private Map saveExpansionState() {
        HashMap state = new HashMap();
        this.saveExpansionState(this, "", state);
        return state;
    }

    private void saveExpansionState(Subtree tree, String prefix, Map state) {
        String hash = prefix + "%" + this.getHash(tree.getRoot().getComponent().getDomElement());
        if (tree.isExpanded()) {
            state.put(hash, EXPANDED);
        } else {
            state.put(hash, new Integer(tree.rootChildCount));
        }
        if (tree.subtrees != null) {
            int i = 0;
            while (i < tree.subtrees.length) {
                this.saveExpansionState(tree.subtrees[i], hash, state);
                ++i;
            }
        }
    }

    private void restoreExpansionState(Map state) {
        this.restoreExpansionState(this, "", state);
    }

    private void restoreExpansionState(Subtree tree, String prefix, Map state) {
        int count;
        String hash = prefix + "%" + this.getHash(tree.getRoot().getComponent().getDomElement());
        Object value = state.get(hash);
        if (value == EXPANDED) {
            tree.setExpanded(true);
        } else if (value instanceof Integer && (count = ((Integer)value).intValue()) != -1 && tree.rootChildCount > count) {
            tree.setExpanded(true);
        }
        if (tree.subtrees != null) {
            int i = 0;
            while (i < tree.subtrees.length) {
                this.restoreExpansionState(tree.subtrees[i], hash, state);
                ++i;
            }
        }
    }

    private String getHash(Element element) {
        StringBuffer hash = new StringBuffer();
        hash.append(element.getLocalName());
        String name = element.getAttributeNS(null, "name");
        if (name != null && name.length() > 0) {
            hash.append("%name=");
            hash.append(name);
        } else {
            String ref = element.getAttributeNS(null, "ref");
            if (ref != null && ref.length() > 0) {
                hash.append("%ref=");
                hash.append(ref);
            }
        }
        String type = element.getAttributeNS(null, "type");
        if (type != null && type.length() > 0) {
            hash.append("%type=");
            hash.append(type);
        }
        return hash.toString();
    }
}

