/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;

public class TextComponent
extends DiagramComponent {
    protected String text;
    private int prefWidth;
    private int prefHeight;
    private int textX;
    private int textY;
    private String clippedText;
    protected Font font;

    private void $init$() {
        this.prefWidth = -1;
        this.textX = -1;
    }

    public TextComponent(Diagram diagram) {
        super(diagram);
        this.$init$();
        this.font = GraphicsUtils.getDiagramFont();
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.invalidate();
        this.repaint();
    }

    public void invalidate() {
        super.invalidate();
        this.prefWidth = -1;
        this.textX = -1;
    }

    public int getPreferredWidth() {
        if (this.prefWidth == -1) {
            this.cachePreferredSize();
        }
        return this.prefWidth;
    }

    public int getPreferredHeight() {
        if (this.prefWidth == -1) {
            this.cachePreferredSize();
        }
        return this.prefHeight;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.text != null) {
            if (this.textX == -1) {
                this.cachePaintOffsets(g);
            }
            Font oldFont = g.getFont();
            Color oldColor = g.getColor();
            g.setFont(this.font);
            g.setColor(this.getForeground());
            GraphicUtils.drawString((Graphics)g, (String)this.clippedText, (int)this.textX, (int)this.textY);
            g.setColor(oldColor);
            g.setFont(oldFont);
        }
    }

    private void cachePreferredSize() {
        if (this.text == null || this.text.length() == 0) {
            this.prefWidth = 0;
            this.prefHeight = 0;
        } else {
            boolean useAA = GraphicUtils.useTextAntialiasing();
            FontRenderContext frc = new FontRenderContext(null, useAA, false);
            TextLayout layout = new TextLayout(this.text, this.font, frc);
            this.prefWidth = this.insets.left + (int)((double)layout.getAdvance() + 0.5) + this.insets.right;
            int textHeight = (int)((double)(layout.getAscent() + layout.getDescent()) + 0.5);
            this.prefHeight = this.insets.top + textHeight + this.insets.bottom + 1;
        }
    }

    private void cachePaintOffsets(Graphics g) {
        FontMetrics metrics = g.getFontMetrics(this.font);
        Rectangle textRectangle = new Rectangle(0, 0, 0, 0);
        Rectangle viewRectangle = new Rectangle(this.insets.left, this.insets.top, this.getWidth() - this.insets.left - this.insets.right, this.getHeight() - this.insets.top - this.insets.bottom);
        this.clippedText = SwingUtilities.layoutCompoundLabel(metrics, this.text, null, 0, 2, 1, 2, viewRectangle, new Rectangle(0, 0, 0, 0), textRectangle, 0);
        this.textX = textRectangle.x;
        this.textY = textRectangle.y + metrics.getAscent();
    }
}

